package com.commonsware.todo.ui.display

import android.text.format.DateUtils
import androidx.lifecycle.LiveData
import androidx.lifecycle.MediatorLiveData
import androidx.lifecycle.ViewModel
import com.commonsware.todo.repo.ToDoModel
import com.commonsware.todo.repo.ToDoRepository

data class DisplayViewState(
  val item: ToDoModel
)

class DisplayMotor(repo: ToDoRepository, id: String) : ViewModel() {
  private val _states = MediatorLiveData<DisplayViewState>()
  val states: LiveData<DisplayViewState> = _states

  init {
    _states.addSource(repo.forId(id)) {
      _states.postValue(states.value?.copy(item = it) ?: DisplayViewState(it))
    }
  }
}
