package com.commonsware.todo.ui.edit

import android.os.Bundle
import android.view.*
import androidx.fragment.app.Fragment
import androidx.lifecycle.observe
import androidx.navigation.fragment.findNavController
import androidx.navigation.fragment.navArgs
import com.commonsware.todo.R
import com.commonsware.todo.databinding.TodoEditBinding
import com.commonsware.todo.ui.util.hideKeyboard
import org.koin.androidx.viewmodel.ext.android.viewModel
import org.koin.core.parameter.parametersOf

class EditFragment : Fragment() {
  private lateinit var binding: TodoEditBinding
  private val args: EditFragmentArgs by navArgs()
  private val motor: EditMotor by viewModel { parametersOf(args.modelId) }

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)

    setHasOptionsMenu(true)
  }

  override fun onCreateView(
    inflater: LayoutInflater,
    container: ViewGroup?,
    savedInstanceState: Bundle?
  ) = TodoEditBinding.inflate(inflater, container, false)
    .apply { binding = this }
    .root

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)

    binding.motor = motor
    binding.lifecycleOwner = this

    motor.events.observe(this) { _ -> navToList() }
  }

  override fun onCreateOptionsMenu(menu: Menu, inflater: MenuInflater) {
    super.onCreateOptionsMenu(menu, inflater)

    inflater.inflate(R.menu.actions_edit, menu)
  }

  override fun onOptionsItemSelected(item: MenuItem): Boolean {
    when (item.itemId) {
      R.id.save -> return save()
      R.id.delete -> return delete()
    }

    return super.onOptionsItemSelected(item)
  }

  private fun save(): Boolean {
    val state = motor.states.value

    state?.let {
      val model = state.item.copy(
        description = binding.desc.text.toString(),
        isCompleted = binding.isCompleted.isChecked,
        notes = binding.notes.text.toString()
      )

      motor.save(model)
    }

    return true
  }

  private fun delete(): Boolean {
    motor.delete()

    return true
  }

  private fun navToList() {
    hideKeyboard()
    findNavController().popBackStack(R.id.rosterFragment, false)
  }
}