package com.commonsware.todo.ui.edit

import androidx.lifecycle.*
import com.commonsware.todo.repo.ToDoModel
import com.commonsware.todo.repo.ToDoRepository
import com.commonsware.todo.ui.util.SimpleEvent
import kotlinx.coroutines.launch

data class EditViewState(
  val item: ToDoModel
)

class EditMotor(private val repo: ToDoRepository, id: String?) : ViewModel() {
  private val _states = MediatorLiveData<EditViewState>()
  val states: LiveData<EditViewState> = _states
  private val _events = MutableLiveData<SimpleEvent>()
  val events: LiveData<SimpleEvent> = _events

  init {
    if (id == null) {
      _states.postValue(EditViewState(ToDoModel()))
    }
    else {
      _states.addSource(repo.forId(id)) {
        _states.postValue(states.value?.copy(item = it) ?: EditViewState(it))
      }
    }
  }

  fun save(model: ToDoModel) {
    viewModelScope.launch {
      repo.save(model)
      _events.postValue(SimpleEvent())
    }
  }

  fun delete() {
    states.value?.let {
      viewModelScope.launch {
        repo.delete(it.item)
        _events.postValue(SimpleEvent())
      }
    }
  }
}
