package com.commonsware.todo.ui.roster

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.ListAdapter
import com.commonsware.todo.databinding.TodoRowBinding
import com.commonsware.todo.repo.ToDoModel

class RosterAdapter(
  private val inflater: LayoutInflater,
  private val onRowClick: (ToDoModel) -> Unit
) :
  ListAdapter<ToDoModel, RosterRowHolder>(ToDoModel.DiffCallback) {
  override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) =
    RosterRowHolder(
      TodoRowBinding.inflate(inflater, parent, false),
      onRowClick
    )

  override fun onBindViewHolder(holder: RosterRowHolder, position: Int) {
    holder.bind(getItem(position))
  }
}