package com.commonsware.todo.ui.roster

import androidx.lifecycle.LiveData
import androidx.lifecycle.MediatorLiveData
import androidx.lifecycle.ViewModel
import com.commonsware.todo.repo.ToDoModel
import com.commonsware.todo.repo.ToDoRepository

data class RosterViewState(
  val items: List<ToDoModel> = listOf()
)

class RosterMotor(private val repo: ToDoRepository) : ViewModel() {
  private val _states = MediatorLiveData<RosterViewState>().apply {
    value = RosterViewState()
  }
  val states: LiveData<RosterViewState> = _states

  init {
    _states.addSource(repo.all()) { _states.postValue(state().copy(items = it)) }
  }

  private fun state() = states.value!!
}