package com.commonsware.todo.ui.roster

import androidx.recyclerview.widget.RecyclerView
import com.commonsware.todo.databinding.TodoRowBinding
import com.commonsware.todo.repo.ToDoModel

class RosterRowHolder(
  private val binding: TodoRowBinding,
  onRowClick: (ToDoModel) -> Unit
) :
  RecyclerView.ViewHolder(binding.root) {
  init {
    binding.root.setOnClickListener { binding.model?.let { onRowClick(it) } }
  }

  fun bind(model: ToDoModel) {
    binding.model = model
    binding.executePendingBindings()
  }
}