package com.commonsware.todo.ui.util

open class Event<out T>(private val content: T) {
  var hasBeenHandled = false
    private set

  fun handle(handler: (T) -> Unit) {
    if (!hasBeenHandled) {
      hasBeenHandled = true
      handler(content)
    }
  }
}

class SimpleEvent : Event<Unit>(Unit) {
  operator fun invoke(handler: () -> Unit) = handle { handler() }
}
