package com.commonsware.todo.ui.util

import android.view.inputmethod.InputMethodManager
import androidx.core.content.getSystemService
import androidx.fragment.app.Fragment

fun Fragment.hideKeyboard() {
  view?.let {
    val imm = context?.getSystemService<InputMethodManager>()

    imm?.hideSoftInputFromWindow(
      it.windowToken,
      InputMethodManager.HIDE_NOT_ALWAYS
    )
  }
}