package com.example.sample.paging

import androidx.annotation.WorkerThread
import androidx.paging.PageKeyedDataSource

class IntDataSource : PageKeyedDataSource<Int, Int>() {
    @WorkerThread
    override fun loadInitial(params: LoadInitialParams<Int>, callback: LoadInitialCallback<Int, Int>) {
        callback.onResult((0 until params.requestedLoadSize).toList(), null, 1)
    }

    @WorkerThread
    override fun loadAfter(params: LoadParams<Int>, callback: LoadCallback<Int, Int>) {
        val start = params.key * params.requestedLoadSize
        val end = start + params.requestedLoadSize

        callback.onResult((start until end).toList(), params.key + 1)
    }

    @WorkerThread
    override fun loadBefore(params: LoadParams<Int>, callback: LoadCallback<Int, Int>) {
    }
}
