/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;

@KeepForSubclassing
public interface ClassFileConsumer
extends ProgramConsumer {
    public void accept(ByteDataView var1, String var2, DiagnosticsHandler var3);

    public static ClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    @Keep
    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, ClassFileConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, ClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResouces ? this : null;
        }

        @Override
        public void accept(ByteDataView data, String descriptor, DiagnosticsHandler handler) {
            super.accept(data, descriptor, handler);
            this.outputBuilder.addFile(ArchiveConsumer.getClassFileName(descriptor), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResouces) {
            this(archive, null, consumeDataResouces);
        }

        public ArchiveConsumer(Path archive, ClassFileConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, ClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResouces;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(ByteDataView data, String descriptor, DiagnosticsHandler handler) {
            super.accept(data, descriptor, handler);
            this.outputBuilder.addFile(ArchiveConsumer.getClassFileName(descriptor), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }

        private static String getClassFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".class";
        }

        public static void writeResources(Path archive, List<ProgramResource> resources, Set<DataEntryResource> dataResources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (ProgramResource resource : resources) {
                    assert (resource.getClassDescriptors().size() == 1);
                    String className = resource.getClassDescriptors().iterator().next();
                    String entryName = ArchiveConsumer.getClassFileName(className);
                    byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes, 8);
                }
                for (DataEntryResource dataResource : dataResources) {
                    String entryName = dataResource.getName();
                    byte[] bytes = ByteStreams.toByteArray(closer.register(dataResource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes, 8);
                }
            }
        }
    }

    @Keep
    public static class ForwardingConsumer
    implements ClassFileConsumer {
        private static final ClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final ClassFileConsumer consumer;

        public ForwardingConsumer(ClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(ByteDataView data, String descriptor, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(data, descriptor, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

