/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

public abstract class OptionalBool {
    private static final OptionalBool TRUE = new OptionalBool(){

        @Override
        public boolean isTrue() {
            return true;
        }

        public String toString() {
            return "true";
        }
    };
    private static final OptionalBool FALSE = new OptionalBool(){

        @Override
        public boolean isFalse() {
            return true;
        }

        public String toString() {
            return "false";
        }
    };
    private static final OptionalBool UNKNOWN = new OptionalBool(){

        @Override
        public boolean isUnknown() {
            return true;
        }

        public String toString() {
            return "unknown";
        }
    };

    public static OptionalBool of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static OptionalBool unknown() {
        return UNKNOWN;
    }

    private OptionalBool() {
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isPossiblyTrue() {
        return !this.isFalse();
    }

    public boolean isPossiblyFalse() {
        return !this.isTrue();
    }

    public boolean getBooleanValue() {
        if (this.isUnknown()) {
            throw new IllegalStateException("Attempt to convert unknown value to a boolean");
        }
        return this.isTrue();
    }
}

