/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.StringResource;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PrintClassList {
    public static void main(String[] args) throws IOException, ExecutionException {
        List<String> dexFiles = Arrays.asList(args);
        AndroidApp.Builder builder = AndroidApp.builder();
        Path proguardMapFile = null;
        if (args[0].endsWith("map")) {
            proguardMapFile = Paths.get(args[0], new String[0]);
            dexFiles = dexFiles.subList(1, dexFiles.size());
        }
        builder.addProgramFiles(ListUtils.map(dexFiles, x$0 -> Paths.get(x$0, new String[0])));
        ExecutorService executorService = Executors.newCachedThreadPool();
        DexApplication application = new ApplicationReader(builder.build(), new InternalOptions(), new Timing("PrintClassList")).read(proguardMapFile == null ? null : StringResource.fromFile(proguardMapFile), executorService);
        ClassNameMapper map2 = application.getProguardMap();
        for (DexProgramClass clazz : application.classes()) {
            System.out.print(PrintClassList.maybeDeobfuscateType(map2, clazz.type));
            System.out.println();
            clazz.forEachMethod(method -> PrintClassList.printMethod(method, map2));
            clazz.forEachField(field -> PrintClassList.printField(field, map2));
        }
        executorService.shutdown();
    }

    private static void printMethod(DexEncodedMethod encodedMethod, ClassNameMapper map2) {
        DexMethod method = encodedMethod.method;
        if (map2 != null) {
            System.out.println(map2.originalNameOf(method));
        } else {
            MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(method);
            System.out.println(method.holder.toSourceString() + " " + signature);
        }
    }

    private static void printField(DexEncodedField encodedField, ClassNameMapper map2) {
        DexField field = encodedField.field;
        if (map2 != null) {
            System.out.println(map2.originalNameOf(field));
        } else {
            MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(field.name.toSourceString(), field.type.toSourceString());
            System.out.println(field.holder.toSourceString() + " " + signature);
        }
    }

    private static String maybeDeobfuscateType(ClassNameMapper map2, DexType type) {
        return map2 == null ? type.toSourceString() : map2.originalNameOf(type);
    }
}

