/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.AppliedGraphLens;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.NestBasedAccessDesugaringAnalysis;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.ir.optimize.UninstantiatedTypeOptimization;
import com.android.tools.r8.ir.optimize.UnusedArgumentsCollector;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapMinifier;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.naming.SourceFileRewriter;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.optimize.ClassAndMemberPublicizer;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexClasses;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.StaticClassMerger;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.CollectionUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SelfRetraceTest;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.VersionProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Keep
public class R8 {
    private final Timing timing = new Timing("R8");
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        options.itemFactory.resetSortedIndices();
    }

    public static void run(R8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        R8.runForTesting(app, options);
    }

    public static void run(R8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> R8.run(app, options, executor));
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        Marker marker = new Marker(Marker.Tool.R8).setVersion("1.5.37").setCompilationMode(options.debug ? CompilationMode.DEBUG : CompilationMode.RELEASE);
        if (!options.isGeneratingClassFiles()) {
            marker.setMinApi(options.minApiLevel);
        }
        if (Version.isDev()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    static void writeApplication(ExecutorService executorService, DexApplication application, AppView<?> appView, String deadCode, GraphLense graphLense, NamingLens namingLens, String proguardSeedsData, InternalOptions options, ProguardMapSupplier proguardMapSupplier) throws ExecutionException {
        try {
            Marker marker = R8.getMarker(options);
            assert (marker != null);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(application, appView, options, marker, deadCode, graphLense, namingLens, proguardSeedsData, proguardMapSupplier).write(options.getClassFileConsumer(), executorService);
            } else {
                new ApplicationWriter(application, appView, options, Collections.singletonList(marker), deadCode, graphLense, namingLens, proguardSeedsData, proguardMapSupplier).write(executorService);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write application", e);
        }
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, ProguardClassFilter dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        dontWarnPatterns.filterOutMatches(result);
        return result;
    }

    static void runForTesting(AndroidApp app, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withR8CompilationHandler(options.reporter, () -> {
            try {
                R8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static void run(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException {
        new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AndroidApp inputApp, ExecutorService executorService) throws IOException {
        assert (this.options.programConsumer != null);
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        try {
            NamingLens namingLens;
            Enqueuer enqueuer;
            WhyAreYouKeepingConsumer whyAreYouKeepingConsumer;
            Set<DexCallSite> desugaredCallSites;
            GraphLense publicizedLense;
            boolean changed;
            Object outputStream2;
            Set<DexType> classesToRetainInnerClassAttributeFor;
            String proguardSeedsData;
            ArrayList<ProguardAssumeValuesRule> synthesizedProguardRules;
            AppView<AppInfoWithSubtyping> appView;
            DexApplication application;
            block84: {
                application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService).toDirect();
                inputApp.closeInternalArchiveProviders();
                appView = AppView.createForR8(new AppInfoWithSubtyping(application), this.options);
                appView.setAppServices(AppServices.builder(appView).build());
                synthesizedProguardRules = new ArrayList<ProguardAssumeValuesRule>();
                proguardSeedsData = null;
                this.timing.begin("Strip unused code");
                classesToRetainInnerClassAttributeFor = null;
                try {
                    Object out;
                    Set<DexType> missingClasses = appView.appInfo().getMissingClasses();
                    missingClasses = this.filterMissingClasses(missingClasses, this.options.getProguardConfiguration().getDontWarnPatterns());
                    if (!missingClasses.isEmpty()) {
                        missingClasses.forEach(clazz -> this.options.reporter.warning(new StringDiagnostic("Missing class: " + clazz.toSourceString())));
                        if (!this.options.ignoreMissingClasses) {
                            throw new CompilationError("Compilation can't be completed because some library classes are missing.");
                        }
                    }
                    this.computeKotlinInfoForProgramClasses(application, appView);
                    ProguardConfiguration.Builder compatibility = ProguardConfiguration.builder(application.dexItemFactory, this.options.reporter);
                    if (this.options.isGeneratingDex() && !ProguardConfigurationUtils.hasExplicitAssumeValuesRuleForMinSdk(this.options.itemFactory, this.options.getProguardConfiguration().getRules())) {
                        synthesizedProguardRules.add(ProguardConfigurationUtils.buildAssumeValuesForApiLevel(this.options.itemFactory, AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel)));
                    }
                    appView.setRootSet(new RootSetBuilder(appView, application, Iterables.concat(this.options.getProguardConfiguration().getRules(), synthesizedProguardRules)).run(executorService));
                    Enqueuer enqueuer2 = new Enqueuer(appView, this.options, null, compatibility);
                    AppView<AppInfoWithLiveness> appViewWithLiveness = appView.setAppInfo(enqueuer2.traceApplication(appView.rootSet(), this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
                    assert (appView.rootSet().verifyKeptFieldsAreAccessedAndLive(appViewWithLiveness.appInfo()));
                    assert (appView.rootSet().verifyKeptMethodsAreTargetedAndLive(appViewWithLiveness.appInfo()));
                    assert (appView.rootSet().verifyKeptTypesAreLive(appViewWithLiveness.appInfo()));
                    if (this.options.getProguardConfiguration().isPrintSeeds()) {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        out = new PrintStream(bytes);
                        RootSetBuilder.writeSeeds(appView.appInfo().withLiveness(), (PrintStream)out, type -> true);
                        ((PrintStream)out).flush();
                        proguardSeedsData = bytes.toString();
                    }
                    if (this.options.isShrinking()) {
                        TreePruner pruner = new TreePruner(application, appView.withLiveness());
                        application = pruner.run();
                        appView.setAppInfo(appView.appInfo().withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses()));
                        new AbstractMethodRemover(appView.appInfo().withLiveness()).run();
                    }
                    classesToRetainInnerClassAttributeFor = AnnotationRemover.computeClassesToRetainInnerClassAttributeFor(appView.withLiveness());
                    new AnnotationRemover(appView.withLiveness(), classesToRetainInnerClassAttributeFor).ensureValid(compatibility).run();
                    if (!this.options.forceProguardCompatibility || this.options.proguardCompatibilityRulesOutput == null) break block84;
                    Closer closer = Closer.create();
                    out = null;
                    try {
                        outputStream2 = FileUtils.openPath(closer, this.options.proguardCompatibilityRulesOutput, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                        try (PrintStream ps = new PrintStream((OutputStream)outputStream2);){
                            ps.println(compatibility.buildRaw().toString());
                        }
                    }
                    catch (Throwable outputStream2) {
                        out = outputStream2;
                        throw outputStream2;
                    }
                    finally {
                        if (closer != null) {
                            R8.$closeResource((Throwable)out, closer);
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            assert (appView.appInfo().hasLiveness());
            RootSetBuilder.RootSet mainDexRootSet = null;
            MainDexClasses mainDexClasses = MainDexClasses.NONE;
            if (!this.options.mainDexKeepRules.isEmpty()) {
                assert (appView.graphLense().isIdentityLense());
                mainDexRootSet = new RootSetBuilder(appView, application, this.options.mainDexKeepRules).run(executorService);
                SortedSet<DexType> mainDexBaseClasses = new Enqueuer(appView, this.options, null).traceMainDex(mainDexRootSet, executorService, this.timing);
                mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
                appView.appInfo().unsetObsolete();
            }
            appView.dexItemFactory().clearTypeLatticeElementsCache();
            if (this.options.getProguardConfiguration().isAccessModificationAllowed() && (changed = appView.setGraphLense(publicizedLense = ClassAndMemberPublicizer.run(executorService, this.timing, application, appView.withLiveness())))) {
                new VisibilityBridgeRemover(appView.withLiveness()).run();
            }
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            appView.setGraphLense(new MemberRebindingAnalysis(appViewWithLiveness).run());
            if (this.options.enableNestBasedAccessDesugaring) {
                this.timing.begin("NestBasedAccessDesugaring");
                NestBasedAccessDesugaringAnalysis analyzer = new NestBasedAccessDesugaringAnalysis(appViewWithLiveness);
                boolean changed2 = appView.setGraphLense(analyzer.run());
                if (changed2) {
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            }
            if (this.options.enableHorizontalClassMerging) {
                this.timing.begin("HorizontalStaticClassMerger");
                StaticClassMerger staticClassMerger = new StaticClassMerger(appViewWithLiveness, this.options, mainDexClasses);
                boolean changed3 = appView.setGraphLense(staticClassMerger.run());
                if (changed3) {
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            }
            if (this.options.enableVerticalClassMerging) {
                this.timing.begin("VerticalClassMerger");
                VerticalClassMerger verticalClassMerger = new VerticalClassMerger(application, appViewWithLiveness, executorService, this.timing, mainDexClasses);
                boolean changed4 = appView.setGraphLense(verticalClassMerger.run());
                if (changed4) {
                    appView.setVerticallyMergedClasses(verticalClassMerger.getMergedClasses());
                    application = application.asDirect().rewrittenWithLense(appView.graphLense());
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            }
            if (this.options.enableArgumentRemoval) {
                if (this.options.enableUnusedArgumentRemoval) {
                    this.timing.begin("UnusedArgumentRemoval");
                    changed = appView.setGraphLense(new UnusedArgumentsCollector(appViewWithLiveness, new MethodPoolCollection(appView)).run(executorService, this.timing));
                    if (changed) {
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    }
                    this.timing.end();
                }
                if (this.options.enableUninstantiatedTypeOptimization) {
                    this.timing.begin("UninstantiatedTypeOptimization");
                    changed = appView.setGraphLense(new UninstantiatedTypeOptimization(appViewWithLiveness).run(new MethodPoolCollection(appView), executorService, this.timing));
                    if (changed) {
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    }
                    this.timing.end();
                }
            }
            assert (appView.dexItemFactory().verifyNoCachedTypeLatticeElements());
            appViewWithLiveness.setAppInfo(new SwitchMapCollector(appViewWithLiveness).run());
            appViewWithLiveness.setAppInfo(new EnumOrdinalMapCollector(appViewWithLiveness).run());
            appView.setAppServices(appView.appServices().rewrittenWithLens(appView.graphLense()));
            this.timing.begin("Create IR");
            CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
            try {
                IRConverter converter = new IRConverter(appView, this.timing, printer, mainDexClasses);
                application = converter.optimize(application, executorService);
                desugaredCallSites = converter.getDesugaredCallSites();
            }
            finally {
                this.timing.end();
            }
            appView.dexItemFactory().clearTypeLatticeElementsCache();
            this.timing.begin("AppliedGraphLens construction");
            appView.setGraphLense(new AppliedGraphLens(appView, application.classes()));
            this.timing.end();
            if (this.options.printCfg) {
                if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);
                    outputStream2 = null;
                    try {
                        writer.write(printer.toString());
                    }
                    catch (Throwable ps) {
                        outputStream2 = ps;
                        throw ps;
                    }
                    finally {
                        R8.$closeResource((Throwable)outputStream2, writer);
                    }
                }
            }
            this.timing.begin("Rename SourceFile");
            new SourceFileRewriter(appView).run();
            this.timing.end();
            Set<DexType> prunedTypes = appView.withLiveness().appInfo().getPrunedTypes();
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appView.setAppInfo(new AppInfoWithSubtyping(application));
                assert (mainDexRootSet != null);
                GraphConsumer mainDexKeptGraphConsumer = this.options.mainDexKeptGraphConsumer;
                whyAreYouKeepingConsumer = null;
                if (!mainDexRootSet.reasonAsked.isEmpty()) {
                    whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(mainDexKeptGraphConsumer);
                    mainDexKeptGraphConsumer = whyAreYouKeepingConsumer;
                }
                enqueuer = new Enqueuer(appView, this.options, mainDexKeptGraphConsumer);
                SortedSet<DexType> mainDexBaseClasses = enqueuer.traceMainDex(mainDexRootSet, executorService, this.timing);
                MainDexClasses finalMainDexClasses = mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
                R8.processWhyAreYouKeepingAndCheckDiscarded(mainDexRootSet, () -> {
                    ArrayList classes = new ArrayList();
                    finalMainDexClasses.getClasses().forEach(type -> {
                        DexClass clazz = appView.definitionFor((DexType)type);
                        assert (clazz.isProgramClass());
                        classes.add(clazz.asProgramClass());
                    });
                    return classes;
                }, whyAreYouKeepingConsumer, appView, enqueuer, true, this.options, this.timing, executorService);
            }
            appView.setAppInfo(new AppInfoWithSubtyping(application));
            if (this.options.isShrinking() || this.options.isMinifying() || this.options.getProguardConfiguration().hasApplyMappingFile()) {
                this.timing.begin("Post optimization code stripping");
                try {
                    GraphConsumer keptGraphConsumer = null;
                    whyAreYouKeepingConsumer = null;
                    if (this.options.isShrinking()) {
                        keptGraphConsumer = this.options.keptGraphConsumer;
                        if (!appView.rootSet().reasonAsked.isEmpty()) {
                            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(keptGraphConsumer);
                            keptGraphConsumer = whyAreYouKeepingConsumer;
                        }
                    }
                    enqueuer = new Enqueuer(appView, this.options, keptGraphConsumer);
                    appView.setAppInfo(enqueuer.traceApplication(appView.rootSet(), this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
                    if (this.options.isShrinking()) {
                        TreePruner pruner = new TreePruner(application, appViewWithLiveness);
                        application = pruner.run();
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().prunedCopyFrom(application, CollectionUtils.mergeSets(prunedTypes, pruner.getRemovedClasses())));
                        R8.processWhyAreYouKeepingAndCheckDiscarded(appView.rootSet(), () -> ((AppInfoWithSubtyping)appView.appInfo()).app().classesWithDeterministicOrder(), whyAreYouKeepingConsumer, appView, enqueuer, false, this.options, this.timing, executorService);
                        assert (classesToRetainInnerClassAttributeFor != null);
                        new AnnotationRemover(appView.withLiveness(), classesToRetainInnerClassAttributeFor).run();
                        if (!mainDexClasses.isEmpty()) {
                            mainDexClasses = mainDexClasses.prunedCopy(appView.appInfo().withLiveness());
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (!this.options.mainDexKeepRules.isEmpty()) {
                application = application.builder().addToMainDexList(mainDexClasses.getClasses()).build();
            }
            if (this.options.getProguardConfiguration().hasApplyMappingFile()) {
                SeedMapper seedMapper = SeedMapper.seedMapperFromFile(this.options.reporter, this.options.getProguardConfiguration().getApplyMappingFile());
                this.timing.begin("apply-mapping");
                namingLens = new ProguardMapMinifier(appView.withLiveness(), seedMapper, desugaredCallSites).run(this.timing);
                this.timing.end();
            } else if (this.options.isMinifying()) {
                this.timing.begin("Minification");
                namingLens = new Minifier(appView.withLiveness(), desugaredCallSites).run(this.timing);
                this.timing.end();
            } else {
                if (appView.appInfo().hasLiveness()) {
                    new GenericSignatureRewriter(appView.withLiveness()).run(appView.appInfo().classes());
                }
                namingLens = NamingLens.getIdentityLens();
            }
            this.timing.begin("Line number remapping");
            ClassNameMapper classNameMapper = LineNumberOptimizer.run(appView, application, namingLens);
            this.timing.end();
            ProguardMapSupplier proguardMapSupplier = ProguardMapSupplier.fromClassNameMapper(classNameMapper, this.options);
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                return;
            }
            if (appView.appInfo().hasLiveness()) {
                ImmutableSet.Builder unneededVisibilityBridgeMethods = ImmutableSet.builder();
                new VisibilityBridgeRemover(appView.withLiveness(), unneededVisibilityBridgeMethod -> unneededVisibilityBridgeMethods.add(unneededVisibilityBridgeMethod.method)).run();
                appView.setUnneededVisibilityBridgeMethods((Set<DexMethod>)((Object)unneededVisibilityBridgeMethods.build()));
            } else assert (!this.options.isShrinking());
            assert (application.classes().stream().allMatch(DexClass::isValid));
            assert (appView.rootSet().verifyKeptItemsAreKept(application, appView.appInfo()));
            assert (appView.graphLense().verifyMappingToOriginalProgram(application.classesWithDeterministicOrder(), new ApplicationReader(inputApp.withoutMainDexList(), this.options, this.timing).read(executorService), appView.dexItemFactory()));
            if (this.options.syntheticProguardRulesConsumer != null) {
                this.options.syntheticProguardRulesConsumer.accept(synthesizedProguardRules);
            }
            R8.writeApplication(executorService, application, appView, application.deadCode, appView.graphLense(), namingLens, proguardSeedsData, this.options, proguardMapSupplier);
            this.options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            this.options.signalFinishedToConsumers();
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    static void processWhyAreYouKeepingAndCheckDiscarded(RootSetBuilder.RootSet rootSet, Supplier<Iterable<DexProgramClass>> classes, WhyAreYouKeepingConsumer whyAreYouKeepingConsumer, AppView<? extends AppInfoWithSubtyping> appView, Enqueuer enqueuer, boolean forMainDex, InternalOptions options, Timing timing, ExecutorService executorService) throws ExecutionException {
        if (whyAreYouKeepingConsumer != null) {
            for (DexReference reference : rootSet.reasonAsked) {
                whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphNode(reference), System.out);
            }
        }
        if (rootSet.checkDiscarded.isEmpty()) {
            return;
        }
        List<DexDefinition> failed = new DiscardedChecker(rootSet, classes.get()).run();
        if (failed.isEmpty()) {
            return;
        }
        if (whyAreYouKeepingConsumer == null) {
            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(null);
            enqueuer = new Enqueuer(appView, options, whyAreYouKeepingConsumer);
            if (forMainDex) {
                enqueuer.traceMainDex(rootSet, executorService, timing);
            } else {
                enqueuer.traceApplication(rootSet, options.getProguardConfiguration().getDontWarnPatterns(), executorService, timing);
            }
        }
        for (DexDefinition definition : failed) {
            if (failed.isEmpty()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphNode(definition.toReference()), new PrintStream(baos));
            options.reporter.info(new StringDiagnostic("Item " + definition.toSourceString() + " was not discarded.\n" + baos.toString()));
        }
        throw new CompilationError("Discard checks failed.");
    }

    private void computeKotlinInfoForProgramClasses(DexApplication application, AppView<?> appView) {
        Kotlin kotlin = appView.dexItemFactory().kotlin;
        Reporter reporter = this.options.reporter;
        for (DexProgramClass programClass : application.classes()) {
            programClass.setKotlinInfo(kotlin.getKotlinInfo(programClass, reporter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws CompilationFailedException {
        R8Command command = (R8Command)R8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            Version.printToolVersion("R8");
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withR8CompilationHandler(options.reporter, () -> R8.run(command.getInputApp(), options, executorService));
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(R8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> R8.run(args));
    }
}

