/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.FixedLocalValue;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Dup2;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Pop;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Swap;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CfRegisterAllocator
implements RegisterAllocator {
    private final AppView<?> appView;
    private final IRCode code;
    private final TypeVerificationHelper typeHelper;
    private Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets;
    private final Map<BasicBlock, TypesAtBlockEntry> lazyTypeInfoAtBlockEntry = new HashMap<BasicBlock, TypesAtBlockEntry>();
    private final List<LiveIntervals> liveIntervals = new ArrayList<LiveIntervals>();
    private final List<LiveIntervals> active = new LinkedList<LiveIntervals>();
    private final List<LiveIntervals> inactive = new LinkedList<LiveIntervals>();
    private final PriorityQueue<LiveIntervals> unhandled = new PriorityQueue();
    private NavigableSet<Integer> freeRegisters = new TreeSet<Integer>();
    private int nextUnusedRegisterNumber = 0;
    private int maxRegisterNumber = 0;
    private int maxArgumentRegisterNumber = -1;

    public CfRegisterAllocator(AppView<?> appView, IRCode code, TypeVerificationHelper typeHelper) {
        this.appView = appView;
        this.code = code;
        this.typeHelper = typeHelper;
    }

    @Override
    public int registersUsed() {
        return this.maxRegisterNumber + 1;
    }

    @Override
    public int getRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    public int getRegisterForValue(Value value) {
        if (value instanceof FixedLocalValue) {
            return ((FixedLocalValue)value).getRegister(this);
        }
        assert (!value.getLiveIntervals().hasSplits());
        return value.getLiveIntervals().getRegister();
    }

    @Override
    public int getArgumentOrAllocateRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    @Override
    public InternalOptions options() {
        return this.appView.options();
    }

    @Override
    public void allocateRegisters() {
        this.computeNeedsRegister();
        ImmutableList<BasicBlock> blocks = this.computeLivenessInformation();
        this.performLinearScan();
        if (this.appView.options().debug) {
            LinearScanRegisterAllocator.computeDebugInfo(blocks, this.liveIntervals, this, this.liveAtEntrySets);
        }
    }

    private void computeNeedsRegister() {
        InstructionIterator it = this.code.instructionIterator();
        while (it.hasNext()) {
            Instruction next = (Instruction)it.next();
            Value outValue = next.outValue();
            if (outValue == null) continue;
            boolean isStackValue = outValue instanceof StackValue || outValue instanceof StackValues;
            outValue.setNeedsRegister(!isStackValue);
        }
    }

    private ImmutableList<BasicBlock> computeLivenessInformation() {
        ImmutableList<BasicBlock> blocks = this.code.numberInstructions();
        this.liveAtEntrySets = this.code.computeLiveAtEntrySets();
        LinearScanRegisterAllocator.computeLiveRanges(this.appView.options(), this.code, this.liveAtEntrySets, this.liveIntervals);
        return blocks;
    }

    private void performLinearScan() {
        this.unhandled.addAll(this.liveIntervals);
        while (!this.unhandled.isEmpty() && this.unhandled.peek().getValue().isArgument()) {
            LiveIntervals argument = this.unhandled.poll();
            this.assignRegisterToUnhandledInterval(argument, this.getNextFreeRegister(argument.getType().isWide()));
        }
        this.maxArgumentRegisterNumber = this.nextUnusedRegisterNumber - 1;
        while (!this.unhandled.isEmpty()) {
            int register;
            LiveIntervals unhandledInterval = this.unhandled.poll();
            assert (!unhandledInterval.getValue().isArgument());
            int start = unhandledInterval.getStart();
            Iterator<LiveIntervals> it = this.active.iterator();
            while (it.hasNext()) {
                LiveIntervals activeIntervals = it.next();
                if (start >= activeIntervals.getEnd()) {
                    it.remove();
                    this.freeRegistersForIntervals(activeIntervals);
                    continue;
                }
                if (activeIntervals.overlapsPosition(start)) continue;
                assert (activeIntervals.getRegister() != Integer.MIN_VALUE);
                it.remove();
                this.inactive.add(activeIntervals);
                this.freeRegistersForIntervals(activeIntervals);
            }
            it = this.inactive.iterator();
            while (it.hasNext()) {
                LiveIntervals inactiveIntervals = it.next();
                if (start >= inactiveIntervals.getEnd()) {
                    it.remove();
                    continue;
                }
                if (!inactiveIntervals.overlapsPosition(start)) continue;
                it.remove();
                assert (inactiveIntervals.getRegister() != Integer.MIN_VALUE);
                this.active.add(inactiveIntervals);
                this.takeRegistersForIntervals(inactiveIntervals);
            }
            if (this.tryHint(unhandledInterval)) {
                this.assignRegisterToUnhandledInterval(unhandledInterval, unhandledInterval.getHint().getRegister());
                continue;
            }
            boolean wide = unhandledInterval.getType().isWide();
            TreeSet<Integer> previousFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
            while (true) {
                register = this.getNextFreeRegister(wide);
                boolean overlapsInactiveInterval = false;
                for (LiveIntervals inactiveIntervals : this.inactive) {
                    if (!inactiveIntervals.usesRegister(register, wide) || !unhandledInterval.overlaps(inactiveIntervals)) continue;
                    overlapsInactiveInterval = true;
                    break;
                }
                if (!overlapsInactiveInterval) break;
                this.freeRegisters.remove(register);
            }
            this.freeRegisters = previousFreeRegisters;
            this.assignRegisterToUnhandledInterval(unhandledInterval, register);
        }
    }

    private int getNextFreeRegister(boolean isWide) {
        if (!this.freeRegisters.isEmpty()) {
            if (isWide) {
                for (Integer register : this.freeRegisters) {
                    if (!this.freeRegisters.contains(register + 1) && this.nextUnusedRegisterNumber != register + 1 || register == this.maxArgumentRegisterNumber) continue;
                    return register;
                }
                return this.nextUnusedRegisterNumber;
            }
            return (Integer)this.freeRegisters.first();
        }
        return this.nextUnusedRegisterNumber;
    }

    private void freeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.add(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.add(register + 1);
        }
    }

    private void takeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.remove(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.remove(register + 1);
        }
    }

    private void updateHints(LiveIntervals intervals) {
        for (Phi phi : intervals.getValue().uniquePhiUsers()) {
            if (phi.isValueOnStack()) continue;
            phi.getLiveIntervals().setHint(intervals);
            for (Value value : phi.getOperands()) {
                value.getLiveIntervals().setHint(intervals);
            }
        }
    }

    private boolean tryHint(LiveIntervals unhandled) {
        if (unhandled.getHint() == null) {
            return false;
        }
        boolean isWide = unhandled.getType().isWide();
        int hintRegister = unhandled.getHint().getRegister();
        if (this.freeRegisters.contains(hintRegister) && (!isWide || this.freeRegisters.contains(hintRegister + 1))) {
            for (LiveIntervals inactive : this.inactive) {
                if (!inactive.usesRegister(hintRegister, isWide) || !inactive.overlaps(unhandled)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void assignRegisterToUnhandledInterval(LiveIntervals unhandledInterval, int register) {
        this.assignRegister(unhandledInterval, register);
        this.takeRegistersForIntervals(unhandledInterval);
        this.updateRegisterState(register, unhandledInterval.getType().isWide());
        this.updateHints(unhandledInterval);
        this.active.add(unhandledInterval);
    }

    private void updateRegisterState(int register, boolean needsRegisterPair) {
        int maxRegister = register + (needsRegisterPair ? 1 : 0);
        if (maxRegister >= this.nextUnusedRegisterNumber) {
            this.nextUnusedRegisterNumber = maxRegister + 1;
        }
        this.maxRegisterNumber = Math.max(this.maxRegisterNumber, maxRegister);
    }

    private void assignRegister(LiveIntervals intervals, int register) {
        intervals.setRegister(register);
    }

    public void addToLiveAtEntrySet(BasicBlock block, Collection<Phi> phis) {
        for (Phi phi : phis) {
            if (phi.isValueOnStack()) {
                this.liveAtEntrySets.get((Object)block).liveStackValues.addLast(phi);
                continue;
            }
            this.liveAtEntrySets.get((Object)block).liveValues.add(phi);
        }
    }

    public TypesAtBlockEntry getTypesAtBlockEntry(BasicBlock block) {
        return this.lazyTypeInfoAtBlockEntry.computeIfAbsent(block, k -> {
            Set<Value> liveValues = this.liveAtEntrySets.get((Object)k).liveValues;
            Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo> registers = new Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo>(liveValues.size());
            for (Value liveValue : liveValues) {
                registers.put(this.getRegisterForValue(liveValue), this.typeHelper.getTypeInfo(liveValue));
            }
            Deque<Value> liveStackValues = this.liveAtEntrySets.get((Object)k).liveStackValues;
            ArrayList<TypeVerificationHelper.TypeInfo> stack = new ArrayList<TypeVerificationHelper.TypeInfo>(liveStackValues.size());
            for (Value value : liveStackValues) {
                stack.add(this.typeHelper.getTypeInfo(value));
            }
            return new TypesAtBlockEntry(registers, stack);
        });
    }

    @Override
    public void mergeBlocks(BasicBlock kept, BasicBlock removed) {
        TypesAtBlockEntry typesOfKept = this.getTypesAtBlockEntry(kept);
        TypesAtBlockEntry typesOfRemoved = this.getTypesAtBlockEntry(removed);
        assert (typesOfKept.registers.size() == typesOfRemoved.registers.size());
        this.updateFirstRegisterMapByJoiningTheSecond(typesOfKept.registers, typesOfRemoved.registers);
        assert (typesOfKept.stack.size() == typesOfRemoved.stack.size());
        this.updateFirstStackByJoiningTheSecond(typesOfKept.stack, typesOfRemoved.stack);
    }

    @Override
    public boolean hasEqualTypesAtEntry(BasicBlock first, BasicBlock second) {
        if (!Objects.equals(first.getLocalsAtEntry(), second.getLocalsAtEntry())) {
            return false;
        }
        List<TypeVerificationHelper.TypeInfo> firstStack = this.getTypesAtBlockEntry((BasicBlock)first).stack;
        List<TypeVerificationHelper.TypeInfo> secondStack = this.getTypesAtBlockEntry((BasicBlock)second).stack;
        if (firstStack.size() != secondStack.size()) {
            return false;
        }
        for (int i = 0; i < firstStack.size(); ++i) {
            if (firstStack.get(i).getDexType() == secondStack.get(i).getDexType()) continue;
            return false;
        }
        if (first.entry().isMoveException() != second.entry().isMoveException()) {
            return false;
        }
        return !first.entry().isMoveException() || this.typeHelper.getTypeInfo(first.entry().outValue()).getDexType() == this.typeHelper.getTypeInfo(second.entry().outValue()).getDexType();
    }

    private boolean tryApplyInstructionWithDependentOutType(Instruction instruction, Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers, Deque<TypeVerificationHelper.TypeInfo> stack) {
        if (instruction.outValue() == null || instruction.inValues().isEmpty()) {
            return false;
        }
        if (instruction instanceof Load) {
            int register = this.getRegisterForValue(instruction.inValues().get(0));
            assert (registers.containsKey(register));
            stack.addLast((TypeVerificationHelper.TypeInfo)registers.get(register));
        } else if (instruction instanceof Store) {
            int register = this.getRegisterForValue(instruction.outValue());
            registers.put(register, stack.removeLast());
        } else if (instruction instanceof Pop) {
            stack.removeLast();
        } else if (instruction instanceof Dup) {
            stack.addLast(stack.getLast());
        } else if (instruction instanceof Dup2) {
            TypeVerificationHelper.TypeInfo wasTop = stack.removeLast();
            TypeVerificationHelper.TypeInfo wasBelowTop = stack.getLast();
            stack.addLast(wasTop);
            stack.addLast(wasBelowTop);
            stack.addLast(wasTop);
        } else if (instruction instanceof Swap) {
            TypeVerificationHelper.TypeInfo wasTop = stack.removeLast();
            TypeVerificationHelper.TypeInfo wasBelowTop = stack.removeLast();
            stack.addLast(wasTop);
            stack.addLast(wasBelowTop);
        } else if (instruction instanceof DebugLocalWrite) {
            int dstRegister = this.getRegisterForValue(instruction.outValue());
            registers.put(dstRegister, stack.removeLast());
        } else {
            return false;
        }
        return true;
    }

    private void applyInstructionsToTypes(BasicBlock block, Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers, Deque<TypeVerificationHelper.TypeInfo> stack, int prefixSize) {
        InstructionIterator it = block.iterator();
        int instructionsLeft = prefixSize;
        while (--instructionsLeft >= 0 && it.hasNext()) {
            Instruction current = (Instruction)it.next();
            if (this.tryApplyInstructionWithDependentOutType(current, registers, stack)) continue;
            for (int i = current.inValues().size() - 1; i >= 0; --i) {
                Value inValue = current.inValues().get(i);
                if (!inValue.isValueOnStack()) continue;
                stack.removeLast();
            }
            Value outValue = current.outValue();
            if (outValue == null) continue;
            TypeVerificationHelper.TypeInfo outType = this.typeHelper.getTypeInfo(outValue);
            assert (outType != null);
            if (outValue.needsRegister()) {
                int register = this.getRegisterForValue(outValue);
                registers.put(register, outType);
                continue;
            }
            if (outValue.isValueOnStack()) {
                stack.addLast(outType);
                continue;
            }
            throw new Unreachable();
        }
    }

    private void applyInstructionsBackwardsToRegisterLiveness(BasicBlock block, IntSet liveRegisters, int suffixSize) {
        Iterator<Instruction> iterator2 = block.getInstructions().descendingIterator();
        int instructionsLeft = suffixSize;
        while (--instructionsLeft >= 0 && iterator2.hasNext()) {
            Instruction current = iterator2.next();
            Value outValue = current.outValue();
            if (outValue != null && outValue.needsRegister()) {
                int register = this.getRegisterForValue(outValue);
                assert (liveRegisters.contains(register));
                liveRegisters.remove(register);
            }
            for (Value inValue : current.inValues()) {
                if (!inValue.needsRegister()) continue;
                int register = this.getRegisterForValue(inValue);
                liveRegisters.add(register);
            }
        }
    }

    @Override
    public void addNewBlockToShareIdenticalSuffix(BasicBlock block, int suffixSize, List<BasicBlock> predsBeforeSplit) {
        Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo> joinedRegistersBeforeSuffix = new Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo>();
        ArrayList<TypeVerificationHelper.TypeInfo> joinedStackBeforeSuffix = new ArrayList<TypeVerificationHelper.TypeInfo>();
        assert (!predsBeforeSplit.isEmpty());
        for (BasicBlock pred : predsBeforeSplit) {
            Int2ReferenceMap<Object> registersAtExit;
            TypesAtBlockEntry types = this.getTypesAtBlockEntry(pred);
            Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo> registersFromPrefix = new Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo>(types.registers);
            ArrayDeque<TypeVerificationHelper.TypeInfo> stackFromPrefix = new ArrayDeque<TypeVerificationHelper.TypeInfo>(types.stack);
            this.applyInstructionsToTypes(pred, registersFromPrefix, stackFromPrefix, pred.getInstructions().size() - suffixSize);
            if (pred.getSuccessors().isEmpty()) {
                registersAtExit = new Int2ReferenceOpenHashMap();
            } else {
                assert (pred.getSuccessors().size() == 1);
                registersAtExit = this.getTypesAtBlockEntry((BasicBlock)pred.getSuccessors().get((int)0)).registers;
            }
            IntOpenHashSet registersLiveFromSuffix = new IntOpenHashSet(registersAtExit.size() * 2);
            registersLiveFromSuffix.addAll(registersAtExit.keySet());
            this.applyInstructionsBackwardsToRegisterLiveness(pred, registersLiveFromSuffix, suffixSize);
            Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo> registersBeforeSuffix = new Int2ReferenceOpenHashMap<TypeVerificationHelper.TypeInfo>(registersFromPrefix.size());
            IntIterator intIterator = registersLiveFromSuffix.iterator();
            while (intIterator.hasNext()) {
                int register = (Integer)intIterator.next();
                assert (registersFromPrefix.containsKey(register));
                registersBeforeSuffix.put(register, (TypeVerificationHelper.TypeInfo)registersFromPrefix.get(register));
            }
            this.updateFirstRegisterMapByJoiningTheSecond(joinedRegistersBeforeSuffix, registersBeforeSuffix);
            this.updateFirstStackByJoiningTheSecond(joinedStackBeforeSuffix, Arrays.asList(stackFromPrefix.toArray(new TypeVerificationHelper.TypeInfo[0])));
        }
        assert (!this.lazyTypeInfoAtBlockEntry.containsKey(block));
        this.lazyTypeInfoAtBlockEntry.put(block, new TypesAtBlockEntry(joinedRegistersBeforeSuffix, joinedStackBeforeSuffix));
    }

    private void updateFirstRegisterMapByJoiningTheSecond(Int2ReferenceMap<TypeVerificationHelper.TypeInfo> map1, Int2ReferenceMap<TypeVerificationHelper.TypeInfo> map2) {
        if (map1.isEmpty()) {
            map1.putAll(map2);
            return;
        }
        assert (map1.size() == map2.size());
        for (Int2ReferenceMap.Entry entry : map1.int2ReferenceEntrySet()) {
            int register = entry.getIntKey();
            TypeVerificationHelper.TypeInfo type1 = (TypeVerificationHelper.TypeInfo)entry.getValue();
            assert (map2.containsKey(register));
            TypeVerificationHelper.TypeInfo joinedType = this.typeHelper.join(type1, (TypeVerificationHelper.TypeInfo)map2.get(register));
            if (joinedType == type1) continue;
            map1.put(register, joinedType);
        }
    }

    private void updateFirstStackByJoiningTheSecond(List<TypeVerificationHelper.TypeInfo> stack1, List<TypeVerificationHelper.TypeInfo> stack2) {
        if (stack1.isEmpty()) {
            stack1.addAll(stack2);
            return;
        }
        assert (stack1.size() == stack2.size());
        for (int i = 0; i < stack1.size(); ++i) {
            TypeVerificationHelper.TypeInfo type1 = stack1.get(i);
            TypeVerificationHelper.TypeInfo joinedType = this.typeHelper.join(type1, stack2.get(i));
            if (joinedType == type1) continue;
            stack1.set(i, joinedType);
        }
    }

    public static class TypesAtBlockEntry {
        public final Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers;
        public final List<TypeVerificationHelper.TypeInfo> stack;

        TypesAtBlockEntry(Int2ReferenceMap<TypeVerificationHelper.TypeInfo> registers, List<TypeVerificationHelper.TypeInfo> stack) {
            this.registers = registers;
            this.stack = stack;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("regs[");
            for (Int2ReferenceMap.Entry entry : this.registers.int2ReferenceEntrySet()) {
                sb.append(entry.getIntKey()).append(":").append(entry.getValue()).append(", ");
            }
            sb.append("], stack[");
            for (TypeVerificationHelper.TypeInfo typeInfo : this.stack) {
                sb.append(typeInfo).append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

