/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfFieldInstruction
extends CfInstruction {
    private final int opcode;
    private final DexField field;
    private final DexField declaringField;

    public CfFieldInstruction(int opcode, DexField field, DexField declaringField) {
        this.opcode = opcode;
        this.field = field;
        this.declaringField = declaringField;
        assert (field.type == declaringField.type);
    }

    public DexField getField() {
        return this.field;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        String owner = lens.lookupInternalName(this.field.holder);
        String name = lens.lookupName(this.declaringField).toString();
        String desc = lens.lookupDescriptor(this.field.type).toString();
        visitor.visitFieldInsn(this.opcode, owner, name, desc);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        switch (this.opcode) {
            case 180: {
                registry.registerInstanceFieldRead(this.field);
                break;
            }
            case 181: {
                registry.registerInstanceFieldWrite(this.field);
                break;
            }
            case 178: {
                registry.registerStaticFieldRead(this.field);
                break;
            }
            case 179: {
                registry.registerStaticFieldWrite(this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        DexType type = this.field.type;
        switch (this.opcode) {
            case 178: {
                builder.addStaticGet(state.push((DexType)type).register, this.field);
                break;
            }
            case 179: {
                CfState.Slot value = state.pop();
                builder.addStaticPut(value.register, this.field);
                break;
            }
            case 180: {
                CfState.Slot object = state.pop();
                builder.addInstanceGet(state.push((DexType)type).register, object.register, this.field);
                break;
            }
            case 181: {
                CfState.Slot value = state.pop();
                CfState.Slot object = state.pop();
                builder.addInstancePut(value.register, object.register, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
    }
}

