/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.SwitchPayload;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class SparseSwitchPayload
extends SwitchPayload {
    public final int size;
    public final int[] keys;
    public final int[] targets;

    public SparseSwitchPayload(int high, BytecodeStream stream) {
        super(high, stream);
        int i;
        this.size = SparseSwitchPayload.read16BitValue(stream);
        this.keys = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.keys[i] = SparseSwitchPayload.readSigned32BitValue(stream);
        }
        this.targets = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.targets[i] = SparseSwitchPayload.readSigned32BitValue(stream);
        }
    }

    public SparseSwitchPayload(int[] keys2, int[] targets) {
        assert (targets.length > 0);
        this.size = targets.length;
        this.keys = keys2;
        this.targets = targets;
    }

    @Override
    public boolean isPayload() {
        return true;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        int i;
        this.writeFirst(2, dest);
        this.write16BitValue(this.size, dest);
        for (i = 0; i < this.size; ++i) {
            this.write32BitValue(this.keys[i], dest);
        }
        for (i = 0; i < this.size; ++i) {
            this.write32BitValue(this.targets[i], dest);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        SparseSwitchPayload that = (SparseSwitchPayload)other;
        return this.size == that.size && Arrays.equals(this.keys, that.keys) && Arrays.equals(this.targets, that.targets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.targets);
        return result;
    }

    @Override
    public int getSize() {
        return 2 + 2 * this.keys.length + 2 * this.targets.length;
    }

    @Override
    public int numberOfKeys() {
        return this.size;
    }

    @Override
    public int[] keys() {
        return this.keys;
    }

    @Override
    public int[] switchTargetOffsets() {
        return this.targets;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.toString(naming, null);
    }

    @Override
    public String toString(ClassNameMapper naming, Instruction payloadUser) {
        StringBuilder builder = new StringBuilder("[SparseSwitchPayload");
        if (payloadUser == null) {
            builder.append(" offsets relative to associated SparseSwitch");
        }
        builder.append("]\n");
        for (int i = 0; i < this.size; ++i) {
            String offsetString = payloadUser != null ? StringUtils.hexString(this.targets[i] + payloadUser.getOffset(), 2) : (this.targets[i] >= 0 ? "+" + this.targets[i] : Integer.toString(this.targets[i]));
            StringUtils.appendLeftPadded(builder, this.keys[i] + " -> " + offsetString + "\n", 20);
        }
        return super.toString(naming) + builder.toString();
    }

    @Override
    public String toSmaliString(Instruction payloadUser) {
        StringBuilder builder = new StringBuilder();
        builder.append("    ");
        builder.append(".sparse-switch");
        builder.append("\n");
        for (int i = 0; i < this.keys.length; ++i) {
            builder.append("      ");
            builder.append(StringUtils.hexString(this.keys[i], 8));
            builder.append(" -> :label_");
            builder.append(payloadUser.getOffset() + this.targets[i]);
            builder.append("  # ");
            builder.append(this.keys[i]);
            builder.append("\n");
        }
        builder.append("    ");
        builder.append(".end sparse-switch");
        return builder.toString();
    }
}

