/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ObjectArrays;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.MethodToCodeObjectMapping;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.ResourceAdapter;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ApplicationWriter {
    public final DexApplication application;
    public final AppView<?> appView;
    public final String deadCode;
    public final GraphLense graphLense;
    public final NamingLens namingLens;
    public final String proguardSeedsData;
    public final InternalOptions options;
    public List<Marker> markers;
    public List<DexString> markerStrings;
    public DexIndexedConsumer programConsumer;
    public final ProguardMapSupplier proguardMapSupplier;

    public ApplicationWriter(DexApplication application, AppView<?> appView, InternalOptions options, List<Marker> markers, String deadCode, GraphLense graphLense, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier) {
        this(application, appView, options, markers, deadCode, graphLense, namingLens, proguardSeedsData, proguardMapSupplier, null);
    }

    public ApplicationWriter(DexApplication application, AppView<?> appView, InternalOptions options, List<Marker> markers, String deadCode, GraphLense graphLense, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier, DexIndexedConsumer consumer) {
        assert (application != null);
        this.application = application;
        this.appView = appView;
        assert (options != null);
        this.options = options;
        this.markers = markers;
        this.deadCode = deadCode;
        this.graphLense = graphLense;
        this.namingLens = namingLens;
        this.proguardSeedsData = proguardSeedsData;
        this.proguardMapSupplier = proguardMapSupplier;
        this.programConsumer = consumer;
    }

    private Iterable<VirtualFile> distribute(ExecutorService executorService) throws ExecutionException, IOException {
        VirtualFile.Distributor distributor = this.options.isGeneratingDexFilePerClassFile() ? new VirtualFile.FilePerInputClassDistributor(this, this.options.getDexFilePerClassFileConsumer().combineSyntheticClassesWithPrimaryClass()) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty() && this.options.enableMainDexListCheck ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options, executorService));
        return ((VirtualFile.Distributor)distributor).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ExecutorService executorService) throws IOException, ExecutionException {
        this.application.timing.begin("DexApplication.write");
        ProguardMapSupplier.ProguardMapAndId proguardMapAndId = null;
        if (this.proguardMapSupplier != null && this.options.proguardMapConsumer != null) {
            proguardMapAndId = this.proguardMapSupplier.getProguardMapAndId();
        }
        assert (proguardMapAndId == null || this.markers != null && this.markers.size() == 1);
        if (this.markers != null && !this.markers.isEmpty()) {
            if (proguardMapAndId != null) {
                this.markers.get(0).setPgMapId(proguardMapAndId.id);
            }
            this.markerStrings = new ArrayList<DexString>(this.markers.size());
            for (Marker marker : this.markers) {
                this.markerStrings.add(this.application.dexItemFactory.createString(marker.toString()));
            }
        }
        try {
            this.insertAttributeAnnotations();
            this.application.dexItemFactory.sort(this.namingLens);
            assert (this.markers == null || this.markers.isEmpty() || this.application.dexItemFactory.extractMarker() != null);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            ArrayList<Future<Boolean>> dexDataFutures = new ArrayList<Future<Boolean>>();
            Iterable<VirtualFile> virtualFiles = this.distribute(executorService);
            for (VirtualFile virtualFile : virtualFiles) {
                if (virtualFile.isEmpty()) continue;
                dexDataFutures.add(executorService.submit(() -> {
                    ProgramConsumer byteBufferProvider;
                    ProgramConsumer consumer;
                    if (this.programConsumer != null) {
                        consumer = this.programConsumer;
                        byteBufferProvider = this.programConsumer;
                    } else if (virtualFile.getPrimaryClassDescriptor() != null) {
                        consumer = this.options.getDexFilePerClassFileConsumer();
                        byteBufferProvider = this.options.getDexFilePerClassFileConsumer();
                    } else {
                        consumer = this.options.getDexIndexedConsumer();
                        byteBufferProvider = this.options.getDexIndexedConsumer();
                    }
                    ObjectToOffsetMapping objectMapping = virtualFile.computeMapping(this.application);
                    MethodToCodeObjectMapping codeMapping = this.rewriteCodeWithJumboStrings(objectMapping, virtualFile.classes(), this.application);
                    FileWriter.ByteBufferResult result = this.writeDexFile(objectMapping, codeMapping, (ByteBufferProvider)((Object)byteBufferProvider));
                    ByteDataView data = new ByteDataView(result.buffer.array(), result.buffer.arrayOffset(), result.length);
                    if (consumer instanceof DexFilePerClassFileConsumer) {
                        ((DexFilePerClassFileConsumer)consumer).accept(virtualFile.getPrimaryClassDescriptor(), data, virtualFile.getClassDescriptors(), (DiagnosticsHandler)this.options.reporter);
                    } else {
                        consumer.accept(virtualFile.getId(), data, virtualFile.getClassDescriptors(), this.options.reporter);
                    }
                    data.invalidate();
                    byteBufferProvider.releaseByteBuffer(result.buffer.asByteBuffer());
                    return true;
                }));
            }
            ThreadUtils.awaitFutures(dexDataFutures);
            this.options.reporter.failIfPendingErrors();
            ApplicationWriter.supplyAdditionalConsumers(this.application, this.appView, this.graphLense, this.namingLens, this.options, this.deadCode, proguardMapAndId == null ? null : proguardMapAndId.map, this.proguardSeedsData);
        }
        finally {
            this.application.timing.end();
        }
    }

    public static void supplyAdditionalConsumers(DexApplication application, AppView<?> appView, GraphLense graphLense, NamingLens namingLens, final InternalOptions options, String deadCode, String proguardMapContent, String proguardSeedsData) {
        DataResourceConsumer dataResourceConsumer;
        if (options.configurationConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.configurationConsumer, options.getProguardConfiguration().getParsedConfiguration());
        }
        if (options.usageInformationConsumer != null && deadCode != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.usageInformationConsumer, deadCode);
        }
        if (proguardMapContent != null) {
            assert (ApplicationWriter.validateProguardMapParses(proguardMapContent));
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.proguardMapConsumer, proguardMapContent);
        }
        if (options.proguardSeedsConsumer != null && proguardSeedsData != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.proguardSeedsConsumer, proguardSeedsData);
        }
        if (options.mainDexListConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.mainDexListConsumer, ApplicationWriter.writeMainDexList(application, namingLens));
        }
        if ((dataResourceConsumer = options.dataResourceConsumer) != null) {
            final ResourceAdapter resourceAdapter = new ResourceAdapter(appView, application.dexItemFactory, graphLense, namingLens, options);
            final HashSet generatedResourceNames = new HashSet();
            for (DataResourceProvider dataResourceProvider : application.dataResourceProviders) {
                try {
                    dataResourceProvider.accept(new DataResourceProvider.Visitor(){

                        @Override
                        public void visit(DataDirectoryResource directory) {
                            DataDirectoryResource adapted = resourceAdapter.adaptIfNeeded(directory);
                            if (adapted != null) {
                                dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                                options.reporter.failIfPendingErrors();
                            }
                        }

                        @Override
                        public void visit(DataEntryResource file) {
                            if (resourceAdapter.shouldBeDeleted(file)) {
                                return;
                            }
                            DataEntryResource adapted = resourceAdapter.adaptIfNeeded(file);
                            if (generatedResourceNames.add(adapted.getName())) {
                                dataResourceConsumer.accept(adapted, (DiagnosticsHandler)options.reporter);
                            } else {
                                options.reporter.warning(new StringDiagnostic("Resource '" + file.getName() + "' already exists."));
                            }
                            options.reporter.failIfPendingErrors();
                        }
                    });
                }
                catch (ResourceException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }
        }
    }

    private static boolean validateProguardMapParses(String content) {
        try {
            ClassNameMapper.mapperFromString(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void insertAttributeAnnotations() {
        for (DexProgramClass clazz : this.application.classes()) {
            EnclosingMethodAttribute enclosingMethod = clazz.getEnclosingMethod();
            List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
            if (enclosingMethod == null && innerClasses.isEmpty()) continue;
            ArrayList<DexAnnotation> annotations = new ArrayList<DexAnnotation>(1 + innerClasses.size());
            if (enclosingMethod != null) {
                if (enclosingMethod.getEnclosingMethod() != null) {
                    annotations.add(DexAnnotation.createEnclosingMethodAnnotation(enclosingMethod.getEnclosingMethod(), this.options.itemFactory));
                } else {
                    annotations.add(DexAnnotation.createEnclosingClassAnnotation(enclosingMethod.getEnclosingClass(), this.options.itemFactory));
                }
            }
            if (!innerClasses.isEmpty()) {
                ArrayList<DexType> memberClasses = new ArrayList<DexType>(innerClasses.size());
                for (InnerClassAttribute innerClass : innerClasses) {
                    if (clazz.type == innerClass.getInner()) {
                        if (enclosingMethod == null && (innerClass.getOuter() == null || innerClass.isAnonymous())) {
                            this.options.warningMissingEnclosingMember(clazz.type, clazz.origin, clazz.getInitialClassFileVersion());
                            continue;
                        }
                        annotations.add(DexAnnotation.createInnerClassAnnotation(this.namingLens.lookupInnerName(innerClass, this.options), innerClass.getAccess(), this.options.itemFactory));
                        if (innerClass.getOuter() == null || !innerClass.isNamed()) continue;
                        annotations.add(DexAnnotation.createEnclosingClassAnnotation(innerClass.getOuter(), this.options.itemFactory));
                        continue;
                    }
                    if (clazz.type != innerClass.getOuter() || !innerClass.isNamed()) continue;
                    memberClasses.add(innerClass.getInner());
                }
                if (!memberClasses.isEmpty()) {
                    annotations.add(DexAnnotation.createMemberClassesAnnotation(memberClasses, this.options.itemFactory));
                }
            }
            if (!annotations.isEmpty()) {
                DexAnnotation[] copy = ObjectArrays.concat(clazz.annotations.annotations, annotations.toArray(DexAnnotation.EMPTY_ARRAY), DexAnnotation.class);
                clazz.annotations = new DexAnnotationSet(copy);
            }
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }

    private MethodToCodeObjectMapping rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, Collection<DexProgramClass> classes, DexApplication application) {
        if (!this.options.testing.forceJumboStringProcessing) {
            if (!mapping.hasJumboStrings()) {
                return MethodToCodeObjectMapping.fromMethodBacking();
            }
            if (application.highestSortingString != null && application.highestSortingString.slowCompareTo(mapping.getFirstJumboString()) < 0) {
                return MethodToCodeObjectMapping.fromMethodBacking();
            }
        }
        IdentityHashMap<DexEncodedMethod, DexCode> codeMapping = new IdentityHashMap<DexEncodedMethod, DexCode>();
        for (DexProgramClass clazz : classes) {
            boolean isSharedSynthetic = clazz.getSynthesizedFrom().size() > 1;
            clazz.forEachMethod(method -> {
                DexCode code = method.rewriteCodeWithJumboStrings(mapping, application.dexItemFactory, this.options.testing.forceJumboStringProcessing);
                codeMapping.put((DexEncodedMethod)method, code);
                if (!isSharedSynthetic) {
                    method.removeCode();
                }
            });
        }
        return MethodToCodeObjectMapping.fromMapBacking(codeMapping);
    }

    private FileWriter.ByteBufferResult writeDexFile(ObjectToOffsetMapping objectMapping, MethodToCodeObjectMapping codeMapping, ByteBufferProvider provider) {
        FileWriter fileWriter = new FileWriter(provider, objectMapping, codeMapping, this.application, this.options, this.namingLens);
        fileWriter.collect();
        return fileWriter.generate();
    }

    private static String mapMainDexListName(DexType type, NamingLens namingLens) {
        return DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private static String writeMainDexList(DexApplication application, NamingLens namingLens) {
        StringBuilder builder = new StringBuilder();
        ArrayList<DexType> list = new ArrayList<DexType>(application.mainDexList);
        list.sort(DexType::slowCompareTo);
        list.forEach(type -> builder.append(ApplicationWriter.mapMainDexListName(type, namingLens)).append('\n'));
        return builder.toString();
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(ParameterAnnotationsList parameterAnnotationsList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

