/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import java.util.Collection;
import java.util.Map;

public abstract class MethodToCodeObjectMapping {
    public abstract DexCode getCode(DexEncodedMethod var1);

    public abstract void clearCode(DexEncodedMethod var1, boolean var2);

    public abstract boolean verifyCodeObjects(Collection<DexCode> var1);

    public static MethodToCodeObjectMapping fromMethodBacking() {
        return MethodBacking.INSTANCE;
    }

    public static MethodToCodeObjectMapping fromMapBacking(Map<DexEncodedMethod, DexCode> map2) {
        return new MapBacking(map2);
    }

    private static class MapBacking
    extends MethodToCodeObjectMapping {
        private final Map<DexEncodedMethod, DexCode> codes;

        public MapBacking(Map<DexEncodedMethod, DexCode> codes) {
            this.codes = codes;
        }

        @Override
        public DexCode getCode(DexEncodedMethod method) {
            return this.codes.get(method);
        }

        @Override
        public void clearCode(DexEncodedMethod method, boolean isSharedSynthetic) {
            this.codes.put(method, null);
        }

        @Override
        public boolean verifyCodeObjects(Collection<DexCode> codes) {
            assert (this.codes.values().containsAll(codes));
            return true;
        }
    }

    private static class MethodBacking
    extends MethodToCodeObjectMapping {
        private static final MethodBacking INSTANCE = new MethodBacking();

        private MethodBacking() {
        }

        @Override
        public DexCode getCode(DexEncodedMethod method) {
            Code code = method.getCode();
            assert (code == null || code.isDexCode());
            return code == null ? null : code.asDexCode();
        }

        @Override
        public void clearCode(DexEncodedMethod method, boolean isSharedSynthetic) {
            if (!isSharedSynthetic) {
                method.removeCode();
            }
        }

        @Override
        public boolean verifyCodeObjects(Collection<DexCode> codes) {
            return true;
        }
    }
}

