/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dexfilemerger;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFileMergerHelper;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.OptionsParsing;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public class DexFileMerger {
    private static final String DEX_PREFIX = "classes";
    private static final String DEFAULT_OUTPUT_ARCHIVE_FILENAME = "classes.dex.jar";
    private static final boolean PRINT_ARGS = false;

    private static Options parseArguments(String[] args) throws IOException {
        if (args.length == 1 && args[0].startsWith("@")) {
            Path paramsFile = Paths.get(args[0].substring(1), new String[0]);
            ArrayList<String> argsList = new ArrayList<String>();
            for (String s : Files.readAllLines(paramsFile)) {
                if ((s = s.trim()).isEmpty()) continue;
                if (s.length() >= 2 && s.startsWith("'") && s.endsWith("'")) {
                    s = s.substring(1, s.length() - 1);
                }
                argsList.add(s);
            }
            args = argsList.toArray(new String[argsList.size()]);
        }
        Options options = new Options();
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        while (context.head() != null) {
            if (context.head().startsWith("@")) {
                throw new RuntimeException("A params file must be the only argument: " + context.head());
            }
            List<String> strings = OptionsParsing.tryParseMulti(context, "--input");
            if (strings != null) {
                options.inputArchives.addAll(strings);
                continue;
            }
            String string = OptionsParsing.tryParseSingle(context, "--output", "-o");
            if (string != null) {
                options.outputArchive = string;
                continue;
            }
            string = OptionsParsing.tryParseSingle(context, "--multidex", null);
            if (string != null) {
                options.multidexMode = MultidexStrategy.parse(string);
                continue;
            }
            string = OptionsParsing.tryParseSingle(context, "--main-dex-list", null);
            if (string != null) {
                options.mainDexListFile = string;
                continue;
            }
            Boolean b = OptionsParsing.tryParseBoolean(context, "--minimal-main-dex");
            if (b != null) {
                options.minimalMainDex = b;
                continue;
            }
            b = OptionsParsing.tryParseBoolean(context, "--verbose");
            if (b != null) {
                options.verbose = b;
                continue;
            }
            string = OptionsParsing.tryParseSingle(context, "--max-bytes-wasted-per-file", null);
            if (string != null) {
                System.err.println("Warning: '--max-bytes-wasted-per-file' is ignored.");
                continue;
            }
            string = OptionsParsing.tryParseSingle(context, "--set-max-idx-number", null);
            if (string != null) {
                System.err.println("Warning: The '--set-max-idx-number' option is ignored.");
                continue;
            }
            b = OptionsParsing.tryParseBoolean(context, "--forceJumbo");
            if (b != null) {
                System.err.println("Warning: '--forceJumbo' can be safely omitted. Strings will only use jumbo-string indexing if necessary.");
                continue;
            }
            string = OptionsParsing.tryParseSingle(context, "--dex_prefix", null);
            if (string != null) {
                options.dexPrefix = string;
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    private static int parseFileIndexFromShardFilename(String inputArchive) {
        String name;
        Pattern namingPattern = Pattern.compile("([0-9]+)\\..*");
        Matcher matcher = namingPattern.matcher(name = new File(inputArchive).getName());
        if (!matcher.matches()) {
            throw new RuntimeException(String.format("Expect input named <N>.xxx.zip for --multidex=given_shard but got %s.", name));
        }
        int shard = Integer.parseInt(matcher.group(1));
        if (shard <= 0) {
            throw new RuntimeException(String.format("Expect positive N in input named <N>.xxx.zip but got %d.", shard));
        }
        return shard;
    }

    public static void run(String[] args) throws CompilationFailedException, IOException {
        Options options = DexFileMerger.parseArguments(args);
        if (options.inputArchives.isEmpty()) {
            throw new RuntimeException("Need at least one --input");
        }
        if (options.mainDexListFile != null && options.inputArchives.size() != 1) {
            throw new RuntimeException("--main-dex-list only supported with exactly one --input, use DexFileSplitter for more");
        }
        if (!options.multidexMode.isMultidexAllowed()) {
            if (options.mainDexListFile != null) {
                throw new RuntimeException("--main-dex-list is only supported with multidex enabled, but mode is: " + options.multidexMode.toString());
            }
            if (options.minimalMainDex) {
                throw new RuntimeException("--minimal-main-dex is only supported with multidex enabled, but mode is: " + options.multidexMode.toString());
            }
        }
        D8Command.Builder builder = D8Command.builder();
        HashMap<String, Integer> inputOrdering = new HashMap<String, Integer>(options.inputArchives.size());
        int sequenceNumber = 0;
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
            inputOrdering.put(s, sequenceNumber++);
        }
        Integer singleFixedFileIndex = null;
        switch (options.multidexMode) {
            case OFF: {
                singleFixedFileIndex = 0;
                break;
            }
            case GIVEN_SHARD: {
                if (options.inputArchives.size() != 1) {
                    throw new RuntimeException("'--multidex=given_shard' requires exactly one --input.");
                }
                singleFixedFileIndex = DexFileMerger.parseFileIndexFromShardFilename(options.inputArchives.get(0)) - 1;
                break;
            }
            case MINIMAL: 
            case BEST_EFFORT: {
                break;
            }
            default: {
                throw new Unreachable("Unexpected enum: " + (Object)((Object)options.multidexMode));
            }
        }
        if (options.mainDexListFile != null) {
            builder.addMainDexListFiles(Paths.get(options.mainDexListFile, new String[0]));
        }
        ArchiveConsumer consumer = new ArchiveConsumer(Paths.get(options.outputArchive, new String[0]), options.dexPrefix, singleFixedFileIndex);
        builder.setProgramConsumer(consumer);
        DexFileMergerHelper.run((D8Command)builder.build(), options.minimalMainDex, inputOrdering);
        if (!consumer.hasWrittenSomething()) {
            File f = new File(options.outputArchive);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            out.close();
        }
    }

    public static void main(String[] args) {
        try {
            DexFileMerger.run(args);
        }
        catch (CompilationFailedException | IOException e) {
            System.err.println("Merge failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        System.err.print("r8.DexFileMerger");
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    private static class ArchiveConsumer
    implements DexIndexedConsumer {
        private final Path path;
        private final String prefix;
        private final Integer singleFixedFileIndex;
        private final Origin origin;
        private ZipOutputStream stream = null;
        private int highestIndexWritten = -1;
        private final Map<Integer, Runnable> writers = new TreeMap<Integer, Runnable>();
        private boolean hasWrittenSomething = false;

        private ArchiveConsumer(Path path, String prefix, Integer singleFixedFileIndex) {
            this.path = path;
            this.prefix = prefix;
            this.singleFixedFileIndex = singleFixedFileIndex;
            this.origin = new PathOrigin(path);
        }

        private boolean hasWrittenSomething() {
            return this.hasWrittenSomething;
        }

        private String getDexFileName(int fileIndex) {
            if (this.singleFixedFileIndex != null) {
                fileIndex = this.singleFixedFileIndex;
            }
            return this.prefix + (fileIndex == 0 ? "" : Integer.valueOf(fileIndex + 1)) + ".dex";
        }

        @Override
        public synchronized void accept(int fileIndex, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.singleFixedFileIndex != null && fileIndex != 0) {
                handler.error(new StringDiagnostic("Result does not fit into a single dex file."));
                return;
            }
            byte[] bytes = data.copyByteData();
            this.writers.put(fileIndex, () -> this.writeEntry(fileIndex, bytes, descriptors, handler));
            while (this.writers.containsKey(this.highestIndexWritten + 1)) {
                ++this.highestIndexWritten;
                this.writers.get(this.highestIndexWritten).run();
                this.writers.remove(this.highestIndexWritten);
            }
        }

        private synchronized ZipOutputStream getStream(DiagnosticsHandler handler) {
            if (this.stream == null) {
                try {
                    this.stream = new ZipOutputStream(Files.newOutputStream(this.path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                }
                catch (IOException e) {
                    handler.error(new ExceptionDiagnostic(e, this.origin));
                }
            }
            return this.stream;
        }

        private void writeEntry(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            try {
                ZipUtils.writeToZipStream(this.getStream(handler), this.getDexFileName(fileIndex), ByteDataView.of(data), 8);
                this.hasWrittenSomething = true;
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (!this.writers.isEmpty()) {
                handler.error(new StringDiagnostic("Failed to write zip, for a multidex output some of the classes.dex files were not produced."));
            }
            try {
                if (this.stream != null) {
                    this.stream.close();
                    this.stream = null;
                }
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }
    }

    private static class Options {
        List<String> inputArchives = new ArrayList<String>();
        String outputArchive = "classes.dex.jar";
        MultidexStrategy multidexMode = MultidexStrategy.OFF;
        String mainDexListFile = null;
        boolean minimalMainDex = false;
        boolean verbose = false;
        String dexPrefix = "classes";

        private Options() {
        }
    }

    private static enum MultidexStrategy {
        OFF,
        GIVEN_SHARD,
        MINIMAL,
        BEST_EFFORT;


        public boolean isMultidexAllowed() {
            switch (this) {
                case OFF: 
                case GIVEN_SHARD: {
                    return false;
                }
                case MINIMAL: 
                case BEST_EFFORT: {
                    return true;
                }
            }
            throw new AssertionError((Object)("Unknown: " + (Object)((Object)this)));
        }

        public static MultidexStrategy parse(String value) {
            switch (value) {
                case "off": {
                    return OFF;
                }
                case "given_shard": {
                    return GIVEN_SHARD;
                }
                case "minimal": {
                    return MINIMAL;
                }
                case "best_effort": {
                    return BEST_EFFORT;
                }
            }
            throw new RuntimeException("Multidex argument must be either 'off', 'given_shard', 'minimal' or 'best_effort'.");
        }
    }
}

