/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;

public abstract class AccessFlags<T extends AccessFlags<T>> {
    protected static final int BASE_FLAGS = 4127;
    private static final List<String> NAMES = ImmutableList.of("public", "private", "protected", "static", "final", "synthetic");
    protected int originalFlags;
    protected int modifiedFlags;

    protected List<BooleanSupplier> getPredicates() {
        return ImmutableList.of(this::isPublic, this::isPrivate, this::isProtected, this::isStatic, this::isFinal, this::isSynthetic);
    }

    protected List<String> getNames() {
        return NAMES;
    }

    protected AccessFlags(int originalFlags, int modifiedFlags) {
        this.originalFlags = originalFlags;
        this.modifiedFlags = modifiedFlags;
    }

    public abstract T copy();

    public abstract T self();

    public int materialize() {
        return this.modifiedFlags;
    }

    public abstract int getAsCfAccessFlags();

    public abstract int getAsDexAccessFlags();

    public final int getOriginalAccessFlags() {
        return this.originalFlags;
    }

    public boolean equals(Object object) {
        if (object instanceof AccessFlags) {
            AccessFlags other = (AccessFlags)object;
            return this.originalFlags == other.originalFlags && this.modifiedFlags == other.modifiedFlags;
        }
        return false;
    }

    public int hashCode() {
        return this.originalFlags | this.modifiedFlags;
    }

    public boolean isMoreVisibleThan(AccessFlags other) {
        return this.visibilityOrdinal() > other.visibilityOrdinal();
    }

    public boolean isAtLeastAsVisibleAs(AccessFlags other) {
        return this.visibilityOrdinal() >= other.visibilityOrdinal();
    }

    private int visibilityOrdinal() {
        if (this.isPublic()) {
            return 3;
        }
        if (this.isProtected()) {
            return 2;
        }
        if (this.isPrivate()) {
            return 0;
        }
        return 1;
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public void setPublic() {
        assert (!this.isPrivate() && !this.isProtected());
        this.set(1);
    }

    public void unsetPublic() {
        this.unset(1);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public void setPrivate() {
        assert (!this.isPublic() && !this.isProtected());
        this.set(2);
    }

    public void unsetPrivate() {
        this.unset(2);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setProtected() {
        assert (!this.isPublic() && !this.isPrivate());
        this.set(4);
    }

    public void unsetProtected() {
        this.unset(4);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setFinal() {
        this.set(16);
    }

    public void unsetFinal() {
        this.unset(16);
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public void setSynthetic() {
        this.set(4096);
    }

    public void unsetSynthetic() {
        this.unset(4096);
    }

    public void promoteToFinal() {
        this.promote(16);
    }

    public void demoteFromFinal() {
        this.demote(16);
    }

    public boolean isPromotedToPublic() {
        return this.isPromoted(1);
    }

    public void promoteToPublic() {
        this.demote(6);
        this.promote(1);
    }

    public void promoteToStatic() {
        this.promote(8);
    }

    private boolean wasSet(int flag) {
        return (this.originalFlags & flag) != 0;
    }

    protected boolean isSet(int flag) {
        return (this.modifiedFlags & flag) != 0;
    }

    protected void set(int flag) {
        this.originalFlags |= flag;
        this.modifiedFlags |= flag;
    }

    protected void unset(int flag) {
        this.originalFlags &= ~flag;
        this.modifiedFlags &= ~flag;
    }

    protected boolean isPromoted(int flag) {
        return !this.wasSet(flag) && this.isSet(flag);
    }

    protected void promote(int flag) {
        this.modifiedFlags |= flag;
    }

    protected void demote(int flag) {
        this.modifiedFlags &= ~flag;
    }

    public String toSmaliString() {
        return this.toStringInternal(true);
    }

    public String toString() {
        return this.toStringInternal(false);
    }

    private String toStringInternal(boolean ignoreSuper) {
        List<String> names = this.getNames();
        List<BooleanSupplier> predicates = this.getPredicates();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (!predicates.get(i).getAsBoolean() || ignoreSuper && names.get(i).equals("super")) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(names.get(i));
        }
        return builder.toString();
    }
}

