/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.ClassHierarchy;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.origin.Origin;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;

public class AppInfoWithSubtyping
extends AppInfo
implements ClassHierarchy {
    private static final int ROOT_LEVEL = 0;
    private static final int UNKNOWN_LEVEL = -1;
    private static final int INTERFACE_LEVEL = -2;
    private static final Set<DexType> NO_DIRECT_SUBTYPE = ImmutableSet.of();
    private final Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Map<DexType, ImmutableSet<DexType>> subtypeMap = new IdentityHashMap<DexType, ImmutableSet<DexType>>();
    private final Map<DexType, TypeInfo> typeInfo;

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.typeInfo = Collections.synchronizedMap(new IdentityHashMap());
        this.populateSubtypeMap(application.asDirect(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
        this.typeInfo = Collections.synchronizedMap(new IdentityHashMap<DexType, TypeInfo>(previous.typeInfo));
        assert (this.app() instanceof DirectMappedDexApplication);
    }

    private DirectMappedDexApplication getDirectApplication() {
        return (DirectMappedDexApplication)this.app();
    }

    public Iterable<DexLibraryClass> libraryClasses() {
        assert (this.checkIfObsolete());
        return this.getDirectApplication().libraryClasses();
    }

    public Set<DexType> getMissingClasses() {
        assert (this.checkIfObsolete());
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public Set<DexType> subtypes(DexType type) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Map<DexType, Set<DexType>> map2, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map2.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map2, superType, baseClass, definitions);
        }
    }

    private TypeInfo getTypeInfo(DexType type) {
        return this.typeInfo.computeIfAbsent(type, TypeInfo::new);
    }

    private void populateAllSuperTypes(Map<DexType, Set<DexType>> map2, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map2, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                this.getTypeInfo(holderClass.superType).addDirectSubtype(this.getTypeInfo(holder));
            } else assert (this.dexItemFactory().objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map2, inter, baseClass, definitions);
                this.getTypeInfo(inter).addInterfaceSubtype(holder);
            }
            if (holderClass.isInterface()) {
                this.getTypeInfo(holder).tagAsInteface();
            }
        } else {
            if (baseClass.isProgramClass() || baseClass.isClasspathClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory().objectType) {
                this.getTypeInfo(this.dexItemFactory().objectType).addDirectSubtype(this.getTypeInfo(holder));
            }
        }
    }

    private void populateSubtypeMap(DirectMappedDexApplication app, DexItemFactory dexItemFactory) {
        this.getTypeInfo(dexItemFactory.objectType).tagAsSubtypeRoot();
        IdentityHashMap<DexType, Set<DexType>> map2 = new IdentityHashMap<DexType, Set<DexType>>();
        for (DexClass dexClass : app.allClasses()) {
            this.populateAllSuperTypes(map2, dexClass.type, dexClass, app::definitionFor);
        }
        for (Map.Entry entry : map2.entrySet()) {
            this.subtypeMap.put((DexType)entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        assert (this.validateLevelsAreCorrect(app::definitionFor, dexItemFactory));
    }

    private boolean validateLevelsAreCorrect(Function<DexType, DexClass> definitions, DexItemFactory dexItemFactory) {
        Set<DexType> seenTypes = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        DexType objectType = dexItemFactory.objectType;
        worklist.add(objectType);
        while (!worklist.isEmpty()) {
            DexType next = (DexType)worklist.pop();
            DexClass nextHolder = definitions.apply(next);
            DexType superType = nextHolder == null ? (next == dexItemFactory.objectType ? null : dexItemFactory.objectType) : nextHolder.superType;
            assert (!seenTypes.contains(next));
            seenTypes.add(next);
            TypeInfo superInfo = this.getTypeInfo(superType);
            TypeInfo nextInfo = this.getTypeInfo(next);
            if (superType == null) {
                assert (nextInfo.hierarchyLevel == 0);
            } else {
                assert (superInfo.hierarchyLevel == nextInfo.hierarchyLevel - 1 || superInfo.hierarchyLevel == 0 && nextInfo.hierarchyLevel == -2);
                assert (superInfo.directSubtypes.contains(next));
            }
            if (nextInfo.hierarchyLevel != -2) {
                worklist.addAll(nextInfo.directSubtypes);
                continue;
            }
            if (nextHolder == null) continue;
            for (DexType iface : nextHolder.interfaces.values) {
                TypeInfo ifaceInfo = this.getTypeInfo(iface);
                assert (ifaceInfo.directSubtypes.contains(next));
                assert (ifaceInfo.hierarchyLevel == -2);
            }
        }
        return true;
    }

    public Set<DexEncodedMethod> lookupVirtualTargets(DexMethod method) {
        assert (this.checkIfObsolete());
        if (method.holder.isArrayType()) {
            return null;
        }
        DexClass root = this.definitionFor(method.holder);
        if (root == null) {
            return null;
        }
        AppInfo.ResolutionResult topTargets = this.resolveMethodOnClass(method.holder, method);
        if (topTargets.asResultOfResolve() == null) {
            return null;
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        topTargets.forEachTarget(result::add);
        for (DexType type : this.subtypes(method.holder)) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult methods = this.resolveMethodOnClass(type, method);
            methods.forEachTarget(target -> {
                if (target.isVirtualMethod()) {
                    result.add((DexEncodedMethod)target);
                }
            });
        }
        return result;
    }

    @Override
    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        assert (this.checkIfObsolete());
        if (!this.isSubtype(invocationContext, method.holder)) {
            DexClass contextClass = this.definitionFor(invocationContext);
            this.isSubtype(invocationContext, method.holder);
            throw new CompilationError("Illegal invoke-super to " + method.toSourceString() + " from class " + invocationContext, contextClass != null ? contextClass.getOrigin() : Origin.unknown());
        }
        return super.lookupSuperTarget(method, invocationContext);
    }

    protected boolean hasAnyInstantiatedLambdas(DexType type) {
        assert (this.checkIfObsolete());
        return true;
    }

    public Set<DexEncodedMethod> lookupInterfaceTargets(DexMethod method) {
        DexEncodedMethod singleTarget;
        assert (this.checkIfObsolete());
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        if (topTarget.hasSingleTarget() && (singleTarget = topTarget.asSingleTarget()).getCode() != null && this.hasAnyInstantiatedLambdas(singleTarget.method.holder)) {
            result.add(singleTarget);
        }
        Set<DexType> set = this.subtypes(method.holder);
        for (DexType type : set) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult targetMethods = this.resolveMethodOnClass(type, method);
            targetMethods.forEachTarget(result::add);
        }
        return result;
    }

    public Set<DexEncodedMethod> lookupLambdaImplementedMethods(DexCallSite callSite) {
        assert (this.checkIfObsolete());
        List<DexType> callSiteInterfaces = LambdaDescriptor.getInterfaces(callSite, this);
        if (callSiteInterfaces == null || callSiteInterfaces.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(callSiteInterfaces);
        Set<DexType> visited = Sets.newIdentityHashSet();
        while (!worklist.isEmpty()) {
            DexType iface = (DexType)worklist.removeFirst();
            if (this.getTypeInfo(iface).isUnknown() || !visited.add(iface)) continue;
            assert (this.getTypeInfo(iface).isInterface());
            DexClass clazz = this.definitionFor(iface);
            if (clazz == null) continue;
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                if (method.method.name != callSite.methodName || !method.accessFlags.isAbstract()) continue;
                result.add(method);
            }
            Collections.addAll(worklist, clazz.interfaces.values);
        }
        return result;
    }

    public boolean isStringConcat(DexMethodHandle bootstrapMethod) {
        assert (this.checkIfObsolete());
        return bootstrapMethod.type.isInvokeStatic() && (bootstrapMethod.asMethod() == this.dexItemFactory().stringConcatWithConstantsMethod || bootstrapMethod.asMethod() == this.dexItemFactory().stringConcatMethod);
    }

    @Override
    public void registerNewType(DexType newType, DexType superType) {
        assert (this.checkIfObsolete());
        this.getTypeInfo(superType).addDirectSubtype(this.getTypeInfo(newType));
    }

    @Override
    public boolean hasSubtyping() {
        assert (this.checkIfObsolete());
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        assert (this.checkIfObsolete());
        return this;
    }

    public Set<DexType> allImmediateSubtypes(DexType type) {
        return this.getTypeInfo((DexType)type).directSubtypes;
    }

    public boolean isUnknown(DexType type) {
        return this.getTypeInfo(type).isUnknown();
    }

    public boolean isMarkedAsInterface(DexType type) {
        return this.getTypeInfo(type).isInterface();
    }

    @Override
    public boolean hasSubtypes(DexType type) {
        return !this.getTypeInfo((DexType)type).directSubtypes.isEmpty();
    }

    @Override
    public boolean isSubtype(DexType subtype, DexType supertype) {
        return subtype == supertype || this.isStrictSubtypeOf(subtype, supertype);
    }

    public boolean isStrictSubtypeOf(DexType subtype, DexType supertype) {
        return this.isStrictSubtypeOf(subtype, supertype, false);
    }

    public boolean isStrictSubtypeOf(DexType subtype, DexType supertype, boolean orElse) {
        if (subtype == supertype) {
            return false;
        }
        if (subtype == this.dexItemFactory().objectType) {
            return false;
        }
        if (supertype == this.dexItemFactory().objectType) {
            return true;
        }
        TypeInfo subInfo = this.getTypeInfo(subtype);
        if (subInfo.hierarchyLevel == -2) {
            return this.isInterfaceSubtypeOf(subtype, supertype);
        }
        TypeInfo superInfo = this.getTypeInfo(supertype);
        if (superInfo.hierarchyLevel == -2) {
            return superInfo.directSubtypes.stream().anyMatch(superSubtype -> this.isSubtype(subtype, (DexType)superSubtype));
        }
        return this.isSubtypeOfClass(subInfo, superInfo, orElse);
    }

    private boolean isInterfaceSubtypeOf(DexType candidate, DexType other) {
        if (candidate == other || other == this.dexItemFactory().objectType) {
            return true;
        }
        DexClass candidateHolder = this.definitionFor(candidate);
        if (candidateHolder == null) {
            return false;
        }
        for (DexType iface : candidateHolder.interfaces.values) {
            assert (this.getTypeInfo((DexType)iface).hierarchyLevel == -2);
            if (!this.isInterfaceSubtypeOf(iface, other)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfClass(TypeInfo subInfo, TypeInfo superInfo, boolean orElse) {
        if (superInfo.hierarchyLevel == -1) {
            return orElse;
        }
        while (superInfo.hierarchyLevel < subInfo.hierarchyLevel) {
            DexClass holder = this.definitionFor(subInfo.type);
            assert (holder != null && !holder.isInterface());
            subInfo = this.getTypeInfo(holder.superType);
        }
        return subInfo.type == superInfo.type;
    }

    public void forAllExtendsSubtypes(DexType type, Consumer<DexType> f) {
        this.allExtendsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allExtendsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, t -> this.getTypeInfo((DexType)t).isInterface());
        }
        if (info.hierarchyLevel == 0) {
            return Iterables.filter(info.directSubtypes, t -> !this.getTypeInfo((DexType)t).isInterface());
        }
        return info.directSubtypes;
    }

    public void forAllImplementsSubtypes(DexType type, Consumer<DexType> f) {
        this.allImplementsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allImplementsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, subtype -> !this.getTypeInfo((DexType)subtype).isInterface());
        }
        return ImmutableList.of();
    }

    public boolean isMissingOrHasMissingSuperType(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz == null || clazz.hasMissingSuperType(this);
    }

    public boolean isExternalizable(DexType type) {
        return this.implementedInterfaces(type).contains(this.dexItemFactory().externalizableType);
    }

    public boolean isSerializable(DexType type) {
        return this.implementedInterfaces(type).contains(this.dexItemFactory().serializableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DexType> implementedInterfaces(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        if (info.implementedInterfaces != null) {
            return info.implementedInterfaces;
        }
        AppInfoWithSubtyping appInfoWithSubtyping = this;
        synchronized (appInfoWithSubtyping) {
            if (info.implementedInterfaces == null) {
                Set<DexType> interfaces = Sets.newIdentityHashSet();
                this.implementedInterfaces(type, interfaces);
                info.implementedInterfaces = interfaces;
            }
        }
        return info.implementedInterfaces;
    }

    private void implementedInterfaces(DexType type, Set<DexType> interfaces) {
        DexClass dexClass = this.definitionFor(type);
        while (dexClass != null) {
            if (dexClass.isInterface()) {
                interfaces.add(dexClass.type);
            }
            for (DexType itf : dexClass.interfaces.values) {
                this.implementedInterfaces(itf, interfaces);
            }
            if (dexClass.superType == null) break;
            dexClass = this.definitionFor(dexClass.superType);
        }
    }

    public DexType getSingleSubtype(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.directSubtypes.size() == 1) {
            return Iterables.getFirst(info.directSubtypes, null);
        }
        return null;
    }

    @Override
    public boolean isDirectSubtype(DexType subtype, DexType supertype) {
        TypeInfo info = this.getTypeInfo(supertype);
        assert (info.hierarchyLevel != -1);
        return info.directSubtypes.contains(subtype);
    }

    public DexType computeLeastUpperBoundOfClasses(DexType subtype, DexType other) {
        DexClass dexClass;
        TypeInfo t2;
        TypeInfo t1;
        if (subtype == other) {
            return subtype;
        }
        DexType objectType = this.dexItemFactory().objectType;
        TypeInfo subInfo = this.getTypeInfo(subtype);
        TypeInfo superInfo = this.getTypeInfo(other);
        if (subInfo.hierarchyLevel == -1 || superInfo.hierarchyLevel == -1) {
            return objectType;
        }
        if (subtype == objectType || other == objectType) {
            return objectType;
        }
        if (superInfo.hierarchyLevel < subInfo.hierarchyLevel) {
            t1 = superInfo;
            t2 = subInfo;
        } else {
            t1 = subInfo;
            t2 = superInfo;
        }
        while (t2.hierarchyLevel > t1.hierarchyLevel) {
            dexClass = this.definitionFor(t2.type);
            if (dexClass == null || dexClass.superType == null) {
                return objectType;
            }
            t2 = this.getTypeInfo(dexClass.superType);
        }
        DexType lubType = t1.type;
        DexType t2Type = t2.type;
        while (t2Type != lubType) {
            assert (this.getTypeInfo((DexType)t2Type).hierarchyLevel == this.getTypeInfo((DexType)lubType).hierarchyLevel);
            dexClass = this.definitionFor(t2Type);
            if (dexClass == null) {
                lubType = objectType;
                break;
            }
            t2Type = dexClass.superType;
            dexClass = this.definitionFor(lubType);
            if (dexClass == null) {
                lubType = objectType;
                break;
            }
            lubType = dexClass.superType;
        }
        return lubType;
    }

    private static class TypeInfo {
        final DexType type;
        int hierarchyLevel = -1;
        Set<DexType> directSubtypes = AppInfoWithSubtyping.access$000();
        Set<DexType> implementedInterfaces = null;

        public TypeInfo(DexType type) {
            this.type = type;
        }

        public String toString() {
            return "TypeInfo{" + this.type + ", level:" + this.hierarchyLevel + "}";
        }

        private void ensureDirectSubTypeSet() {
            if (this.directSubtypes == NO_DIRECT_SUBTYPE) {
                this.directSubtypes = new TreeSet<DexType>(DexType::slowCompareTo);
            }
        }

        private void setLevel(int level) {
            if (level == this.hierarchyLevel) {
                return;
            }
            if (this.hierarchyLevel == -2) {
                assert (level == 1);
            } else if (level == -2) {
                assert (this.hierarchyLevel == 1 || this.hierarchyLevel == -1);
                this.hierarchyLevel = -2;
            } else {
                assert (this.hierarchyLevel == -1);
                this.hierarchyLevel = level;
            }
        }

        public synchronized void addDirectSubtype(TypeInfo subtypeInfo) {
            assert (this.hierarchyLevel != -1);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(subtypeInfo.type);
            subtypeInfo.setLevel(this.hierarchyLevel + 1);
        }

        void tagAsSubtypeRoot() {
            this.setLevel(0);
        }

        void tagAsInteface() {
            this.setLevel(-2);
        }

        public boolean isInterface() {
            assert (this.hierarchyLevel != -1) : "Program class missing: " + this;
            assert (this.type.isClassType());
            return this.hierarchyLevel == -2;
        }

        public boolean isUnknown() {
            return this.hierarchyLevel == -1;
        }

        synchronized void addInterfaceSubtype(DexType type) {
            this.setLevel(-2);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(type);
        }
    }
}

