/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AppServices {
    public static final String SERVICE_DIRECTORY_NAME = "META-INF/services/";
    private final AppView<?> appView;
    private final Map<DexType, List<DexType>> services;

    private AppServices(AppView<?> appView, Map<DexType, List<DexType>> services) {
        this.appView = appView;
        this.services = services;
    }

    public Set<DexType> allServiceTypes() {
        assert (this.verifyRewrittenWithLens());
        return this.services.keySet();
    }

    public List<DexType> serviceImplementationsFor(DexType serviceType) {
        assert (this.verifyRewrittenWithLens());
        assert (this.services.containsKey(serviceType));
        List<DexType> serviceImplementationTypes = this.services.get(serviceType);
        if (serviceImplementationTypes == null) {
            assert (false) : "Unexpected attempt to get service implementations for non-service type `" + serviceType.toSourceString() + "`";
            return ImmutableList.of();
        }
        return serviceImplementationTypes;
    }

    public AppServices rewrittenWithLens(GraphLense graphLens) {
        ImmutableMap.Builder<DexType, ImmutableCollection> rewrittenServices = ImmutableMap.builder();
        for (Map.Entry<DexType, List<DexType>> entry : this.services.entrySet()) {
            DexType rewrittenServiceType = graphLens.lookupType(entry.getKey());
            ImmutableList.Builder rewrittenServiceImplementationTypes = ImmutableList.builder();
            for (DexType serviceImplementationType : entry.getValue()) {
                rewrittenServiceImplementationTypes.add(graphLens.lookupType(serviceImplementationType));
            }
            rewrittenServices.put(rewrittenServiceType, rewrittenServiceImplementationTypes.build());
        }
        return new AppServices(this.appView, rewrittenServices.build());
    }

    private boolean verifyRewrittenWithLens() {
        for (Map.Entry<DexType, List<DexType>> entry : this.services.entrySet()) {
            assert (entry.getKey() == this.appView.graphLense().lookupType(entry.getKey()));
            for (DexType type : entry.getValue()) {
                assert (type == this.appView.graphLense().lookupType(type));
            }
        }
        return true;
    }

    public static Builder builder(AppView<?> appView) {
        return new Builder(appView);
    }

    public static class Builder {
        private final AppView<?> appView;
        private final Map<DexType, List<DexType>> services = new IdentityHashMap<DexType, List<DexType>>();

        private Builder(AppView<?> appView) {
            this.appView = appView;
        }

        public AppServices build() {
            for (DataResourceProvider provider : ((AppInfo)this.appView.appInfo()).app().dataResourceProviders) {
                this.readServices(provider);
            }
            return new AppServices(this.appView, this.services);
        }

        private void readServices(DataResourceProvider dataResourceProvider) {
            try {
                dataResourceProvider.accept(new DataResourceProviderVisitor());
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }

        private class DataResourceProviderVisitor
        implements DataResourceProvider.Visitor {
            private DataResourceProviderVisitor() {
            }

            @Override
            public void visit(DataDirectoryResource directory) {
            }

            @Override
            public void visit(DataEntryResource file) {
                try {
                    String serviceName;
                    String name = file.getName();
                    if (name.startsWith(AppServices.SERVICE_DIRECTORY_NAME) && DescriptorUtils.isValidJavaType(serviceName = name.substring(AppServices.SERVICE_DIRECTORY_NAME.length()))) {
                        String serviceDescriptor = DescriptorUtils.javaTypeToDescriptor(serviceName);
                        DexType serviceType = Builder.this.appView.dexItemFactory().createType(serviceDescriptor);
                        byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                        String contents = new String(bytes, Charset.defaultCharset());
                        Builder.this.services.put(serviceType, this.readServiceImplementationsForService(contents, file.getOrigin()));
                    }
                }
                catch (ResourceException | IOException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }

            private List<DexType> readServiceImplementationsForService(String contents, Origin origin) {
                if (contents != null) {
                    HashSet seenTypes = new HashSet();
                    return Arrays.stream(contents.split(System.lineSeparator())).map(String::trim).map(this::prefixUntilCommentChar).filter(line -> !line.isEmpty()).filter(DescriptorUtils::isValidJavaType).map(DescriptorUtils::javaTypeToDescriptor).map(Builder.this.appView.dexItemFactory()::createType).filter(serviceImplementationType -> {
                        if (!serviceImplementationType.isClassType()) {
                            ((Builder)Builder.this).appView.options().reporter.warning(new StringDiagnostic("Unexpected service implementation found in META-INF/services/: `" + serviceImplementationType.toSourceString() + "`.", origin));
                            return false;
                        }
                        return seenTypes.add(serviceImplementationType);
                    }).collect(Collectors.toList());
                }
                return ImmutableList.of();
            }

            private String prefixUntilCommentChar(String line) {
                int commentCharIndex = line.indexOf(35);
                return commentCharIndex > -1 ? line.substring(0, commentCharIndex) : line;
            }
        }
    }
}

