/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.OptionalBool;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Set;

public class AppView<T extends AppInfo>
implements DexDefinitionSupplier {
    private T appInfo;
    private AppServices appServices;
    private final DexItemFactory dexItemFactory;
    private final WholeProgramOptimizations wholeProgramOptimizations;
    private GraphLense graphLense;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private Set<DexMethod> unneededVisibilityBridgeMethods = ImmutableSet.of();
    private VerticalClassMerger.VerticallyMergedClasses verticallyMergedClasses;

    private AppView(T appInfo, WholeProgramOptimizations wholeProgramOptimizations, InternalOptions options) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo != null ? ((AppInfo)appInfo).dexItemFactory() : null;
        this.wholeProgramOptimizations = wholeProgramOptimizations;
        this.graphLense = GraphLense.getIdentityLense();
        this.options = options;
    }

    public static <T extends AppInfo> AppView<T> createForD8(T appInfo, InternalOptions options) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, options);
    }

    public static <T extends AppInfo> AppView<T> createForR8(T appInfo, InternalOptions options) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.ON, options);
    }

    public T appInfo() {
        return this.appInfo;
    }

    public <U extends T> AppView<U> setAppInfo(U appInfo) {
        assert (!((AppInfo)appInfo).isObsolete());
        T previous = this.appInfo;
        this.appInfo = appInfo;
        if (appInfo != previous) {
            ((AppInfo)previous).markObsolete();
        }
        AppView appViewWithSpecializedAppInfo = this;
        return appViewWithSpecializedAppInfo;
    }

    public AppServices appServices() {
        return this.appServices;
    }

    public void setAppServices(AppServices appServices) {
        this.appServices = appServices;
    }

    @Override
    public final DexDefinition definitionFor(DexReference reference) {
        return ((AppInfo)this.appInfo()).definitionFor(reference);
    }

    @Override
    public final DexEncodedField definitionFor(DexField field) {
        return ((AppInfo)this.appInfo()).definitionFor(field);
    }

    @Override
    public final DexEncodedMethod definitionFor(DexMethod method) {
        return ((AppInfo)this.appInfo()).definitionFor(method);
    }

    @Override
    public final DexClass definitionFor(DexType type) {
        return ((AppInfo)this.appInfo()).definitionFor(type);
    }

    public OptionalBool isInterface(DexType type) {
        if (this.enableWholeProgramOptimizations()) {
            assert (((AppInfo)this.appInfo()).hasSubtyping());
            if (((AppInfo)this.appInfo()).hasSubtyping()) {
                AppInfoWithSubtyping appInfo = ((AppInfo)this.appInfo()).withSubtyping();
                return appInfo.isUnknown(type) ? OptionalBool.unknown() : OptionalBool.of(appInfo.isMarkedAsInterface(type));
            }
        }
        return OptionalBool.unknown();
    }

    @Override
    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    public boolean enableWholeProgramOptimizations() {
        return this.wholeProgramOptimizations == WholeProgramOptimizations.ON;
    }

    public GraphLense graphLense() {
        return this.graphLense;
    }

    public boolean setGraphLense(GraphLense graphLense) {
        if (graphLense != this.graphLense) {
            this.graphLense = graphLense;
            return true;
        }
        return false;
    }

    public InternalOptions options() {
        return this.options;
    }

    public RootSetBuilder.RootSet rootSet() {
        return this.rootSet;
    }

    public void setRootSet(RootSetBuilder.RootSet rootSet) {
        assert (this.rootSet == null) : "Root set should never be recomputed";
        this.rootSet = rootSet;
    }

    public Set<DexMethod> unneededVisibilityBridgeMethods() {
        return this.unneededVisibilityBridgeMethods;
    }

    public void setUnneededVisibilityBridgeMethods(Set<DexMethod> unneededVisibilityBridgeMethods) {
        this.unneededVisibilityBridgeMethods = unneededVisibilityBridgeMethods;
    }

    public VerticalClassMerger.VerticallyMergedClasses verticallyMergedClasses() {
        return this.verticallyMergedClasses;
    }

    public void setVerticallyMergedClasses(VerticalClassMerger.VerticallyMergedClasses verticallyMergedClasses) {
        this.verticallyMergedClasses = verticallyMergedClasses;
    }

    public AppView<AppInfoWithSubtyping> withSubtyping() {
        return ((AppInfo)this.appInfo).hasSubtyping() ? this : null;
    }

    public AppView<AppInfoWithLiveness> withLiveness() {
        AppView appViewWithLiveness = this;
        return appViewWithLiveness;
    }

    public OptionalBool isSubtype(DexType subtype, DexType supertype) {
        return ((AppInfo)this.appInfo()).hasSubtyping() ? OptionalBool.of(((AppInfo)this.appInfo()).withSubtyping().isSubtype(subtype, supertype)) : OptionalBool.unknown();
    }

    private static enum WholeProgramOptimizations {
        ON,
        OFF;

    }
}

