/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

abstract class ClassHierarchyTraversal<T extends DexClass, CHT extends ClassHierarchyTraversal<T, CHT>> {
    final AppView<? extends AppInfoWithSubtyping> appView;
    final Scope scope;
    final Set<DexClass> visited = new HashSet<DexClass>();
    final Deque<T> worklist = new ArrayDeque<T>();
    boolean excludeInterfaces = false;

    ClassHierarchyTraversal(AppView<? extends AppInfoWithSubtyping> appView, Scope scope) {
        this.appView = appView;
        this.scope = scope;
    }

    abstract CHT self();

    public CHT excludeInterfaces() {
        this.excludeInterfaces = true;
        return this.self();
    }

    public void visit(Iterable<DexProgramClass> sources, Consumer<T> visitor) {
        Iterator<DexProgramClass> sourceIterator = sources.iterator();
        while (sourceIterator.hasNext() || !this.worklist.isEmpty()) {
            DexClass clazz;
            if (this.worklist.isEmpty()) {
                this.addDependentsToWorklist(sourceIterator.next());
                if (this.worklist.isEmpty()) continue;
            }
            if (!this.visited.add(clazz = (DexClass)this.worklist.removeFirst())) continue;
            assert (this.scope != Scope.ONLY_PROGRAM_CLASSES || clazz.isProgramClass());
            visitor.accept(clazz);
        }
        this.visited.clear();
    }

    abstract void addDependentsToWorklist(DexClass var1);

    static enum Scope {
        ALL_CLASSES,
        ONLY_LIBRARY_CLASSES,
        ONLY_PROGRAM_CLASSES;


        public boolean shouldBePassedToVisitor(DexClass clazz) {
            switch (this) {
                case ALL_CLASSES: {
                    return true;
                }
                case ONLY_LIBRARY_CLASSES: {
                    return clazz.isLibraryClass();
                }
                case ONLY_PROGRAM_CLASSES: {
                    return clazz.isProgramClass();
                }
            }
            throw new Unreachable();
        }
    }
}

