/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ArrayUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class DexAnnotationSet
extends CachedHashValueDexItem {
    public static final DexAnnotationSet[] EMPTY_ARRAY = new DexAnnotationSet[0];
    private static final int UNSORTED = 0;
    private static final DexAnnotationSet THE_EMPTY_ANNOTATIONS_SET = new DexAnnotationSet(DexAnnotation.EMPTY_ARRAY);
    public final DexAnnotation[] annotations;
    private int sorted = 0;

    public DexAnnotationSet(DexAnnotation[] annotations) {
        this.annotations = annotations;
    }

    public static DexType findDuplicateEntryType(DexAnnotation[] annotations) {
        return DexAnnotationSet.findDuplicateEntryType(Arrays.asList(annotations));
    }

    public static DexType findDuplicateEntryType(List<DexAnnotation> annotations) {
        HashSet<DexType> seenTypes = new HashSet<DexType>();
        for (DexAnnotation annotation : annotations) {
            if (seenTypes.add(annotation.annotation.type)) continue;
            return annotation.annotation.type;
        }
        return null;
    }

    public static DexAnnotationSet empty() {
        return THE_EMPTY_ANNOTATIONS_SET;
    }

    @Override
    public int computeHashCode() {
        return Arrays.hashCode(this.annotations);
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexAnnotationSet) {
            DexAnnotationSet o = (DexAnnotationSet)other;
            return Arrays.equals(this.annotations, o.annotations);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        DexAnnotationSet.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.annotations);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
        DexAnnotationSet.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.annotations);
    }

    public boolean isEmpty() {
        return this.annotations.length == 0;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.annotations, (a, b) -> a.annotation.type.compareTo(b.annotation.type));
        for (DexAnnotation annotation : this.annotations) {
            annotation.annotation.sort();
        }
        this.sorted = this.hashCode();
    }

    public DexAnnotation getFirstMatching(DexType type) {
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type != type) continue;
            return annotation;
        }
        return null;
    }

    public DexAnnotationSet getWithout(DexType annotationType) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == annotationType) {
                DexAnnotation[] reducedArray = new DexAnnotation[this.annotations.length - 1];
                System.arraycopy(this.annotations, 0, reducedArray, 0, index);
                if (index < reducedArray.length) {
                    System.arraycopy(this.annotations, index + 1, reducedArray, index, reducedArray.length - index);
                }
                return new DexAnnotationSet(reducedArray);
            }
            ++index;
        }
        return this;
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    public DexAnnotationSet getWithAddedOrReplaced(DexAnnotation newAnnotation) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == newAnnotation.annotation.type) {
                DexAnnotation[] modifiedArray = (DexAnnotation[])this.annotations.clone();
                modifiedArray[index] = newAnnotation;
                return new DexAnnotationSet(modifiedArray);
            }
            ++index;
        }
        DexAnnotation[] extendedArray = new DexAnnotation[this.annotations.length + 1];
        System.arraycopy(this.annotations, 0, extendedArray, 0, this.annotations.length);
        extendedArray[this.annotations.length] = newAnnotation;
        return new DexAnnotationSet(extendedArray);
    }

    public DexAnnotationSet keepIf(Predicate<DexAnnotation> filter) {
        return this.rewrite(anno -> filter.test((DexAnnotation)anno) ? anno : null);
    }

    public DexAnnotationSet rewrite(Function<DexAnnotation, DexAnnotation> rewriter) {
        if (this.isEmpty()) {
            return this;
        }
        DexAnnotation[] rewritten = ArrayUtils.map(DexAnnotation[].class, this.annotations, rewriter);
        if (rewritten == this.annotations) {
            return this;
        }
        if (rewritten.length == 0) {
            return DexAnnotationSet.empty();
        }
        return new DexAnnotationSet(rewritten);
    }

    public String toString() {
        return Arrays.toString(this.annotations);
    }
}

