/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DexApplication {
    public final ImmutableList<DataResourceProvider> dataResourceProviders;
    public final ImmutableSet<DexType> mainDexList;
    public final String deadCode;
    private final ClassNameMapper proguardMap;
    public final Timing timing;
    public final DexItemFactory dexItemFactory;
    public final DexString highestSortingString;

    DexApplication(ClassNameMapper proguardMap, ImmutableList<DataResourceProvider> dataResourceProviders, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        this.proguardMap = proguardMap;
        this.dataResourceProviders = dataResourceProviders;
        this.mainDexList = mainDexList;
        this.deadCode = deadCode;
        this.dexItemFactory = dexItemFactory;
        this.highestSortingString = highestSortingString;
        this.timing = timing;
    }

    public abstract Builder<?> builder();

    abstract List<DexProgramClass> programClasses();

    public List<DexProgramClass> classes() {
        ReorderBox<DexProgramClass> box = new ReorderBox<DexProgramClass>(this.programClasses());
        assert (box.reorderClasses());
        return box.getClasses();
    }

    public Iterable<DexProgramClass> classesWithDeterministicOrder() {
        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(this.programClasses());
        classes.sort((a, b) -> a.type.slowCompareTo(b.type));
        return classes;
    }

    public abstract DexClass definitionFor(DexType var1);

    public abstract DexProgramClass programDefinitionFor(DexType var1);

    public abstract String toString();

    public ClassNameMapper getProguardMap() {
        return this.proguardMap;
    }

    public static LazyLoadedDexApplication.Builder builder(DexItemFactory factory, Timing timing) {
        return DexApplication.builder(factory, timing, ProgramClassCollection::resolveClassConflictImpl);
    }

    public static LazyLoadedDexApplication.Builder builder(DexItemFactory factory, Timing timing, ApplicationReader.ProgramClassConflictResolver resolver) {
        return new LazyLoadedDexApplication.Builder(resolver, factory, timing);
    }

    public DirectMappedDexApplication asDirect() {
        throw new Unreachable("Cannot use a LazyDexApplication where a DirectDexApplication is expected.");
    }

    public abstract DirectMappedDexApplication toDirect();

    public static abstract class Builder<T extends Builder<T>> {
        final List<DexProgramClass> programClasses = new ArrayList<DexProgramClass>();
        final List<DataResourceProvider> dataResourceProviders = new ArrayList<DataResourceProvider>();
        public final DexItemFactory dexItemFactory;
        ClassNameMapper proguardMap;
        final Timing timing;
        DexString highestSortingString;
        String deadCode;
        final Set<DexType> mainDexList = Sets.newIdentityHashSet();
        private final Collection<DexProgramClass> synthesizedClasses;

        public Builder(DexItemFactory dexItemFactory, Timing timing) {
            this.dexItemFactory = dexItemFactory;
            this.timing = timing;
            this.deadCode = null;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        abstract T self();

        public Builder(DexApplication application) {
            this.programClasses.addAll(application.programClasses());
            this.dataResourceProviders.addAll(application.dataResourceProviders);
            this.proguardMap = application.getProguardMap();
            this.timing = application.timing;
            this.highestSortingString = application.highestSortingString;
            this.dexItemFactory = application.dexItemFactory;
            this.mainDexList.addAll(application.mainDexList);
            this.deadCode = application.deadCode;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        public synchronized T setProguardMap(ClassNameMapper proguardMap) {
            assert (this.proguardMap == null);
            this.proguardMap = proguardMap;
            return this.self();
        }

        public synchronized T replaceProgramClasses(List<DexProgramClass> newProgramClasses) {
            assert (newProgramClasses != null);
            this.programClasses.clear();
            this.programClasses.addAll(newProgramClasses);
            return this.self();
        }

        public synchronized T addDataResourceProvider(DataResourceProvider provider) {
            this.dataResourceProviders.add(provider);
            return this.self();
        }

        public T appendDeadCode(String deadCodeAtAnotherRound) {
            if (deadCodeAtAnotherRound == null) {
                return this.self();
            }
            if (this.deadCode == null) {
                this.deadCode = deadCodeAtAnotherRound;
                return this.self();
            }
            this.deadCode = this.deadCode + deadCodeAtAnotherRound;
            return this.self();
        }

        public synchronized T setHighestSortingString(DexString value) {
            this.highestSortingString = value;
            return this.self();
        }

        public synchronized T addProgramClass(DexProgramClass clazz) {
            this.programClasses.add(clazz);
            return this.self();
        }

        public synchronized T addSynthesizedClass(DexProgramClass synthesizedClass, boolean addToMainDexList) {
            assert (synthesizedClass.isProgramClass()) : "All synthesized classes must be program classes";
            this.addProgramClass(synthesizedClass);
            this.synthesizedClasses.add(synthesizedClass);
            if (addToMainDexList && !this.mainDexList.isEmpty()) {
                this.mainDexList.add(synthesizedClass.type);
            }
            return this.self();
        }

        public Collection<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public Collection<DexProgramClass> getSynthesizedClasses() {
            return this.synthesizedClasses;
        }

        public Set<DexType> getMainDexList() {
            return this.mainDexList;
        }

        public Builder<T> addToMainDexList(Collection<DexType> mainDexList) {
            this.mainDexList.addAll(mainDexList);
            return this;
        }

        public abstract DexApplication build();
    }

    private static class ReorderBox<T> {
        private List<T> classes;

        ReorderBox(List<T> classes) {
            this.classes = classes;
        }

        boolean reorderClasses() {
            ArrayList<T> shuffled = new ArrayList<T>(this.classes);
            Collections.shuffle(shuffled);
            this.classes = ImmutableList.copyOf(shuffled);
            return true;
        }

        List<T> getClasses() {
            return this.classes;
        }
    }
}

