/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public abstract class DexByteCodeWriter {
    final DexApplication application;
    final InternalOptions options;

    DexByteCodeWriter(DexApplication application, InternalOptions options) {
        this.application = application;
        this.options = options;
    }

    private void ensureParentExists(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    private OutputStreamProvider oneFilePerClass(Path path) {
        return clazz -> {
            String className = DescriptorUtils.descriptorToJavaType(clazz.type.toDescriptorString(), this.application.getProguardMap());
            Path classOutput = path.resolve(className.replace('.', File.separatorChar) + this.getFileEnding());
            this.ensureParentExists(classOutput);
            return new PrintStream(Files.newOutputStream(classOutput, new OpenOption[0]));
        };
    }

    public void write(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.write(this.oneFilePerClass(path), PrintStream::close);
        } else {
            this.ensureParentExists(path);
            try (PrintStream ps = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));){
                this.write(ps);
            }
        }
    }

    public void write(PrintStream output) throws IOException {
        this.write(x -> output, x -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(OutputStreamProvider outputStreamProvider, Consumer<PrintStream> closer) throws IOException {
        Iterable<DexProgramClass> classes = this.application.classesWithDeterministicOrder();
        for (DexProgramClass clazz : classes) {
            if (!this.anyMethodMatches(clazz)) continue;
            PrintStream ps = outputStreamProvider.get(clazz);
            try {
                this.writeClass(clazz, ps);
            }
            finally {
                closer.accept(ps);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anyMethodMatches(DexClass clazz) {
        if (!this.options.hasMethodsFilter()) return true;
        if (clazz.virtualMethods().stream().anyMatch(this.options::methodMatchesFilter)) return true;
        if (!clazz.directMethods().stream().anyMatch(this.options::methodMatchesFilter)) return false;
        return true;
    }

    private void writeClass(DexProgramClass clazz, PrintStream ps) {
        this.writeClassHeader(clazz, ps);
        this.writeFieldsHeader(clazz, ps);
        clazz.forEachField(field -> this.writeField((DexEncodedField)field, ps));
        this.writeFieldsFooter(clazz, ps);
        this.writeMethodsHeader(clazz, ps);
        clazz.forEachMethod(method -> this.writeMethod((DexEncodedMethod)method, ps));
        this.writeMethodsFooter(clazz, ps);
        this.writeClassFooter(clazz, ps);
    }

    abstract String getFileEnding();

    abstract void writeClassHeader(DexProgramClass var1, PrintStream var2);

    void writeFieldsHeader(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeField(DexEncodedField var1, PrintStream var2);

    void writeFieldsFooter(DexProgramClass clazz, PrintStream ps) {
    }

    void writeMethodsHeader(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeMethod(DexEncodedMethod var1, PrintStream var2);

    void writeMethodsFooter(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeClassFooter(DexProgramClass var1, PrintStream var2);

    private static interface OutputStreamProvider {
        public PrintStream get(DexClass var1) throws IOException;
    }
}

