/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.OptionalBool;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.code.Const;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeStatic;
import com.android.tools.r8.code.NewInstance;
import com.android.tools.r8.code.Throw;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.JumboStringRewriter;
import com.android.tools.r8.dex.MethodToCodeObjectMapping;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OptimizationInfo;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.graph.UpdatableOptimizationInfo;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.desugar.NestBasedAccessDesugaring;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.ir.synthetic.FieldAccessorSourceCode;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

public class DexEncodedMethod
extends KeyedDexItem<DexMethod>
implements AppInfo.ResolutionResult {
    public static final String CONFIGURATION_DEBUGGING_PREFIX = "Shaking error: Missing method in ";
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, null, null, null, null);
    public final DexMethod method;
    public final MethodAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    public ParameterAnnotationsList parameterAnnotationsList;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private OptimizationInfo optimizationInfo = DefaultOptimizationInfoImpl.DEFAULT_INSTANCE;
    private int classFileVersion = -1;
    private DexEncodedMethod defaultInterfaceMethodImplementation = null;
    private OptionalBool isLibraryMethodOverride = OptionalBool.unknown();
    private boolean obsolete = false;

    private void checkIfObsolete() {
        assert (!this.obsolete);
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete() {
        this.obsolete = true;
    }

    public DexEncodedMethod getDefaultInterfaceMethodImplementation() {
        return this.defaultInterfaceMethodImplementation;
    }

    public void setDefaultInterfaceMethodImplementation(DexEncodedMethod implementation) {
        assert (this.defaultInterfaceMethodImplementation == null);
        assert (implementation != null);
        assert (this.code != null);
        assert (this.code == implementation.getCode());
        this.accessFlags.setAbstract();
        this.removeCode();
        this.defaultInterfaceMethodImplementation = implementation;
    }

    public void unsetObsolete() {
        this.obsolete = false;
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.parameterAnnotationsList = parameterAnnotationsList;
        this.code = code;
        assert (code == null || !this.shouldNotHaveCode());
    }

    public DexEncodedMethod(DexMethod method, MethodAccessFlags flags, DexAnnotationSet annotationSet, ParameterAnnotationsList annotationsList, Code code, int classFileVersion) {
        this(method, flags, annotationSet, annotationsList, code);
        this.classFileVersion = classFileVersion;
    }

    public OptionalBool isLibraryMethodOverride() {
        return this.isLibraryMethodOverride;
    }

    public void setLibraryMethodOverride() {
        assert (this.isLibraryMethodOverride.isUnknown() || this.isLibraryMethodOverride.isTrue()) : "Method `" + this.method.toSourceString() + "` went from not overriding a library method to overriding a library method";
        this.isLibraryMethodOverride = OptionalBool.of(true);
    }

    public boolean isProgramMethod(DexDefinitionSupplier definitions) {
        if (this.method.holder.isClassType()) {
            DexClass clazz = definitions.definitionFor(this.method.holder);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    public boolean isProcessed() {
        this.checkIfObsolete();
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() || this.isClassInitializer();
    }

    public boolean isInstanceInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean isDefaultInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() && this.method.proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isVirtualMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isStatic() && !this.accessFlags.isPrivate() && !this.accessFlags.isConstructor();
    }

    public boolean isNonAbstractVirtualMethod() {
        this.checkIfObsolete();
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isNonAbstractNonNativeMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isAbstract() && !this.accessFlags.isNative();
    }

    public boolean isPublicized() {
        this.checkIfObsolete();
        return this.accessFlags.isPromotedToPublic();
    }

    public boolean isPublicMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPublic();
    }

    public boolean isPrivateMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        this.checkIfObsolete();
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    @Override
    public boolean isStatic() {
        this.checkIfObsolete();
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        this.checkIfObsolete();
        return this.isStatic();
    }

    public boolean isSyntheticMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isSynthetic();
    }

    public boolean isInliningCandidate(DexEncodedMethod container, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        this.checkIfObsolete();
        return this.isInliningCandidate(container.method.holder, inliningReason, appInfo);
    }

    public boolean isInliningCandidate(DexType containerType, Inliner.Reason inliningReason, AppInfoWithSubtyping appInfo) {
        this.checkIfObsolete();
        if (this.isClassInitializer()) {
            return false;
        }
        if (inliningReason == Inliner.Reason.FORCE) {
            if (!this.isInliningCandidate(containerType, Inliner.Reason.SIMPLE, appInfo)) {
                throw new InternalCompilerError("FORCE inlining on non-inlinable: " + this.toSourceString());
            }
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                return appInfo.isSubtype(containerType, this.method.holder);
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                return containerType.isSamePackage(this.method.holder);
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                return containerType == this.method.holder;
            }
        }
        return false;
    }

    public boolean markProcessed(Inliner.ConstraintWithTarget state) {
        this.checkIfObsolete();
        CompilationState prevCompilationState = this.compilationState;
        switch (state.constraint) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.checkIfObsolete();
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public IRCode buildIR(AppView<?> appView, Origin origin) {
        this.checkIfObsolete();
        return this.code == null ? null : this.code.buildIR(this, appView, origin);
    }

    public IRCode buildInliningIR(DexEncodedMethod context, AppView<?> appView, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        this.checkIfObsolete();
        return this.code.buildInliningIR(context, this, appView, valueNumberGenerator, callerPosition, origin);
    }

    public void setCode(Code code) {
        this.checkIfObsolete();
        this.code = code;
    }

    public void setCode(IRCode ir, RegisterAllocator registerAllocator, InternalOptions options) {
        this.checkIfObsolete();
        DexBuilder builder = new DexBuilder(ir, registerAllocator);
        this.setCode(builder.build());
    }

    public String toString() {
        this.checkIfObsolete();
        return "Encoded method " + this.method;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.checkIfObsolete();
        this.method.collectIndexedItems(indexedItems);
        if (this.code != null) {
            this.code.collectIndexedItems(indexedItems, this.method);
        }
        this.annotations.collectIndexedItems(indexedItems);
        this.parameterAnnotationsList.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.visit(this);
    }

    public void collectMixedSectionItemsWithCodeMapping(MixedSectionCollection mixedItems, MethodToCodeObjectMapping mapping) {
        DexCode code = mapping.getCode(this);
        if (code != null) {
            code.collectMixedSectionItems(mixedItems);
        }
        this.annotations.collectMixedSectionItems(mixedItems);
        this.parameterAnnotationsList.collectMixedSectionItems(mixedItems);
    }

    public boolean shouldNotHaveCode() {
        return this.accessFlags.isAbstract() || this.accessFlags.isNative();
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public Code getCode() {
        this.checkIfObsolete();
        return this.code;
    }

    public void removeCode() {
        this.checkIfObsolete();
        this.code = null;
    }

    public int getClassFileVersion() {
        this.checkIfObsolete();
        assert (this.classFileVersion >= 0);
        return this.classFileVersion;
    }

    public boolean hasClassFileVersion() {
        this.checkIfObsolete();
        return this.classFileVersion >= 0;
    }

    public void upgradeClassFileVersion(int version) {
        this.checkIfObsolete();
        assert (version >= 0);
        assert (!this.hasClassFileVersion() || version >= this.getClassFileVersion());
        this.classFileVersion = version;
    }

    public String qualifiedName() {
        this.checkIfObsolete();
        return this.method.qualifiedName();
    }

    public String descriptor() {
        this.checkIfObsolete();
        return this.descriptor(NamingLens.getIdentityLens());
    }

    public String descriptor(NamingLens namingLens) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : this.method.proto.parameters.values) {
            builder.append(namingLens.lookupDescriptor(type).toString());
        }
        builder.append(")");
        builder.append(namingLens.lookupDescriptor(this.method.proto.returnType).toString());
        return builder.toString();
    }

    public String toSmaliString(ClassNameMapper naming) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(this.method.name.toSmaliString());
        builder.append(this.method.proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        this.checkIfObsolete();
        return this.method.toSourceString();
    }

    public DexEncodedMethod toAbstractMethod() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isFinal());
        this.accessFlags.setAbstract();
        this.code = null;
        return this;
    }

    public IRCode buildEmptyThrowingIRCode(AppView<?> appView, Origin origin) {
        DexCode emptyThrowingDexCode = this.buildEmptyThrowingDexCode();
        return emptyThrowingDexCode.buildIR(this, appView, origin);
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : this.method.proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null);
    }

    public DexCode buildEmptyThrowingDexCode() {
        Instruction[] insn = new Instruction[]{new Const(0, 0), new Throw(0)};
        return this.generateCodeFromTemplate(1, 0, insn);
    }

    public DexEncodedMethod toEmptyThrowingMethodDex() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingDexCode());
        return builder.build();
    }

    public CfCode buildEmptyThrowingCfCode() {
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        return new CfCode(1, this.method.proto.parameters.size() + 1, Arrays.asList(insn), Collections.emptyList(), Collections.emptyList());
    }

    public DexEncodedMethod toEmptyThrowingMethodCf() {
        this.checkIfObsolete();
        assert (!this.shouldNotHaveCode());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(this.buildEmptyThrowingCfCode());
        return builder.build();
    }

    public DexEncodedMethod toMethodThatLogsError(AppView<?> appView) {
        if (appView.options().isGeneratingDex()) {
            return this.toMethodThatLogsErrorDexCode(appView.dexItemFactory());
        }
        return this.toMethodThatLogsErrorCfCode(appView.dexItemFactory());
    }

    private DexEncodedMethod toMethodThatLogsErrorDexCode(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType[] args = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.createType("Landroid/util/Log;"), proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        DexCode code = this.generateCodeFromTemplate(2, 2, new ConstString(0, tag), new ConstString(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        this.setObsolete();
        return builder.build();
    }

    private DexEncodedMethod toMethodThatLogsErrorCfCode(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(this.method);
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + this.method.holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType logger = itemFactory.createType("Ljava/util/logging/Logger;");
        DexMethod getLogger = itemFactory.createMethod(logger, itemFactory.createProto(logger, itemFactory.stringType), itemFactory.createString("getLogger"));
        DexMethod severe = itemFactory.createMethod(logger, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.createString("severe"));
        DexType exceptionType = itemFactory.createType("Ljava/lang/RuntimeException;");
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        int locals = this.method.proto.parameters.size() + 1;
        if (!this.isStaticMember()) {
            ++locals;
        }
        ImmutableList.Builder instructionBuilder = ImmutableList.builder();
        ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)instructionBuilder.add(new CfConstString(tag))).add(new CfInvoke(184, getLogger, false))).add(new CfStore(ValueType.OBJECT, locals - 1))).add(new CfLoad(ValueType.OBJECT, locals - 1))).add(new CfConstString(message))).add(new CfInvoke(182, severe, false))).add(new CfNew(exceptionType))).add(new CfStackInstruction(CfStackInstruction.Opcode.Dup))).add(new CfConstString(message))).add(new CfInvoke(183, exceptionInitMethod, false))).add(new CfThrow());
        CfCode code = new CfCode(3, locals, (List<CfInstruction>)((Object)instructionBuilder.build()), Collections.emptyList(), Collections.emptyList());
        Builder builder = DexEncodedMethod.builder(this);
        builder.setCode(code);
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        this.checkIfObsolete();
        return this.toTypeSubstitutedMethod(method, null);
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method, Consumer<Builder> consumer) {
        this.checkIfObsolete();
        if (this.method == method) {
            return this;
        }
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(method);
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    public DexEncodedMethod toRenamedMethod(DexString name, DexItemFactory factory) {
        this.checkIfObsolete();
        if (this.method.name == name) {
            return this;
        }
        DexMethod newMethod = factory.createMethod(this.method.holder, this.method.proto, name);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toInitializerForwardingBridge(DexClass holder, DexDefinitionSupplier definitions, DexProgramClass nestConstructor) {
        assert (this.accessFlags.isPrivate()) : "Expected to create bridge for private constructor as part of nest-based access desugaring";
        DexProto newProto = definitions.dexItemFactory().appendTypeToProto(this.method.proto, nestConstructor.type);
        DexMethod newMethod = definitions.dexItemFactory().createMethod(this.method.holder, newProto, this.method.name);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        builder.setCode(new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(holder.type, newMethod, newMethod, holder.type, this.method, Invoke.Type.DIRECT, callerPosition, holder.isInterface(), false, true), registry -> registry.registerInvokeDirect(this.method)));
        assert (!builder.accessFlags.isStatic());
        builder.accessFlags.unsetPrivate();
        builder.accessFlags.setSynthetic();
        builder.accessFlags.setConstructor();
        return builder.build();
    }

    public static DexEncodedMethod createFieldAccessorBridge(NestBasedAccessDesugaring.DexFieldWithAccess fieldWithAccess, DexClass holder, DexDefinitionSupplier definitions, DexString newName) {
        assert (holder.type == fieldWithAccess.getHolder());
        DexItemFactory dexItemFactory = definitions.dexItemFactory();
        DexType[] parameters = new DexType[fieldWithAccess.bridgeParameterCount()];
        if (fieldWithAccess.isPut()) {
            parameters[parameters.length - 1] = fieldWithAccess.getType();
        }
        if (fieldWithAccess.isInstance()) {
            parameters[0] = holder.type;
        }
        DexType returnType = fieldWithAccess.isGet() ? fieldWithAccess.getType() : dexItemFactory.voidType;
        DexProto proto = dexItemFactory.createProto(returnType, parameters);
        DexMethod newMethod = dexItemFactory.createMethod(holder.type, proto, newName);
        MethodAccessFlags accessFlags = MethodAccessFlags.fromSharedAccessFlags(0x1008 | (holder.isInterface() ? 1 : 0), false);
        SynthesizedCode code = new SynthesizedCode(callerPosition -> new FieldAccessorSourceCode(null, newMethod, callerPosition, newMethod, fieldWithAccess), registry -> {
            if (fieldWithAccess.isInstanceGet()) {
                registry.registerInstanceFieldRead(fieldWithAccess.getField());
            } else if (fieldWithAccess.isStaticGet()) {
                registry.registerStaticFieldRead(fieldWithAccess.getField());
            } else if (fieldWithAccess.isInstancePut()) {
                registry.registerInstanceFieldWrite(fieldWithAccess.getField());
            } else {
                assert (fieldWithAccess.isStaticPut());
                registry.registerStaticFieldWrite(fieldWithAccess.getField());
            }
        });
        return new DexEncodedMethod(newMethod, accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code);
    }

    public DexEncodedMethod toStaticForwardingBridge(DexClass holder, DexDefinitionSupplier definitions, DexString newName) {
        assert (this.accessFlags.isPrivate()) : "Expected to create bridge for private method as part of nest-based access desugaring";
        DexProto proto = this.accessFlags.isStatic() ? this.method.proto : definitions.dexItemFactory().prependTypeToProto(holder.type, this.method.proto);
        DexMethod newMethod = definitions.dexItemFactory().createMethod(holder.type, proto, newName);
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        builder.setCode(new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(null, newMethod, newMethod, this.accessFlags.isStatic() ? null : this.method.holder, this.method, this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.DIRECT, callerPosition, holder.isInterface()), registry -> {
            if (this.accessFlags.isStatic()) {
                registry.registerInvokeStatic(this.method);
            } else {
                registry.registerInvokeDirect(this.method);
            }
        }));
        builder.accessFlags.setSynthetic();
        builder.accessFlags.setStatic();
        builder.accessFlags.unsetPrivate();
        if (holder.isInterface()) {
            builder.accessFlags.setPublic();
        }
        return builder.build();
    }

    public DexEncodedMethod toForwardingMethod(DexClass holder, DexDefinitionSupplier definitions) {
        this.checkIfObsolete();
        this.accessFlags.demoteFromFinal();
        DexMethod newMethod = definitions.dexItemFactory().createMethod(holder.type, this.method.proto, this.method.name);
        Invoke.Type type = this.accessFlags.isStatic() ? Invoke.Type.STATIC : Invoke.Type.SUPER;
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(newMethod);
        if (this.accessFlags.isAbstract()) {
            builder.accessFlags.setAbstract();
        } else {
            DexClass target = definitions.definitionFor(this.method.holder);
            builder.setCode(new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(this.accessFlags.isStatic() ? null : holder.type, newMethod, newMethod, this.accessFlags.isStatic() ? null : this.method.holder, this.method, type, callerPosition, target.isInterface()), registry -> {
                if (this.accessFlags.isStatic()) {
                    registry.registerInvokeStatic(this.method);
                } else {
                    registry.registerInvokeSuper(this.method);
                }
            }));
            builder.accessFlags.setBridge();
        }
        builder.accessFlags.setSynthetic();
        return builder.build();
    }

    public DexEncodedMethod toStaticMethodWithoutThis() {
        this.checkIfObsolete();
        assert (!this.accessFlags.isStatic());
        Builder builder = DexEncodedMethod.builder(this).promoteToStatic().unsetOptimizationInfo().withoutThisParameter();
        DexEncodedMethod method = builder.build();
        method.copyMetadata(this);
        this.setObsolete();
        return method;
    }

    public DexCode rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, DexItemFactory factory, boolean force) {
        this.checkIfObsolete();
        assert (this.code == null || this.code.isDexCode());
        if (this.code == null) {
            return null;
        }
        DexCode code = this.code.asDexCode();
        DexString firstJumboString = null;
        if (force) {
            firstJumboString = mapping.getFirstString();
        } else {
            assert (code.highestSortingString != null || Arrays.stream(code.instructions).noneMatch(Instruction::isConstString));
            assert (Arrays.stream(code.instructions).noneMatch(Instruction::isDexItemBasedConstString));
            if (code.highestSortingString != null && mapping.getOffsetFor(code.highestSortingString) > 65535) {
                firstJumboString = mapping.getFirstJumboString();
            }
        }
        if (firstJumboString != null) {
            JumboStringRewriter rewriter = new JumboStringRewriter(this, firstJumboString, factory);
            return rewriter.rewrite();
        }
        return code;
    }

    public String codeToString() {
        this.checkIfObsolete();
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public DexMethod getKey() {
        return this.method;
    }

    @Override
    public DexReference toReference() {
        this.checkIfObsolete();
        return this.method;
    }

    @Override
    public boolean isDexEncodedMethod() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public DexEncodedMethod asDexEncodedMethod() {
        this.checkIfObsolete();
        return this;
    }

    public boolean hasAnnotation() {
        this.checkIfObsolete();
        return !this.annotations.isEmpty() || !this.parameterAnnotationsList.isEmpty();
    }

    public void registerCodeReferences(UseRegistry registry) {
        this.checkIfObsolete();
        if (this.code != null) {
            this.code.registerCodeReferences(this, registry);
        }
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m2) {
        return m1.method.slowCompareTo(m2.method);
    }

    public OptimizationInfo getOptimizationInfo() {
        this.checkIfObsolete();
        return this.optimizationInfo;
    }

    public synchronized UpdatableOptimizationInfo getMutableOptimizationInfo() {
        this.checkIfObsolete();
        if (this.optimizationInfo == DefaultOptimizationInfoImpl.DEFAULT_INSTANCE) {
            this.optimizationInfo = this.optimizationInfo.mutableCopy();
        }
        return (UpdatableOptimizationInfo)this.optimizationInfo;
    }

    public void setOptimizationInfo(UpdatableOptimizationInfo info) {
        this.checkIfObsolete();
        this.optimizationInfo = info;
    }

    public void copyMetadata(DexEncodedMethod from) {
        this.checkIfObsolete();
        if (from.getOptimizationInfo().useIdentifierNameString()) {
            this.getMutableOptimizationInfo().markUseIdentifierNameString();
        }
        if (from.classFileVersion > this.classFileVersion) {
            this.upgradeClassFileVersion(from.getClassFileVersion());
        }
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from);
    }

    @Override
    public DexEncodedMethod asResultOfResolve() {
        this.checkIfObsolete();
        return this;
    }

    @Override
    public DexEncodedMethod asSingleTarget() {
        this.checkIfObsolete();
        return this;
    }

    @Override
    public boolean hasSingleTarget() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public List<DexEncodedMethod> asListOfTargets() {
        this.checkIfObsolete();
        return Collections.singletonList(this);
    }

    @Override
    public void forEachTarget(Consumer<DexEncodedMethod> consumer) {
        this.checkIfObsolete();
        consumer.accept(this);
    }

    public static class Builder {
        private DexMethod method;
        private final MethodAccessFlags accessFlags;
        private final DexAnnotationSet annotations;
        private ParameterAnnotationsList parameterAnnotations;
        private Code code;
        private CompilationState compilationState;
        private OptimizationInfo optimizationInfo;
        private final int classFileVersion;

        private Builder(DexEncodedMethod from) {
            this.method = from.method;
            this.accessFlags = from.accessFlags.copy();
            this.annotations = from.annotations;
            this.code = from.code;
            this.compilationState = from.compilationState;
            this.optimizationInfo = from.optimizationInfo.mutableCopy();
            this.classFileVersion = from.classFileVersion;
            if (from.parameterAnnotationsList.isEmpty() || from.parameterAnnotationsList.size() == this.method.proto.parameters.size()) {
                this.parameterAnnotations = from.parameterAnnotationsList;
            } else {
                assert (false) : "Parameter annotations does not match proto of method `" + this.method.toSourceString() + "` (was: " + this.parameterAnnotations + ")";
                this.parameterAnnotations = ParameterAnnotationsList.empty();
            }
        }

        public void setMethod(DexMethod method) {
            this.method = method;
        }

        public Builder setParameterAnnotations(ParameterAnnotationsList parameterAnnotations) {
            this.parameterAnnotations = parameterAnnotations;
            return this;
        }

        public Builder removeParameterAnnotations(IntPredicate predicate) {
            if (this.parameterAnnotations.isEmpty()) {
                return this;
            }
            ArrayList<DexAnnotationSet> newParameterAnnotations = new ArrayList<DexAnnotationSet>();
            int newNumberOfMissingParameterAnnotations = 0;
            for (int oldIndex = 0; oldIndex < this.parameterAnnotations.size(); ++oldIndex) {
                if (predicate.test(oldIndex)) continue;
                if (this.parameterAnnotations.isMissing(oldIndex)) {
                    ++newNumberOfMissingParameterAnnotations;
                    continue;
                }
                newParameterAnnotations.add(this.parameterAnnotations.get(oldIndex));
            }
            if (newParameterAnnotations.isEmpty()) {
                return this.setParameterAnnotations(ParameterAnnotationsList.empty());
            }
            return this.setParameterAnnotations(new ParameterAnnotationsList(newParameterAnnotations.toArray(DexAnnotationSet.EMPTY_ARRAY), newNumberOfMissingParameterAnnotations));
        }

        public Builder promoteToStatic() {
            this.accessFlags.promoteToStatic();
            return this;
        }

        public Builder unsetOptimizationInfo() {
            this.optimizationInfo = DefaultOptimizationInfoImpl.DEFAULT_INSTANCE;
            return this;
        }

        public Builder withoutThisParameter() {
            assert (this.code != null);
            if (!this.code.isDexCode()) {
                throw new Unreachable("Code " + this.code.getClass().getSimpleName() + " is not supported.");
            }
            this.code = this.code.asDexCode().withoutThisParameter();
            return this;
        }

        public void setCode(Code code) {
            this.code = code;
        }

        public DexEncodedMethod build() {
            assert (this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            assert (this.parameterAnnotations.isEmpty() || this.parameterAnnotations.size() == this.method.proto.parameters.size());
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.annotations, this.parameterAnnotations, this.code, this.classFileVersion);
            result.compilationState = this.compilationState;
            result.optimizationInfo = this.optimizationInfo;
            return result;
        }
    }

    public static class OptimizationInfoImpl
    implements UpdatableOptimizationInfo {
        private Set<DexType> initializedClassesOnNormalExit = DefaultOptimizationInfoImpl.UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT;
        private int returnedArgument = DefaultOptimizationInfoImpl.UNKNOWN_RETURNED_ARGUMENT;
        private boolean mayHaveSideEffects = DefaultOptimizationInfoImpl.UNKNOWN_MAY_HAVE_SIDE_EFFECTS;
        private boolean neverReturnsNull = DefaultOptimizationInfoImpl.UNKNOWN_NEVER_RETURNS_NULL;
        private boolean neverReturnsNormally = DefaultOptimizationInfoImpl.UNKNOWN_NEVER_RETURNS_NORMALLY;
        private boolean returnsConstantNumber = DefaultOptimizationInfoImpl.UNKNOWN_RETURNS_CONSTANT;
        private long returnedConstantNumber = DefaultOptimizationInfoImpl.UNKNOWN_RETURNED_CONSTANT_NUMBER;
        private boolean returnsConstantString = DefaultOptimizationInfoImpl.UNKNOWN_RETURNS_CONSTANT;
        private DexString returnedConstantString = DefaultOptimizationInfoImpl.UNKNOWN_RETURNED_CONSTANT_STRING;
        private TypeLatticeElement returnsObjectOfType = DefaultOptimizationInfoImpl.UNKNOWN_TYPE;
        private OptimizationInfo.InlinePreference inlining = OptimizationInfo.InlinePreference.Default;
        private boolean useIdentifierNameString = DefaultOptimizationInfoImpl.DOES_NOT_USE_IDNETIFIER_NAME_STRING;
        private boolean checksNullReceiverBeforeAnySideEffect = DefaultOptimizationInfoImpl.UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT;
        private boolean triggersClassInitBeforeAnySideEffect = DefaultOptimizationInfoImpl.UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT;
        private ClassInlinerEligibility classInlinerEligibility = DefaultOptimizationInfoImpl.UNKNOWN_CLASS_INLINER_ELIGIBILITY;
        private TrivialInitializer trivialInitializerInfo = DefaultOptimizationInfoImpl.UNKNOWN_TRIVIAL_INITIALIZER;
        private boolean initializerEnablingJavaAssertions = DefaultOptimizationInfoImpl.UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS;
        private ParameterUsagesInfo parametersUsages = DefaultOptimizationInfoImpl.UNKNOWN_PARAMETER_USAGE_INFO;
        private BitSet nonNullParamOrThrow = null;
        private BitSet nonNullParamOnNormalExits = null;
        private boolean reachabilitySensitive = false;

        private OptimizationInfoImpl() {
        }

        private OptimizationInfoImpl(OptimizationInfoImpl template) {
            this.returnedArgument = template.returnedArgument;
            this.neverReturnsNull = template.neverReturnsNull;
            this.neverReturnsNormally = template.neverReturnsNormally;
            this.returnsConstantNumber = template.returnsConstantNumber;
            this.returnedConstantNumber = template.returnedConstantNumber;
            this.returnsConstantString = template.returnsConstantString;
            this.returnedConstantString = template.returnedConstantString;
            this.inlining = template.inlining;
            this.useIdentifierNameString = template.useIdentifierNameString;
            this.checksNullReceiverBeforeAnySideEffect = template.checksNullReceiverBeforeAnySideEffect;
            this.triggersClassInitBeforeAnySideEffect = template.triggersClassInitBeforeAnySideEffect;
            this.classInlinerEligibility = template.classInlinerEligibility;
            this.trivialInitializerInfo = template.trivialInitializerInfo;
            this.initializerEnablingJavaAssertions = template.initializerEnablingJavaAssertions;
            this.parametersUsages = template.parametersUsages;
            this.nonNullParamOrThrow = template.nonNullParamOrThrow;
            this.nonNullParamOnNormalExits = template.nonNullParamOnNormalExits;
            this.reachabilitySensitive = template.reachabilitySensitive;
        }

        @Override
        public TypeLatticeElement getDynamicReturnType() {
            return this.returnsObjectOfType;
        }

        @Override
        public Set<DexType> getInitializedClassesOnNormalExit() {
            return this.initializedClassesOnNormalExit;
        }

        @Override
        public TrivialInitializer getTrivialInitializerInfo() {
            return this.trivialInitializerInfo;
        }

        @Override
        public ParameterUsagesInfo.ParameterUsage getParameterUsages(int parameter) {
            return this.parametersUsages == null ? null : this.parametersUsages.getParameterUsage(parameter);
        }

        @Override
        public BitSet getNonNullParamOrThrow() {
            return this.nonNullParamOrThrow;
        }

        @Override
        public BitSet getNonNullParamOnNormalExits() {
            return this.nonNullParamOnNormalExits;
        }

        @Override
        public boolean isReachabilitySensitive() {
            return this.reachabilitySensitive;
        }

        @Override
        public boolean returnsArgument() {
            return this.returnedArgument != -1;
        }

        @Override
        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return this.returnedArgument;
        }

        @Override
        public boolean neverReturnsNull() {
            return this.neverReturnsNull;
        }

        @Override
        public boolean neverReturnsNormally() {
            return this.neverReturnsNormally;
        }

        @Override
        public boolean returnsConstant() {
            assert (!this.returnsConstantNumber || !this.returnsConstantString);
            return this.returnsConstantNumber || this.returnsConstantString;
        }

        @Override
        public boolean returnsConstantNumber() {
            return this.returnsConstantNumber;
        }

        @Override
        public boolean returnsConstantString() {
            return this.returnsConstantString;
        }

        @Override
        public ClassInlinerEligibility getClassInlinerEligibility() {
            return this.classInlinerEligibility;
        }

        @Override
        public long getReturnedConstantNumber() {
            assert (this.returnsConstant());
            return this.returnedConstantNumber;
        }

        @Override
        public DexString getReturnedConstantString() {
            assert (this.returnsConstant());
            return this.returnedConstantString;
        }

        @Override
        public boolean isInitializerEnablingJavaAssertions() {
            return this.initializerEnablingJavaAssertions;
        }

        @Override
        public boolean useIdentifierNameString() {
            return this.useIdentifierNameString;
        }

        @Override
        public boolean forceInline() {
            return this.inlining == OptimizationInfo.InlinePreference.ForceInline;
        }

        @Override
        public boolean neverInline() {
            return this.inlining == OptimizationInfo.InlinePreference.NeverInline;
        }

        @Override
        public boolean checksNullReceiverBeforeAnySideEffect() {
            return this.checksNullReceiverBeforeAnySideEffect;
        }

        @Override
        public boolean triggersClassInitBeforeAnySideEffect() {
            return this.triggersClassInitBeforeAnySideEffect;
        }

        @Override
        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }

        @Override
        public void setParameterUsages(ParameterUsagesInfo parametersUsages) {
            this.parametersUsages = parametersUsages;
        }

        @Override
        public void setNonNullParamOrThrow(BitSet facts) {
            this.nonNullParamOrThrow = facts;
        }

        @Override
        public void setNonNullParamOnNormalExits(BitSet facts) {
            this.nonNullParamOnNormalExits = facts;
        }

        @Override
        public void setReachabilitySensitive(boolean reachabilitySensitive) {
            this.reachabilitySensitive = reachabilitySensitive;
        }

        @Override
        public void setClassInlinerEligibility(ClassInlinerEligibility eligibility) {
            this.classInlinerEligibility = eligibility;
        }

        @Override
        public void setTrivialInitializer(TrivialInitializer info) {
            this.trivialInitializerInfo = info;
        }

        @Override
        public void setInitializerEnablingJavaAssertions() {
            this.initializerEnablingJavaAssertions = true;
        }

        @Override
        public void markInitializesClassesOnNormalExit(Set<DexType> initializedClassesOnNormalExit) {
            this.initializedClassesOnNormalExit = initializedClassesOnNormalExit;
        }

        @Override
        public void markReturnsArgument(int argument) {
            assert (argument >= 0);
            assert (this.returnedArgument == -1 || this.returnedArgument == argument);
            this.returnedArgument = argument;
        }

        @Override
        public void markMayNotHaveSideEffects() {
            this.mayHaveSideEffects = false;
        }

        @Override
        public void markNeverReturnsNull() {
            this.neverReturnsNull = true;
        }

        @Override
        public void markNeverReturnsNormally() {
            this.neverReturnsNormally = true;
        }

        @Override
        public void markReturnsConstantNumber(long value) {
            assert (!this.returnsConstantString);
            assert (!this.returnsConstantNumber || this.returnedConstantNumber == value);
            this.returnsConstantNumber = true;
            this.returnedConstantNumber = value;
        }

        @Override
        public void markReturnsConstantString(DexString value) {
            assert (!this.returnsConstantNumber);
            assert (!this.returnsConstantString || this.returnedConstantString == value);
            this.returnsConstantString = true;
            this.returnedConstantString = value;
        }

        @Override
        public void markReturnsObjectOfType(TypeLatticeElement type) {
            assert (type != null);
            assert (this.returnsObjectOfType == DefaultOptimizationInfoImpl.UNKNOWN_TYPE || this.returnsObjectOfType == type);
            this.returnsObjectOfType = type;
        }

        @Override
        public void markForceInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.ForceInline);
            this.inlining = OptimizationInfo.InlinePreference.ForceInline;
        }

        @Override
        public void unsetForceInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.ForceInline);
            this.inlining = OptimizationInfo.InlinePreference.Default;
        }

        @Override
        public void markNeverInline() {
            assert (this.inlining == OptimizationInfo.InlinePreference.Default || this.inlining == OptimizationInfo.InlinePreference.NeverInline);
            this.inlining = OptimizationInfo.InlinePreference.NeverInline;
        }

        @Override
        public void markUseIdentifierNameString() {
            this.useIdentifierNameString = true;
        }

        @Override
        public void markCheckNullReceiverBeforeAnySideEffect(boolean mark) {
            this.checksNullReceiverBeforeAnySideEffect = mark;
        }

        @Override
        public void markTriggerClassInitBeforeAnySideEffect(boolean mark) {
            this.triggersClassInitBeforeAnySideEffect = mark;
        }

        @Override
        public UpdatableOptimizationInfo mutableCopy() {
            assert (this != DefaultOptimizationInfoImpl.DEFAULT_INSTANCE);
            return new OptimizationInfoImpl(this);
        }
    }

    public static class DefaultOptimizationInfoImpl
    implements OptimizationInfo {
        public static final OptimizationInfo DEFAULT_INSTANCE = new DefaultOptimizationInfoImpl();
        public static Set<DexType> UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT = ImmutableSet.of();
        public static int UNKNOWN_RETURNED_ARGUMENT = -1;
        public static boolean UNKNOWN_NEVER_RETURNS_NULL = false;
        public static boolean UNKNOWN_NEVER_RETURNS_NORMALLY = false;
        public static boolean UNKNOWN_RETURNS_CONSTANT = false;
        public static long UNKNOWN_RETURNED_CONSTANT_NUMBER = 0L;
        public static DexString UNKNOWN_RETURNED_CONSTANT_STRING = null;
        public static TypeLatticeElement UNKNOWN_TYPE = null;
        public static boolean DOES_NOT_USE_IDNETIFIER_NAME_STRING = false;
        public static boolean UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT = false;
        public static boolean UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT = false;
        public static ClassInlinerEligibility UNKNOWN_CLASS_INLINER_ELIGIBILITY = null;
        public static TrivialInitializer UNKNOWN_TRIVIAL_INITIALIZER = null;
        public static boolean UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS = false;
        public static ParameterUsagesInfo UNKNOWN_PARAMETER_USAGE_INFO = null;
        public static boolean UNKNOWN_MAY_HAVE_SIDE_EFFECTS = true;
        public static BitSet NO_NULL_PARAMETER_OR_THROW_FACTS = null;
        public static BitSet NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS = null;

        private DefaultOptimizationInfoImpl() {
        }

        @Override
        public TypeLatticeElement getDynamicReturnType() {
            return UNKNOWN_TYPE;
        }

        @Override
        public Set<DexType> getInitializedClassesOnNormalExit() {
            return UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT;
        }

        @Override
        public TrivialInitializer getTrivialInitializerInfo() {
            return UNKNOWN_TRIVIAL_INITIALIZER;
        }

        @Override
        public ParameterUsagesInfo.ParameterUsage getParameterUsages(int parameter) {
            assert (UNKNOWN_PARAMETER_USAGE_INFO == null);
            return null;
        }

        @Override
        public BitSet getNonNullParamOrThrow() {
            return NO_NULL_PARAMETER_OR_THROW_FACTS;
        }

        @Override
        public BitSet getNonNullParamOnNormalExits() {
            return NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS;
        }

        @Override
        public boolean isReachabilitySensitive() {
            return false;
        }

        @Override
        public boolean returnsArgument() {
            return false;
        }

        @Override
        public int getReturnedArgument() {
            assert (this.returnsArgument());
            return UNKNOWN_RETURNED_ARGUMENT;
        }

        @Override
        public boolean neverReturnsNull() {
            return UNKNOWN_NEVER_RETURNS_NULL;
        }

        @Override
        public boolean neverReturnsNormally() {
            return UNKNOWN_NEVER_RETURNS_NORMALLY;
        }

        @Override
        public boolean returnsConstant() {
            return UNKNOWN_RETURNS_CONSTANT;
        }

        @Override
        public boolean returnsConstantNumber() {
            return UNKNOWN_RETURNS_CONSTANT;
        }

        @Override
        public boolean returnsConstantString() {
            return UNKNOWN_RETURNS_CONSTANT;
        }

        @Override
        public ClassInlinerEligibility getClassInlinerEligibility() {
            return UNKNOWN_CLASS_INLINER_ELIGIBILITY;
        }

        @Override
        public long getReturnedConstantNumber() {
            assert (this.returnsConstantNumber());
            return UNKNOWN_RETURNED_CONSTANT_NUMBER;
        }

        @Override
        public DexString getReturnedConstantString() {
            assert (this.returnsConstantString());
            return UNKNOWN_RETURNED_CONSTANT_STRING;
        }

        @Override
        public boolean isInitializerEnablingJavaAssertions() {
            return UNKNOWN_INITIALIZER_ENABLING_JAVA_ASSERTIONS;
        }

        @Override
        public boolean useIdentifierNameString() {
            return DOES_NOT_USE_IDNETIFIER_NAME_STRING;
        }

        @Override
        public boolean forceInline() {
            return false;
        }

        @Override
        public boolean neverInline() {
            return false;
        }

        @Override
        public boolean checksNullReceiverBeforeAnySideEffect() {
            return UNKNOWN_CHECKS_NULL_RECEIVER_BEFORE_ANY_SIDE_EFFECT;
        }

        @Override
        public boolean triggersClassInitBeforeAnySideEffect() {
            return UNKNOWN_TRIGGERS_CLASS_INIT_BEFORE_ANY_SIDE_EFFECT;
        }

        @Override
        public boolean mayHaveSideEffects() {
            return UNKNOWN_MAY_HAVE_SIDE_EFFECTS;
        }

        @Override
        public UpdatableOptimizationInfo mutableCopy() {
            return new OptimizationInfoImpl();
        }
    }

    public static class TrivialInitializer {
        private TrivialInitializer() {
        }

        public static final class TrivialClassInitializer
        extends TrivialInitializer {
            public final DexField field;

            public TrivialClassInitializer(DexField field) {
                this.field = field;
            }
        }

        public static final class TrivialInstanceInitializer
        extends TrivialInitializer {
            public static final TrivialInstanceInitializer INSTANCE = new TrivialInstanceInitializer();
        }
    }

    public static class ClassInlinerEligibility {
        public final boolean returnsReceiver;

        public ClassInlinerEligibility(boolean returnsReceiver) {
            this.returnsReceiver = returnsReceiver;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

