/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Arrays;
import java.util.function.Predicate;

public class DexType
extends DexReference
implements PresortedComparable<DexType> {
    public static final DexType[] EMPTY_ARRAY = new DexType[0];
    public final DexString descriptor;
    private String toStringCache = null;

    DexType(DexString descriptor) {
        assert (!descriptor.toString().contains("."));
        this.descriptor = descriptor;
    }

    @Override
    public int computeHashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexType) {
            return this.descriptor.equals(((DexType)other).descriptor);
        }
        return false;
    }

    public boolean classInitializationMayHaveSideEffects(DexDefinitionSupplier definitions) {
        return this.classInitializationMayHaveSideEffects(definitions, Predicates.alwaysFalse());
    }

    public boolean classInitializationMayHaveSideEffects(DexDefinitionSupplier definitions, Predicate<DexType> ignore) {
        DexClass clazz = definitions.definitionFor(this);
        return clazz == null || clazz.classInitializationMayHaveSideEffects(definitions, ignore);
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppInfo appInfo) {
        return this.initializationOfParentTypesMayHaveSideEffects(appInfo, Predicates.alwaysFalse());
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppInfo appInfo, Predicate<DexType> ignore) {
        DexClass clazz = appInfo.definitionFor(this);
        return clazz == null || clazz.initializationOfParentTypesMayHaveSideEffects(appInfo, ignore);
    }

    public boolean isAlwaysNull(AppView<AppInfoWithLiveness> appView) {
        if (this.isClassType()) {
            DexClass clazz = appView.definitionFor(this);
            return clazz != null && clazz.isProgramClass() && !appView.appInfo().isInstantiatedDirectlyOrIndirectly(this);
        }
        return false;
    }

    public boolean isSamePackage(DexType other) {
        return this.getPackageDescriptor().equals(other.getPackageDescriptor());
    }

    public String toDescriptorString() {
        return this.descriptor.toString();
    }

    public String toBinaryName() {
        String descriptor = this.toDescriptorString();
        assert (descriptor.length() > 1 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';');
        return descriptor.substring(1, descriptor.length() - 1);
    }

    @Override
    public String toSourceString() {
        if (this.toStringCache == null) {
            this.toStringCache = DexItemFactory.isInternalSentinel(this) ? this.descriptor.toString() : DescriptorUtils.descriptorToJavaType(this.toDescriptorString());
        }
        return this.toStringCache;
    }

    public char toShorty() {
        char c = (char)this.descriptor.content[0];
        return c == '[' ? (char)'L' : (char)c;
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toString() {
        return this.toSourceString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection, DexMethod method, int instructionOffset) {
        if (collection.addType(this)) {
            collection.getRenamedDescriptor(this).collectIndexedItems(collection, method, instructionOffset);
        }
    }

    @Override
    public void flushCachedValues() {
        super.flushCachedValues();
        this.toStringCache = null;
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexType() {
        return true;
    }

    @Override
    public DexType asDexType() {
        return this;
    }

    @Override
    public int compareTo(DexType other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexType other) {
        return this.descriptor.slowCompareTo(other.descriptor);
    }

    @Override
    public int slowCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.slowCompareTo(otherDescriptor);
    }

    @Override
    public int layeredCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.compareTo(otherDescriptor);
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType((char)this.descriptor.content[0]);
    }

    private boolean isPrimitiveType(char c) {
        return c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'F' || c == 'J' || c == 'D';
    }

    public boolean isVoidType() {
        return (char)this.descriptor.content[0] == 'V';
    }

    public boolean isBooleanType() {
        return this.descriptor.content[0] == 90;
    }

    public boolean isByteType() {
        return this.descriptor.content[0] == 66;
    }

    public boolean isCharType() {
        return this.descriptor.content[0] == 67;
    }

    public boolean isShortType() {
        return this.descriptor.content[0] == 83;
    }

    public boolean isIntType() {
        return this.descriptor.content[0] == 73;
    }

    public boolean isFloatType() {
        return this.descriptor.content[0] == 70;
    }

    public boolean isLongType() {
        return this.descriptor.content[0] == 74;
    }

    public boolean isDoubleType() {
        return this.descriptor.content[0] == 68;
    }

    public boolean isArrayType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == '[';
    }

    public boolean isClassType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == 'L';
    }

    public boolean isReferenceType() {
        boolean isReferenceType;
        boolean bl = isReferenceType = this.isArrayType() || this.isClassType();
        assert (isReferenceType != this.isPrimitiveType() || this.isVoidType());
        return isReferenceType;
    }

    public boolean isPrimitiveArrayType() {
        if (!this.isArrayType()) {
            return false;
        }
        return this.isPrimitiveType((char)this.descriptor.content[1]);
    }

    public boolean isD8R8SynthesizedClassType() {
        String name = this.toSourceString();
        return name.contains("$-CC") || name.contains("$-DC") || name.contains("-$$Lambda$") || name.contains("-$$LambdaGroup$") || name.contains("com.android.tools.r8.GeneratedOutlineSupport") || name.contains("$r8$twr$utility") || name.contains("-$$Nest$Constructor") || name.contains("$r8$java8methods$utility");
    }

    public boolean isProgramType(DexDefinitionSupplier definitions) {
        DexClass clazz = definitions.definitionFor(this);
        return clazz != null && clazz.isProgramClass();
    }

    public int elementSizeForPrimitiveArrayType() {
        assert (this.isPrimitiveArrayType());
        switch (this.descriptor.content[1]) {
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new Unreachable("Not array of primitives '" + this.descriptor + "'");
    }

    public int getNumberOfLeadingSquareBrackets() {
        int leadingSquareBrackets = 0;
        while (this.descriptor.content[leadingSquareBrackets] == 91) {
            ++leadingSquareBrackets;
        }
        return leadingSquareBrackets;
    }

    public DexType toBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    public DexType replaceBaseType(DexType newBase, DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        assert (!newBase.isArrayType());
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        byte[] content = new byte[newBase.descriptor.content.length + leadingSquareBrackets];
        Arrays.fill(content, 0, leadingSquareBrackets, (byte)91);
        System.arraycopy(newBase.descriptor.content, 0, content, leadingSquareBrackets, newBase.descriptor.content.length);
        DexString newDesc = dexItemFactory.createString(newBase.descriptor.size + leadingSquareBrackets, content);
        return dexItemFactory.createType(newDesc);
    }

    public DexType toArrayElementType(DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - 1, Arrays.copyOfRange(this.descriptor.content, 1, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    private String getPackageOrName(boolean packagePart) {
        assert (this.isClassType());
        String descriptor = this.toDescriptorString();
        int lastSeparator = descriptor.lastIndexOf(47);
        if (lastSeparator == -1) {
            return packagePart ? "" : descriptor.substring(1, descriptor.length() - 1);
        }
        return packagePart ? descriptor.substring(1, lastSeparator) : descriptor.substring(lastSeparator + 1, descriptor.length() - 1);
    }

    public String getPackageDescriptor() {
        return this.getPackageOrName(true);
    }

    public String getName() {
        if (this.isPrimitiveType()) {
            return this.toSourceString();
        }
        return this.getPackageOrName(false);
    }

    public String getInternalName() {
        assert (this.isClassType() || this.isArrayType());
        return DescriptorUtils.descriptorToInternalName(this.toDescriptorString());
    }

    public String getPackageName() {
        return DescriptorUtils.getPackageNameFromBinaryName(this.toBinaryName());
    }
}

