/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class DirectMappedDexApplication
extends DexApplication {
    private final Map<Code, DexEncodedMethod> codeOwners = new IdentityHashMap<Code, DexEncodedMethod>();
    private final Map<DexType, DexClass> allClasses;
    private final ImmutableList<DexProgramClass> programClasses;
    private final ImmutableList<DexClasspathClass> classpathClasses;
    private final ImmutableList<DexLibraryClass> libraryClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, Map<DexType, DexClass> allClasses, ImmutableList<DexProgramClass> programClasses, ImmutableList<DexClasspathClass> classpathClasses, ImmutableList<DexLibraryClass> libraryClasses, ImmutableList<DataResourceProvider> dataResourceProviders, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, dataResourceProviders, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.allClasses = Collections.unmodifiableMap(allClasses);
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    public Collection<DexClass> allClasses() {
        return this.allClasses.values();
    }

    @Override
    List<DexProgramClass> programClasses() {
        return this.programClasses;
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses;
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        return this.allClasses.get(type);
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz instanceof DexProgramClass ? clazz.asProgramClass() : null;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public DirectMappedDexApplication rewrittenWithLense(GraphLense graphLense) {
        DirectMappedDexApplication rewrittenApplication = this.builder().build().asDirect();
        assert (rewrittenApplication.mappingIsValid(graphLense, this.allClasses.keySet()));
        assert (rewrittenApplication.verifyCodeObjectsOwners());
        return rewrittenApplication;
    }

    private boolean mappingIsValid(GraphLense graphLense, Iterable<DexType> types) {
        for (DexType type : types) {
            DexType renamed = graphLense.lookupType(type);
            if (renamed != type && (this.definitionFor(type) != null || this.definitionFor(renamed) == null)) assert (this.definitionFor((DexType)type).type == renamed || this.definitionFor(renamed) != null);
        }
        return true;
    }

    public Map<Code, DexEncodedMethod> computeCodeObjectOwnersForDebugging() {
        this.verifyCodeObjectsOwners();
        return this.codeOwners;
    }

    public DexEncodedMethod getCodeOwnerForDebugging(Code code) {
        return this.computeCodeObjectOwnersForDebugging().get(code);
    }

    private boolean verifyCodeObjectsOwners() {
        this.codeOwners.clear();
        for (DexProgramClass clazz : this.programClasses) {
            for (DexEncodedMethod method : clazz.methods(DexEncodedMethod::isNonAbstractNonNativeMethod)) {
                Code code = method.getCode();
                assert (code != null);
                if (code.isCfCode()) {
                    code = code.asCfCode();
                }
                DexEncodedMethod otherMethod = this.codeOwners.put(code, method);
                assert (otherMethod == null);
            }
        }
        return true;
    }

    private static <T extends DexClass> void addAll(Map<DexType, DexClass> allClasses, Iterable<T> toAdd) {
        for (DexClass clazz : toAdd) {
            DexClass old = allClasses.put(clazz.type, clazz);
            assert (old == null);
        }
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private final ImmutableList<DexLibraryClass> libraryClasses;
        private final ImmutableList<DexClasspathClass> classpathClasses;

        Builder(LazyLoadedDexApplication application) {
            super(application);
            LazyLoadedDexApplication.AllClasses allClasses = application.loadAllClasses();
            assert (application.programClasses().equals(allClasses.getProgramClasses()));
            this.libraryClasses = allClasses.getLibraryClasses();
            this.classpathClasses = allClasses.getClasspathClasses();
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.libraryClasses = application.libraryClasses;
            this.classpathClasses = application.classpathClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public DexApplication build() {
            ImmutableList newProgramClasses = ImmutableList.copyOf(ProgramClassCollection.create(this.programClasses, ProgramClassCollection::resolveClassConflictImpl).getAllClasses());
            IdentityHashMap allClasses = new IdentityHashMap(newProgramClasses.size() + this.classpathClasses.size() + this.libraryClasses.size());
            DirectMappedDexApplication.addAll(allClasses, this.libraryClasses);
            DirectMappedDexApplication.addAll(allClasses, this.classpathClasses);
            DirectMappedDexApplication.addAll(allClasses, this.programClasses);
            return new DirectMappedDexApplication(this.proguardMap, allClasses, newProgramClasses, this.classpathClasses, this.libraryClasses, ImmutableList.copyOf(this.dataResourceProviders), ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

