/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class JarApplicationReader {
    public final InternalOptions options;
    private final ConcurrentHashMap<String, Type> asmObjectTypeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Type> asmTypeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DexString> stringCache = new ConcurrentHashMap();

    public JarApplicationReader(InternalOptions options) {
        this.options = options;
    }

    public Type getAsmObjectType(String name) {
        return this.asmObjectTypeCache.computeIfAbsent(name, key -> Type.getObjectType(key));
    }

    public Type getAsmType(String name) {
        return this.asmTypeCache.computeIfAbsent(name, key -> Type.getType(key));
    }

    public DexItemFactory getFactory() {
        return this.options.itemFactory;
    }

    public DexString getString(String string) {
        return this.stringCache.computeIfAbsent(string, this.options.itemFactory::createString);
    }

    public DexType getType(Type type) {
        return this.getTypeFromDescriptor(type.getDescriptor());
    }

    public DexType getTypeFromName(String name) {
        assert (this.isValidInternalName(name));
        return this.getType(this.getAsmObjectType(name));
    }

    public DexType getTypeFromDescriptor(String desc) {
        assert (this.isValidDescriptor(desc));
        return this.options.itemFactory.createType(this.getString(desc));
    }

    public DexTypeList getTypeListFromNames(String[] names) {
        if (names.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = this.getTypeFromName(names[i]);
        }
        return new DexTypeList(types);
    }

    public DexTypeList getTypeListFromDescriptors(String[] descriptors) {
        if (descriptors.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            types[i] = this.getTypeFromDescriptor(descriptors[i]);
        }
        return new DexTypeList(types);
    }

    public DexField getField(String owner, String name, String desc) {
        return this.getField(this.getTypeFromName(owner), name, desc);
    }

    public DexField getField(DexType owner, String name, String desc) {
        return this.options.itemFactory.createField(owner, this.getTypeFromDescriptor(desc), this.getString(name));
    }

    public DexMethod getMethod(String owner, String name, String desc) {
        return this.getMethod(this.getTypeFromName(owner), name, desc);
    }

    public DexMethod getMethod(DexType owner, String name, String desc) {
        return this.options.itemFactory.createMethod(owner, this.getProto(desc), this.getString(name));
    }

    public DexCallSite getCallSite(String methodName, String methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        return this.options.itemFactory.createCallSite(this.getString(methodName), this.getProto(methodProto), bootstrapMethod, bootstrapArgs);
    }

    public DexMethodHandle getMethodHandle(DexMethodHandle.MethodHandleType type, Descriptor<? extends DexItem, ? extends Descriptor<?, ?>> fieldOrMethod, boolean isInterface) {
        return this.options.itemFactory.createMethodHandle(type, fieldOrMethod, isInterface);
    }

    public DexProto getProto(String desc) {
        assert (this.isValidDescriptor(desc));
        String returnTypeDescriptor = JarApplicationReader.getReturnTypeDescriptor(desc);
        String[] argumentDescriptors = JarApplicationReader.getArgumentTypeDescriptors(desc);
        StringBuilder shortyDescriptor = new StringBuilder();
        shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(returnTypeDescriptor));
        for (int i = 0; i < argumentDescriptors.length; ++i) {
            shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(argumentDescriptors[i]));
        }
        DexProto proto = this.options.itemFactory.createProto(this.getTypeFromDescriptor(returnTypeDescriptor), this.getString(shortyDescriptor.toString()), this.getTypeListFromDescriptors(argumentDescriptors));
        return proto;
    }

    private static String getShortyDescriptor(String descriptor) {
        if (descriptor.length() == 1) {
            return descriptor;
        }
        assert (descriptor.charAt(0) == 'L' || descriptor.charAt(0) == '[');
        return "L";
    }

    private boolean isValidDescriptor(String desc) {
        return this.getAsmType(desc).getDescriptor().equals(desc);
    }

    private boolean isValidInternalName(String name) {
        return this.getAsmObjectType(name).getInternalName().equals(name);
    }

    public Type getReturnType(String methodDescriptor) {
        return this.getAsmType(JarApplicationReader.getReturnTypeDescriptor(methodDescriptor));
    }

    private static String getReturnTypeDescriptor(String methodDescriptor) {
        assert (methodDescriptor.indexOf(41) != -1);
        return methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
    }

    public static int getArgumentCount(String methodDescriptor) {
        char c;
        int charIdx = 1;
        int argCount = 0;
        while ((c = methodDescriptor.charAt(charIdx++)) != ')') {
            if (c == 'L') {
                while (methodDescriptor.charAt(charIdx++) != ';') {
                }
                ++argCount;
                continue;
            }
            if (c == '[') continue;
            ++argCount;
        }
        return argCount;
    }

    public Type[] getArgumentTypes(String methodDescriptor) {
        String[] argDescriptors = JarApplicationReader.getArgumentTypeDescriptors(methodDescriptor);
        Type[] args = new Type[argDescriptors.length];
        int argIdx = 0;
        for (String argDescriptor : argDescriptors) {
            args[argIdx++] = this.getAsmType(argDescriptor);
        }
        return args;
    }

    private static String[] getArgumentTypeDescriptors(String methodDescriptor) {
        char c;
        String[] argDescriptors = new String[JarApplicationReader.getArgumentCount(methodDescriptor)];
        int charIdx = 1;
        int argIdx = 0;
        while ((c = methodDescriptor.charAt(charIdx)) != ')') {
            switch (c) {
                case 'V': {
                    throw new Unreachable();
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    argDescriptors[argIdx++] = Character.toString(c);
                    break;
                }
                case '[': {
                    int startType = charIdx;
                    while (methodDescriptor.charAt(++charIdx) == '[') {
                    }
                    if (methodDescriptor.charAt(charIdx) == 'L') {
                        while (methodDescriptor.charAt(++charIdx) != ';') {
                        }
                    }
                    argDescriptors[argIdx++] = methodDescriptor.substring(startType, charIdx + 1);
                    break;
                }
                case 'L': {
                    int startType = charIdx;
                    while (methodDescriptor.charAt(++charIdx) != ';') {
                    }
                    argDescriptors[argIdx++] = methodDescriptor.substring(startType, charIdx + 1);
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            ++charIdx;
        }
        return argDescriptors;
    }
}

