/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarCode;
import com.android.tools.r8.graph.LazyCfCode;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.r8.org.objectweb.asm.Attribute;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.FieldVisitor;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.TypePath;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class JarClassFileReader {
    private static final byte[] CLASSFILE_HEADER = ByteBuffer.allocate(4).putInt(-889275714).array();
    private static final int ACC_SYNTHETIC_ATTRIBUTE = 262144;
    private final JarApplicationReader application;
    private final Consumer<DexClass> classConsumer;

    public JarClassFileReader(JarApplicationReader application, Consumer<DexClass> classConsumer) {
        this.application = application;
        this.classConsumer = classConsumer;
    }

    public void read(Origin origin, ClassKind classKind, InputStream input) throws IOException {
        int read;
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        byte[] header = new byte[CLASSFILE_HEADER.length];
        input.mark(header.length);
        for (int size = 0; size < header.length; size += read) {
            read = input.read(header, size, header.length - size);
            if (read >= 0) continue;
            throw new CompilationError("Invalid empty classfile", origin);
        }
        if (!Arrays.equals(CLASSFILE_HEADER, header)) {
            throw new CompilationError("Invalid classfile header", origin);
        }
        input.reset();
        ClassReader reader = new ClassReader(input);
        int parsingOptions = 5;
        if (this.application.options.getProguardConfiguration() != null) {
            ProguardKeepAttributes keep = this.application.options.getProguardConfiguration().getKeepAttributes();
            if (!keep.sourceFile && !keep.sourceDebugExtension) {
                parsingOptions |= 2;
            }
        }
        reader.accept(new CreateDexClassVisitor(origin, classKind, reader.b, this.application, this.classConsumer), parsingOptions);
        if (reader.getItemCount() > 2 && reader.getItem(2) > 0) {
            try {
                Object maybeMarker = reader.readConst(2, new char[reader.getMaxStringLength()]);
                if (maybeMarker instanceof String) {
                    this.application.getFactory().createString((String)maybeMarker);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static int cleanAccessFlags(int access) {
        return access & 0xFFFBFFFF & 0xFFFDFFFF;
    }

    public static FieldAccessFlags createFieldAccessFlags(int access) {
        return FieldAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access));
    }

    public static MethodAccessFlags createMethodAccessFlags(String name, int access) {
        boolean isConstructor = name.equals("<init>") || name.equals("<clinit>");
        return MethodAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access), isConstructor);
    }

    private static AnnotationVisitor createAnnotationVisitor(String desc, boolean visible, List<DexAnnotation> annotations, JarApplicationReader application) {
        assert (annotations != null);
        if (visible || JarClassFileReader.retainCompileTimeAnnotation(desc, application)) {
            int visiblity = visible ? 1 : 0;
            return new CreateAnnotationVisitor(application, (names, values2) -> annotations.add(new DexAnnotation(visiblity, JarClassFileReader.createEncodedAnnotation(desc, names, values2, application))));
        }
        return null;
    }

    private static boolean retainCompileTimeAnnotation(String desc, JarApplicationReader application) {
        return application.options.readCompileTimeAnnotations || DexAnnotation.retainCompileTimeAnnotation(application.getTypeFromDescriptor(desc), application.options);
    }

    private static DexEncodedAnnotation createEncodedAnnotation(String desc, List<DexString> names, List<DexValue> values2, JarApplicationReader application) {
        assert (names == null && values2.isEmpty() || names != null && !names.isEmpty() && names.size() == values2.size());
        DexAnnotationElement[] elements = new DexAnnotationElement[values2.size()];
        for (int i = 0; i < values2.size(); ++i) {
            elements[i] = new DexAnnotationElement(names.get(i), values2.get(i));
        }
        return new DexEncodedAnnotation(application.getTypeFromDescriptor(desc), elements);
    }

    private static DexAnnotationSet createAnnotationSet(List<DexAnnotation> annotations, InternalOptions options) {
        DexType dupType;
        if (annotations == null || annotations.isEmpty()) {
            return DexAnnotationSet.empty();
        }
        if (options.isGeneratingDex() && (dupType = DexAnnotationSet.findDuplicateEntryType(annotations)) != null) {
            throw new CompilationError("Multiple annotations of type `" + dupType.toSourceString() + "`");
        }
        return new DexAnnotationSet(annotations.toArray(DexAnnotation.EMPTY_ARRAY));
    }

    public static class ReparseContext {
        public byte[] classCache;
        public DexProgramClass owner;
        public final List<Code> codeList = new ArrayList<Code>();
    }

    private static class CreateAnnotationVisitor
    extends AnnotationVisitor {
        private final JarApplicationReader application;
        private final BiConsumer<List<DexString>, List<DexValue>> onVisitEnd;
        private List<DexString> names = null;
        private final List<DexValue> values = new ArrayList<DexValue>();

        public CreateAnnotationVisitor(JarApplicationReader application, BiConsumer<List<DexString>, List<DexValue>> onVisitEnd) {
            super(458752);
            this.application = application;
            this.onVisitEnd = onVisitEnd;
        }

        @Override
        public void visit(String name, Object value) {
            this.addElement(name, this.getDexValue(value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            DexType owner = this.application.getTypeFromDescriptor(desc);
            this.addElement(name, new DexValue.DexValueEnum(this.application.getField(owner, value, desc)));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new CreateAnnotationVisitor(this.application, (names, values2) -> this.addElement(name, new DexValue.DexValueAnnotation(JarClassFileReader.createEncodedAnnotation(desc, names, values2, this.application))));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new CreateAnnotationVisitor(this.application, (names, values2) -> {
                assert (names == null);
                this.addElement(name, new DexValue.DexValueArray(values2.toArray(DexValue.EMPTY_ARRAY)));
            });
        }

        @Override
        public void visitEnd() {
            this.onVisitEnd.accept(this.names, this.values);
        }

        private void addElement(String name, DexValue value) {
            if (name != null) {
                if (this.names == null) {
                    this.names = new ArrayList<DexString>();
                }
                this.names.add(this.application.getString(name));
            }
            this.values.add(value);
        }

        private static DexValue.DexValueArray getDexValueArray(Object value) {
            if (value instanceof byte[]) {
                byte[] values2 = (byte[])value;
                DexValue[] elements = new DexValue[values2.length];
                for (int i = 0; i < values2.length; ++i) {
                    elements[i] = DexValue.DexValueByte.create(values2[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof boolean[]) {
                boolean[] values3 = (boolean[])value;
                DexValue[] elements = new DexValue[values3.length];
                for (int i = 0; i < values3.length; ++i) {
                    elements[i] = DexValue.DexValueBoolean.create(values3[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof char[]) {
                char[] values4 = (char[])value;
                DexValue[] elements = new DexValue[values4.length];
                for (int i = 0; i < values4.length; ++i) {
                    elements[i] = DexValue.DexValueChar.create(values4[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof short[]) {
                short[] values5 = (short[])value;
                DexValue[] elements = new DexValue[values5.length];
                for (int i = 0; i < values5.length; ++i) {
                    elements[i] = DexValue.DexValueShort.create(values5[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof int[]) {
                int[] values6 = (int[])value;
                DexValue[] elements = new DexValue[values6.length];
                for (int i = 0; i < values6.length; ++i) {
                    elements[i] = DexValue.DexValueInt.create(values6[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof long[]) {
                long[] values7 = (long[])value;
                DexValue[] elements = new DexValue[values7.length];
                for (int i = 0; i < values7.length; ++i) {
                    elements[i] = DexValue.DexValueLong.create(values7[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof float[]) {
                float[] values8 = (float[])value;
                DexValue[] elements = new DexValue[values8.length];
                for (int i = 0; i < values8.length; ++i) {
                    elements[i] = DexValue.DexValueFloat.create(values8[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof double[]) {
                double[] values9 = (double[])value;
                DexValue[] elements = new DexValue[values9.length];
                for (int i = 0; i < values9.length; ++i) {
                    elements[i] = DexValue.DexValueDouble.create(values9[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            throw new Unreachable("Unexpected type of annotation value: " + value);
        }

        private DexValue getDexValue(Object value) {
            if (value == null) {
                return DexValue.DexValueNull.NULL;
            }
            if (value instanceof Byte) {
                return DexValue.DexValueByte.create((Byte)value);
            }
            if (value instanceof Boolean) {
                return DexValue.DexValueBoolean.create((Boolean)value);
            }
            if (value instanceof Character) {
                return DexValue.DexValueChar.create(((Character)value).charValue());
            }
            if (value instanceof Short) {
                return DexValue.DexValueShort.create((Short)value);
            }
            if (value instanceof Integer) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (value instanceof Long) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (value instanceof Float) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (value instanceof String) {
                return new DexValue.DexValueString(this.application.getString((String)value));
            }
            if (value instanceof Type) {
                return new DexValue.DexValueType(this.application.getTypeFromDescriptor(((Type)value).getDescriptor()));
            }
            return CreateAnnotationVisitor.getDexValueArray(value);
        }
    }

    private static class CreateMethodVisitor
    extends MethodVisitor {
        private final String name;
        final CreateDexClassVisitor parent;
        private final int parameterCount;
        private List<DexAnnotation> annotations = null;
        private DexValue defaultAnnotation = null;
        private int annotableParameterCount = -1;
        private List<List<DexAnnotation>> parameterAnnotationsLists = null;
        private List<DexValue> parameterNames = null;
        private List<DexValue> parameterFlags = null;
        final DexMethod method;
        final MethodAccessFlags flags;
        Code code = null;

        public CreateMethodVisitor(int access, String name, String desc, String signature, String[] exceptions, CreateDexClassVisitor parent) {
            super(458752);
            this.name = name;
            this.parent = parent;
            this.method = parent.application.getMethod(parent.type, name, desc);
            this.flags = JarClassFileReader.createMethodAccessFlags(name, access);
            this.parameterCount = JarApplicationReader.getArgumentCount(desc);
            if (exceptions != null && exceptions.length > 0) {
                DexValue[] values2 = new DexValue[exceptions.length];
                for (int i = 0; i < exceptions.length; ++i) {
                    values2[i] = new DexValue.DexValueType(parent.application.getTypeFromName(exceptions[i]));
                }
                this.addAnnotation(DexAnnotation.createThrowsAnnotation(values2, parent.application.getFactory()));
            }
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new CreateAnnotationVisitor(this.parent.application, (names, elements) -> {
                assert (elements.size() == 1);
                this.defaultAnnotation = (DexValue)elements.get(0);
            });
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            if (this.annotableParameterCount != -1) assert (this.annotableParameterCount == parameterCount);
            this.annotableParameterCount = parameterCount;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (this.parameterAnnotationsLists == null) {
                if (this.annotableParameterCount == -1) {
                    this.annotableParameterCount = this.parameterCount;
                }
                this.parameterAnnotationsLists = new ArrayList<List<DexAnnotation>>(this.annotableParameterCount);
                for (int i = 0; i < this.annotableParameterCount; ++i) {
                    this.parameterAnnotationsLists.add(new ArrayList());
                }
            }
            assert (this.mv == null);
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.parameterAnnotationsLists.get(parameter), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitParameter(String name, int access) {
            if (this.parameterNames == null) {
                assert (this.parameterFlags == null);
                this.parameterNames = new ArrayList<DexValue>(this.parameterCount);
                this.parameterFlags = new ArrayList<DexValue>(this.parameterCount);
            }
            this.parameterNames.add(new DexValue.DexValueString(this.parent.application.getFactory().createString(name)));
            this.parameterFlags.add(DexValue.DexValueInt.create(access));
            super.visitParameter(name, access);
        }

        @Override
        public void visitCode() {
            throw new Unreachable("visitCode() should not be called when SKIP_CODE is set");
        }

        @Override
        public void visitEnd() {
            ParameterAnnotationsList annotationsList;
            if (!this.flags.isAbstract() && !this.flags.isNative() && this.parent.classKind == ClassKind.PROGRAM) {
                this.code = ((CreateDexClassVisitor)this.parent).application.options.enableCfFrontend ? new LazyCfCode(this.method, this.parent.origin, this.parent.context, this.parent.application) : new JarCode(this.method, this.parent.origin, this.parent.context, this.parent.application);
            }
            if (this.parameterAnnotationsLists == null) {
                annotationsList = ParameterAnnotationsList.empty();
            } else {
                DexAnnotationSet[] sets = new DexAnnotationSet[this.parameterAnnotationsLists.size()];
                for (int i = 0; i < this.parameterAnnotationsLists.size(); ++i) {
                    sets[i] = JarClassFileReader.createAnnotationSet(this.parameterAnnotationsLists.get(i), ((CreateDexClassVisitor)this.parent).application.options);
                }
                annotationsList = new ParameterAnnotationsList(sets);
            }
            InternalOptions internalOptions = ((CreateDexClassVisitor)this.parent).application.options;
            if (this.parameterNames != null && internalOptions.canUseParameterNameAnnotations()) {
                assert (this.parameterFlags != null);
                if (this.parameterNames.size() != this.parameterCount) {
                    internalOptions.warningInvalidParameterAnnotations(this.method, this.parent.origin, this.parameterCount, this.parameterNames.size());
                }
                this.getAnnotations().add(DexAnnotation.createMethodParametersAnnotation(this.parameterNames.toArray(DexValue.EMPTY_ARRAY), this.parameterFlags.toArray(DexValue.EMPTY_ARRAY), this.parent.application.getFactory()));
            }
            DexEncodedMethod dexMethod = new DexEncodedMethod(this.method, this.flags, JarClassFileReader.createAnnotationSet(this.annotations, ((CreateDexClassVisitor)this.parent).application.options), annotationsList, this.code, this.parent.version);
            Equivalence.Wrapper<DexMethod> signature = MethodSignatureEquivalence.get().wrap(this.method);
            if (this.parent.methodSignatures.add(signature)) {
                this.parent.hasReachabilitySensitiveMethod = (byte)(this.parent.hasReachabilitySensitiveMethod | (this.isReachabilitySensitive() ? 1 : 0));
                if (this.flags.isStatic() || this.flags.isConstructor() || this.flags.isPrivate()) {
                    this.parent.directMethods.add(dexMethod);
                } else {
                    this.parent.virtualMethods.add(dexMethod);
                }
            } else {
                internalOptions.reporter.warning(new StringDiagnostic(String.format("Ignoring an implementation of the method `%s` because it has multiple definitions", this.method.toSourceString())));
            }
            if (this.defaultAnnotation != null) {
                this.parent.addDefaultAnnotation(this.name, this.defaultAnnotation);
            }
        }

        private boolean isReachabilitySensitive() {
            DexType reachabilitySensitive = ((CreateDexClassVisitor)this.parent).application.getFactory().annotationReachabilitySensitive;
            for (DexAnnotation annotation : this.getAnnotations()) {
                if (annotation.annotation.type != reachabilitySensitive) continue;
                return true;
            }
            return false;
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }
    }

    private static class CreateFieldVisitor
    extends FieldVisitor {
        private final CreateDexClassVisitor parent;
        private final int access;
        private final String name;
        private final String desc;
        private final Object value;
        private List<DexAnnotation> annotations = null;

        public CreateFieldVisitor(CreateDexClassVisitor parent, int access, String name, String desc, String signature, Object value) {
            super(458752);
            this.parent = parent;
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.value = value;
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitEnd() {
            FieldAccessFlags flags = JarClassFileReader.createFieldAccessFlags(this.access);
            DexField dexField = this.parent.application.getField(this.parent.type, this.name, this.desc);
            Equivalence.Wrapper<DexField> signature = FieldSignatureEquivalence.get().wrap(dexField);
            if (this.parent.fieldSignatures.add(signature)) {
                DexAnnotationSet annotationSet = JarClassFileReader.createAnnotationSet(this.annotations, ((CreateDexClassVisitor)this.parent).application.options);
                DexValue staticValue = flags.isStatic() ? this.getStaticValue(this.value, dexField.type) : null;
                DexEncodedField field = new DexEncodedField(dexField, flags, annotationSet, staticValue);
                if (flags.isStatic()) {
                    this.parent.staticFields.add(field);
                } else {
                    this.parent.instanceFields.add(field);
                }
            } else {
                ((CreateDexClassVisitor)this.parent).application.options.reporter.warning(new StringDiagnostic(String.format("Field `%s` has multiple definitions", dexField.toSourceString())));
            }
        }

        private DexValue getStaticValue(Object value, DexType type) {
            if (value == null) {
                return null;
            }
            DexItemFactory factory = this.parent.application.getFactory();
            if (type == factory.booleanType) {
                int i = (Integer)value;
                assert (0 <= i && i <= 1);
                return DexValue.DexValueBoolean.create(i == 1);
            }
            if (type == factory.byteType) {
                return DexValue.DexValueByte.create(((Integer)value).byteValue());
            }
            if (type == factory.shortType) {
                return DexValue.DexValueShort.create(((Integer)value).shortValue());
            }
            if (type == factory.charType) {
                return DexValue.DexValueChar.create((char)((Integer)value).intValue());
            }
            if (type == factory.intType) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (type == factory.floatType) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (type == factory.longType) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (type == factory.doubleType) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (type == factory.stringType) {
                return new DexValue.DexValueString(factory.createString((String)value));
            }
            throw new Unreachable("Unexpected static-value type " + type);
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }
    }

    private static class CreateDexClassVisitor
    extends ClassVisitor {
        private final Origin origin;
        private final ClassKind classKind;
        private final JarApplicationReader application;
        private final Consumer<DexClass> classConsumer;
        private final ReparseContext context = new ReparseContext();
        private int version;
        private DexType type;
        private ClassAccessFlags accessFlags;
        private DexType superType;
        private DexTypeList interfaces;
        private DexString sourceFile;
        private NestHostClassAttribute nestHost = null;
        private final List<NestMemberClassAttribute> nestMembers = new ArrayList<NestMemberClassAttribute>();
        private EnclosingMethodAttribute enclosingMember = null;
        private final List<InnerClassAttribute> innerClasses = new ArrayList<InnerClassAttribute>();
        private List<DexAnnotation> annotations = null;
        private List<DexAnnotationElement> defaultAnnotations = null;
        private final List<DexEncodedField> staticFields = new ArrayList<DexEncodedField>();
        private final List<DexEncodedField> instanceFields = new ArrayList<DexEncodedField>();
        private final Set<Equivalence.Wrapper<DexField>> fieldSignatures = new HashSet<Equivalence.Wrapper<DexField>>();
        private final List<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
        private final List<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();
        private final Set<Equivalence.Wrapper<DexMethod>> methodSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();
        private boolean hasReachabilitySensitiveMethod = false;

        public CreateDexClassVisitor(Origin origin, ClassKind classKind, byte[] classCache, JarApplicationReader application, Consumer<DexClass> classConsumer) {
            super(458752);
            this.origin = origin;
            this.classKind = classKind;
            this.classConsumer = classConsumer;
            this.context.classCache = classCache;
            this.application = application;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            String separator;
            if (outerName != null && innerName != null && (separator = DescriptorUtils.computeInnerClassSeparator(outerName, name, innerName)) == null && this.getMajorVersion() < 53) {
                this.application.options.reporter.info(new StringDiagnostic(StringUtils.lines("Malformed inner-class attribute:", "\touterTypeInternal: " + outerName, "\tinnerTypeInternal: " + name, "\tinnerName: " + innerName)));
            }
            this.innerClasses.add(new InnerClassAttribute(access, this.application.getTypeFromName(name), outerName == null ? null : this.application.getTypeFromName(outerName), innerName == null ? null : this.application.getString(innerName)));
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
            assert (this.enclosingMember == null);
            DexType ownerType = this.application.getTypeFromName(owner);
            this.enclosingMember = name == null ? new EnclosingMethodAttribute(ownerType) : new EnclosingMethodAttribute(this.application.getMethod(ownerType, name, desc));
        }

        @Override
        public void visitNestHost(String nestHost) {
            assert (this.nestHost == null && this.nestMembers.isEmpty());
            DexType nestHostType = this.application.getTypeFromName(nestHost);
            this.nestHost = new NestHostClassAttribute(nestHostType);
        }

        @Override
        public void visitNestMember(String nestMember) {
            assert (this.nestHost == null);
            DexType nestMemberType = this.application.getTypeFromName(nestMember);
            this.nestMembers.add(new NestMemberClassAttribute(nestMemberType));
        }

        private String illegalClassFilePrefix(ClassAccessFlags accessFlags, String name) {
            return "Illegal class file: " + (accessFlags.isInterface() ? "Interface" : "Class") + " " + name;
        }

        private String illegalClassFilePostfix(int version) {
            return "Class file version " + version;
        }

        private String illegalClassFileMessage(ClassAccessFlags accessFlags, String name, int version, String message) {
            return this.illegalClassFilePrefix(accessFlags, name) + " " + message + ". " + this.illegalClassFilePostfix(version) + ".";
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.version = version;
            this.accessFlags = ClassAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access));
            this.type = this.application.getTypeFromName(name);
            if (!this.accessFlags.areValid(this.getMajorVersion(), name.endsWith("/package-info"))) {
                throw new CompilationError(this.illegalClassFileMessage(this.accessFlags, name, version, "has invalid access flags. Found: " + this.accessFlags.toString()), this.origin);
            }
            if (superName == null && !name.equals("java/lang/Object")) {
                throw new CompilationError(this.illegalClassFileMessage(this.accessFlags, name, version, "is missing a super type"), this.origin);
            }
            if (this.accessFlags.isInterface() && !Objects.equals(superName, "java/lang/Object")) {
                throw new CompilationError(this.illegalClassFileMessage(this.accessFlags, name, version, "must extend class java.lang.Object. Found: " + Objects.toString(superName)), this.origin);
            }
            assert (superName != null || name.equals("java/lang/Object"));
            this.superType = superName == null ? null : this.application.getTypeFromName(superName);
            this.interfaces = this.application.getTypeListFromNames(interfaces);
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, this.application.getFactory()));
            }
        }

        @Override
        public void visitSource(String source, String debug) {
            if (source != null) {
                this.sourceFile = this.application.getString(source);
            }
            if (debug != null) {
                this.getAnnotations().add(DexAnnotation.createSourceDebugExtensionAnnotation(new DexValue.DexValueString(this.application.getString(debug)), this.application.getFactory()));
            }
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldAccessFlags flags;
            if (this.classKind == ClassKind.LIBRARY && (flags = JarClassFileReader.createFieldAccessFlags(access)).isPrivate()) {
                return null;
            }
            return new CreateFieldVisitor(this, access, name, desc, signature, this.classKind == ClassKind.LIBRARY ? null : value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodAccessFlags flags;
            if (this.classKind == ClassKind.LIBRARY && ((flags = JarClassFileReader.createMethodAccessFlags(name, access)).isStatic() && flags.isConstructor() || flags.isPrivate())) {
                return null;
            }
            return new CreateMethodVisitor(access, name, desc, signature, exceptions, this);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
            if (this.defaultAnnotations != null) {
                this.addAnnotation(DexAnnotation.createAnnotationDefaultAnnotation(this.type, this.defaultAnnotations, this.application.getFactory()));
            }
            this.checkReachabilitySensitivity();
            DexClass clazz = this.classKind.create(this.type, ProgramResource.Kind.CF, this.origin, this.accessFlags, this.superType, this.interfaces, this.sourceFile, this.nestHost, this.nestMembers, this.enclosingMember, this.innerClasses, JarClassFileReader.createAnnotationSet(this.annotations, this.application.options), this.staticFields.toArray(DexEncodedField.EMPTY_ARRAY), this.instanceFields.toArray(DexEncodedField.EMPTY_ARRAY), this.directMethods.toArray(DexEncodedMethod.EMPTY_ARRAY), this.virtualMethods.toArray(DexEncodedMethod.EMPTY_ARRAY), this.application.getFactory().getSkipNameValidationForTesting());
            if (this.enclosingMember == null && (clazz.isLocalClass() || clazz.isAnonymousClass()) && this.getMajorVersion() > 50) {
                this.application.options.warningMissingEnclosingMember(clazz.type, clazz.origin, this.version);
            }
            if (clazz.isProgramClass()) {
                this.context.owner = clazz.asProgramClass();
                clazz.asProgramClass().setInitialClassFileVersion(this.version);
            }
            this.classConsumer.accept(clazz);
        }

        private void checkReachabilitySensitivity() {
            if (this.hasReachabilitySensitiveMethod || this.hasReachabilitySensitiveField()) {
                Code code;
                for (DexEncodedMethod method : this.directMethods) {
                    code = method.getCode();
                    if (code == null || !code.isJarCode()) continue;
                    code.asJarCode().markReachabilitySensitive();
                }
                for (DexEncodedMethod method : this.virtualMethods) {
                    code = method.getCode();
                    if (code == null || !code.isJarCode()) continue;
                    code.asJarCode().markReachabilitySensitive();
                }
            }
        }

        private boolean hasReachabilitySensitiveField() {
            DexType reachabilitySensitive = this.application.getFactory().annotationReachabilitySensitive;
            for (DexEncodedField field : this.instanceFields) {
                for (DexAnnotation annotation : field.annotations.annotations) {
                    if (annotation.annotation.type != reachabilitySensitive) continue;
                    return true;
                }
            }
            for (DexEncodedField field : this.staticFields) {
                for (DexAnnotation annotation : field.annotations.annotations) {
                    if (annotation.annotation.type != reachabilitySensitive) continue;
                    return true;
                }
            }
            return false;
        }

        private void addDefaultAnnotation(String name, DexValue value) {
            if (this.defaultAnnotations == null) {
                this.defaultAnnotations = new ArrayList<DexAnnotationElement>();
            }
            this.defaultAnnotations.add(new DexAnnotationElement(this.application.getString(name), value));
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private int getMajorVersion() {
            return this.version & 0xFFFF;
        }

        private int getMinorVersion() {
            return this.version >> 16 & 0xFFFF;
        }
    }
}

