/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class LazyLoadedDexApplication
extends DexApplication {
    private final ProgramClassCollection programClasses;
    private final ClasspathClassCollection classpathClasses;
    private final LibraryClassCollection libraryClasses;

    private LazyLoadedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableList<DataResourceProvider> dataResourceProviders, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, dataResourceProviders, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    @Override
    List<DexProgramClass> programClasses() {
        this.programClasses.forceLoad(t -> true);
        return this.programClasses.getAllClasses();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        Object clazz = this.programClasses.get(type);
        if (clazz == null && this.classpathClasses != null) {
            clazz = this.classpathClasses.get(type);
        }
        if (clazz == null && this.libraryClasses != null) {
            clazz = this.libraryClasses.get(type);
        }
        return clazz;
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        return (DexProgramClass)this.programClasses.get(type);
    }

    public AllClasses loadAllClasses() {
        return new AllClasses(this.libraryClasses, this.classpathClasses, this.programClasses);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return new DirectMappedDexApplication.Builder(this).build().asDirect();
    }

    @Override
    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        private final ApplicationReader.ProgramClassConflictResolver resolver;

        Builder(ApplicationReader.ProgramClassConflictResolver resolver, DexItemFactory dexItemFactory, Timing timing) {
            super(dexItemFactory, timing);
            this.resolver = resolver;
            this.classpathClasses = null;
            this.libraryClasses = null;
        }

        private Builder(LazyLoadedDexApplication application) {
            super(application);
            this.resolver = ProgramClassCollection::resolveClassConflictImpl;
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        @Override
        public LazyLoadedDexApplication build() {
            return new LazyLoadedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses, this.resolver), ImmutableList.copyOf(this.dataResourceProviders), this.classpathClasses, this.libraryClasses, ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }

    static class AllClasses {
        private final Map<DexType, DexClass> allClasses;
        private final ImmutableList<DexProgramClass> programClasses;
        private final ImmutableList<DexClasspathClass> classpathClasses;
        private final ImmutableList<DexLibraryClass> libraryClasses;

        AllClasses(LibraryClassCollection libraryClassesLoader, ClasspathClassCollection classpathClassesLoader, ProgramClassCollection programClassesLoader) {
            ImmutableList.Builder builder;
            assert (programClassesLoader != null);
            programClassesLoader.forceLoad(type -> true);
            Map allProgramClasses = programClassesLoader.getAllClassesInMap();
            int expectedMaxSize = allProgramClasses.size();
            this.programClasses = ImmutableList.copyOf(allProgramClasses.values());
            Map allClasspathClasses = null;
            if (classpathClassesLoader != null) {
                classpathClassesLoader.forceLoad(type -> true);
                allClasspathClasses = classpathClassesLoader.getAllClassesInMap();
                expectedMaxSize += allClasspathClasses.size();
            }
            Map allLibraryClasses = null;
            if (libraryClassesLoader != null) {
                libraryClassesLoader.forceLoad(type -> true);
                allLibraryClasses = libraryClassesLoader.getAllClassesInMap();
                expectedMaxSize += allLibraryClasses.size();
            }
            IdentityHashMap prioritizedClasses = new IdentityHashMap(expectedMaxSize);
            prioritizedClasses.putAll(allProgramClasses);
            if (allClasspathClasses != null) {
                builder = ImmutableList.builder();
                allClasspathClasses.forEach((type, clazz) -> {
                    if (!prioritizedClasses.containsKey(type)) {
                        prioritizedClasses.put((DexType)type, clazz);
                        builder.add(clazz);
                    }
                });
                this.classpathClasses = builder.build();
            } else {
                this.classpathClasses = ImmutableList.of();
            }
            if (allLibraryClasses != null) {
                builder = ImmutableList.builder();
                allLibraryClasses.forEach((type, clazz) -> {
                    if (!prioritizedClasses.containsKey(type)) {
                        prioritizedClasses.put((DexType)type, clazz);
                        builder.add(clazz);
                    }
                });
                this.libraryClasses = builder.build();
            } else {
                this.libraryClasses = ImmutableList.of();
            }
            this.allClasses = Collections.unmodifiableMap(prioritizedClasses);
        }

        public Map<DexType, DexClass> getAllClasses() {
            return this.allClasses;
        }

        public ImmutableList<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public ImmutableList<DexClasspathClass> getClasspathClasses() {
            return this.classpathClasses;
        }

        public ImmutableList<DexLibraryClass> getLibraryClasses() {
            return this.libraryClasses;
        }
    }
}

