/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DefaultInstructionVisitor;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class InitializedClassesOnNormalExitAnalysis {
    public static Set<DexType> computeInitializedClassesOnNormalExit(AppView<AppInfoWithLiveness> appView, IRCode code) {
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        Visitor visitor = new Visitor(appView, code.method.method.holder);
        for (BasicBlock dominator : dominatorTree.normalExitDominatorBlocks()) {
            if (dominator.hasCatchHandlers()) continue;
            for (Instruction instruction : dominator.getInstructions()) {
                instruction.accept(visitor);
            }
        }
        return visitor.build();
    }

    private static class Visitor
    extends DefaultInstructionVisitor<Void> {
        private final AppView<AppInfoWithLiveness> appView;
        private final DexType context;
        private final Set<DexType> initializedClassesOnNormalExit = Sets.newIdentityHashSet();

        Visitor(AppView<AppInfoWithLiveness> appView, DexType context) {
            this.appView = appView;
            this.context = context;
        }

        Set<DexType> build() {
            return Collections.unmodifiableSet(this.initializedClassesOnNormalExit);
        }

        private void markInitializedOnNormalExit(Iterable<DexType> knownToBeInitialized) {
            knownToBeInitialized.forEach(this::markInitializedOnNormalExit);
        }

        private void markInitializedOnNormalExit(DexType knownToBeInitialized) {
            if (knownToBeInitialized == this.context) {
                return;
            }
            DexClass clazz = this.appView.definitionFor(knownToBeInitialized);
            if (clazz == null) {
                return;
            }
            if (!clazz.isProgramClass()) {
                return;
            }
            if (!clazz.classInitializationMayHaveSideEffects(this.appView)) {
                return;
            }
            ArrayList<DexType> subsumedByKnownToBeInitialized = null;
            for (DexType alreadyKnownToBeInitialized : this.initializedClassesOnNormalExit) {
                if (this.appView.isSubtype(alreadyKnownToBeInitialized, knownToBeInitialized).isTrue()) {
                    return;
                }
                if (!this.appView.isSubtype(knownToBeInitialized, alreadyKnownToBeInitialized).isTrue()) continue;
                if (subsumedByKnownToBeInitialized == null) {
                    subsumedByKnownToBeInitialized = new ArrayList<DexType>();
                }
                subsumedByKnownToBeInitialized.add(alreadyKnownToBeInitialized);
            }
            this.initializedClassesOnNormalExit.add(knownToBeInitialized);
            if (subsumedByKnownToBeInitialized != null) {
                this.initializedClassesOnNormalExit.removeAll(subsumedByKnownToBeInitialized);
            }
        }

        @Override
        public Void handleFieldInstruction(FieldInstruction instruction) {
            DexEncodedField field = this.appView.appInfo().resolveField(instruction.getField());
            if (field != null) {
                if (field.field.holder.isClassType()) {
                    this.markInitializedOnNormalExit(field.field.holder);
                } else assert (false) : "Expected holder of field type to be a class type";
            }
            return null;
        }

        @Override
        public Void handleInvoke(Invoke instruction) {
            if (instruction.isInvokeMethod()) {
                InvokeMethod invoke = instruction.asInvokeMethod();
                DexMethod method = invoke.getInvokedMethod();
                if (method.holder.isClassType()) {
                    DexEncodedMethod singleTarget = invoke.lookupSingleTarget(this.appView, this.context);
                    if (singleTarget != null) {
                        this.markInitializedOnNormalExit(singleTarget.method.holder);
                        this.markInitializedOnNormalExit(singleTarget.getOptimizationInfo().getInitializedClassesOnNormalExit());
                    } else {
                        this.markInitializedOnNormalExit(method.holder);
                    }
                }
            }
            return null;
        }

        @Override
        public Void visit(NewInstance instruction) {
            this.markInitializedOnNormalExit(instruction.clazz);
            return null;
        }
    }
}

