/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;

public class TypeChecker {
    private final AppView<? extends AppInfoWithSubtyping> appView;

    public TypeChecker(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
    }

    public boolean check(IRCode code) {
        InstructionIterator instructionIterator = code.instructionIterator();
        while (instructionIterator.hasNext()) {
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!(instruction.isInstancePut() ? !this.check(instruction.asInstancePut()) : (instruction.isStaticPut() ? !this.check(instruction.asStaticPut()) : instruction.isThrow() && !this.check(instruction.asThrow())))) continue;
            return false;
        }
        return true;
    }

    public boolean check(InstancePut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean check(StaticPut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean checkFieldPut(FieldInstruction instruction) {
        TypeLatticeElement fieldType;
        assert (instruction.isFieldPut());
        Value value = instruction.isInstancePut() ? instruction.asInstancePut().value() : instruction.asStaticPut().inValue();
        TypeLatticeElement valueType = value.getTypeLattice();
        if (this.isSubtypeOf(valueType, fieldType = TypeLatticeElement.fromDexType(instruction.getField().type, valueType.nullability(), this.appView))) {
            return true;
        }
        if (fieldType.isClassType() && valueType.isReference()) {
            DexClass clazz = this.appView.definitionFor(instruction.getField().type);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(Throw instruction) {
        TypeLatticeElement valueType = instruction.exception().getTypeLattice();
        TypeLatticeElement throwableType = TypeLatticeElement.fromDexType(this.appView.dexItemFactory().throwableType, valueType.nullability(), this.appView);
        return this.isSubtypeOf(valueType, throwableType);
    }

    private boolean isSubtypeOf(TypeLatticeElement expectedSubtype, TypeLatticeElement expectedSupertype) {
        return expectedSubtype.isNullType() && expectedSupertype.isReference() || expectedSubtype.lessThanOrEqual(expectedSupertype, this.appView) || expectedSubtype.isBasedOnMissingClass(this.appView);
    }
}

