/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.NullabilityVariants;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Objects;

public class ArrayTypeLatticeElement
extends ReferenceTypeLatticeElement {
    private final TypeLatticeElement memberTypeLattice;
    private final NullabilityVariants<ArrayTypeLatticeElement> variants;

    public static ArrayTypeLatticeElement create(TypeLatticeElement memberTypeLattice, Nullability nullability) {
        return NullabilityVariants.create(nullability, (NullabilityVariants<T> variants) -> new ArrayTypeLatticeElement(memberTypeLattice, nullability, (NullabilityVariants<ArrayTypeLatticeElement>)variants));
    }

    private ArrayTypeLatticeElement(TypeLatticeElement memberTypeLattice, Nullability nullability, NullabilityVariants<ArrayTypeLatticeElement> variants) {
        super(nullability);
        assert (memberTypeLattice.isPrimitive() || memberTypeLattice.nullability().isMaybeNull());
        this.memberTypeLattice = memberTypeLattice;
        this.variants = variants;
    }

    public DexType getArrayType(DexItemFactory factory) {
        DexType baseType;
        TypeLatticeElement baseTypeLattice = this.getArrayBaseTypeLattice();
        if (baseTypeLattice.isPrimitive()) {
            baseType = baseTypeLattice.asPrimitiveTypeLatticeElement().toDexType(factory);
        } else {
            assert (baseTypeLattice.isClassType());
            baseType = baseTypeLattice.asClassTypeLatticeElement().getClassType();
        }
        return factory.createArrayType(this.getNesting(), baseType);
    }

    int getNesting() {
        int nesting = 1;
        TypeLatticeElement member = this.getArrayMemberTypeAsMemberType();
        while (member.isArrayType()) {
            ++nesting;
            member = member.asArrayTypeLatticeElement().getArrayMemberTypeAsMemberType();
        }
        return nesting;
    }

    TypeLatticeElement getArrayMemberTypeAsMemberType() {
        return this.memberTypeLattice;
    }

    public TypeLatticeElement getArrayMemberTypeAsValueType() {
        return this.memberTypeLattice.isFineGrainedType() ? INT : this.memberTypeLattice;
    }

    private TypeLatticeElement getArrayBaseTypeLattice() {
        TypeLatticeElement base = this.getArrayMemberTypeAsMemberType();
        while (base.isArrayType()) {
            base = base.asArrayTypeLatticeElement().getArrayMemberTypeAsMemberType();
        }
        return base;
    }

    private ArrayTypeLatticeElement createVariant(Nullability nullability, NullabilityVariants<ArrayTypeLatticeElement> variants) {
        assert (this.nullability != nullability);
        return new ArrayTypeLatticeElement(this.memberTypeLattice, nullability, variants);
    }

    @Override
    public ReferenceTypeLatticeElement getOrCreateVariant(Nullability nullability) {
        ArrayTypeLatticeElement variant = this.variants.get(nullability);
        if (variant != null) {
            return variant;
        }
        return this.variants.getOrCreateElement(nullability, this::createVariant);
    }

    @Override
    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithSubtyping> appView) {
        return this.memberTypeLattice.isBasedOnMissingClass(appView);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return this;
    }

    @Override
    public String toString() {
        return this.nullability.toString() + " (" + this.memberTypeLattice.toString() + "[])";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayTypeLatticeElement)) {
            return false;
        }
        ArrayTypeLatticeElement other = (ArrayTypeLatticeElement)o;
        if (this.nullability() != other.nullability()) {
            return false;
        }
        return this.memberTypeLattice.equals(other.memberTypeLattice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nullability, this.memberTypeLattice);
    }

    ReferenceTypeLatticeElement join(ArrayTypeLatticeElement other, AppView<?> appView) {
        Nullability nullability = this.nullability().join(other.nullability());
        ReferenceTypeLatticeElement join = ArrayTypeLatticeElement.joinMember(this.memberTypeLattice, other.memberTypeLattice, appView, nullability);
        if (join == null) {
            if (other.nullability == nullability) {
                return other;
            }
            return this.getOrCreateVariant(nullability);
        }
        assert (join.nullability == nullability);
        return join;
    }

    private static ReferenceTypeLatticeElement joinMember(TypeLatticeElement aMember, TypeLatticeElement bMember, AppView<?> appView, Nullability nullability) {
        if (aMember.equals(bMember)) {
            return null;
        }
        if (aMember.isArrayType() && bMember.isArrayType()) {
            ReferenceTypeLatticeElement join = ArrayTypeLatticeElement.joinMember(aMember.asArrayTypeLatticeElement().memberTypeLattice, bMember.asArrayTypeLatticeElement().memberTypeLattice, appView, Nullability.maybeNull());
            return join == null ? null : ArrayTypeLatticeElement.create(join, nullability);
        }
        if (aMember.isClassType() && bMember.isClassType()) {
            ClassTypeLatticeElement join = aMember.asClassTypeLatticeElement().join(bMember.asClassTypeLatticeElement(), appView);
            return ArrayTypeLatticeElement.create(join, nullability);
        }
        if (aMember.isPrimitive() || bMember.isPrimitive()) {
            return TypeLatticeElement.objectClassType(appView, nullability);
        }
        return TypeLatticeElement.objectArrayType(appView, nullability);
    }
}

