/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.NullabilityVariants;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.utils.LRUCacheTable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassTypeLatticeElement
extends ReferenceTypeLatticeElement {
    private Set<DexType> lazyInterfaces;
    private AppView<? extends AppInfoWithSubtyping> appView;
    private final NullabilityVariants<ClassTypeLatticeElement> variants;
    private final DexType type;

    public static ClassTypeLatticeElement create(DexType classType, Nullability nullability, Set<DexType> interfaces) {
        assert (interfaces != null);
        return NullabilityVariants.create(nullability, variants -> new ClassTypeLatticeElement(classType, nullability, interfaces, (NullabilityVariants<ClassTypeLatticeElement>)variants, null));
    }

    public static ClassTypeLatticeElement create(DexType classType, Nullability nullability, AppView<? extends AppInfoWithSubtyping> appView) {
        assert (appView != null);
        return NullabilityVariants.create(nullability, variants -> new ClassTypeLatticeElement(classType, nullability, null, (NullabilityVariants<ClassTypeLatticeElement>)variants, appView));
    }

    private ClassTypeLatticeElement(DexType classType, Nullability nullability, Set<DexType> interfaces, NullabilityVariants<ClassTypeLatticeElement> variants, AppView<? extends AppInfoWithSubtyping> appView) {
        super(nullability);
        assert (classType.isClassType());
        assert (interfaces != null || appView != null);
        this.type = classType;
        this.appView = appView;
        this.lazyInterfaces = interfaces;
        this.variants = variants;
    }

    public DexType getClassType() {
        return this.type;
    }

    public Set<DexType> getInterfaces() {
        if (this.lazyInterfaces == null) {
            assert (this.appView != null);
            this.lazyInterfaces = this.appView.dexItemFactory().getOrComputeLeastUpperBoundOfImplementedInterfaces(this.type, this.appView);
        }
        assert (this.lazyInterfaces != null);
        return this.lazyInterfaces;
    }

    private ClassTypeLatticeElement createVariant(Nullability nullability, NullabilityVariants<ClassTypeLatticeElement> variants) {
        assert (this.nullability != nullability);
        return new ClassTypeLatticeElement(this.type, nullability, this.lazyInterfaces, variants, this.appView);
    }

    @Override
    public ReferenceTypeLatticeElement getOrCreateVariant(Nullability nullability) {
        ClassTypeLatticeElement variant = this.variants.get(nullability);
        if (variant != null) {
            return variant;
        }
        return this.variants.getOrCreateElement(nullability, this::createVariant);
    }

    @Override
    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithSubtyping> appView) {
        return appView.appInfo().isMissingOrHasMissingSuperType(this.getClassType()) || this.getInterfaces().stream().anyMatch(type -> ((AppInfoWithSubtyping)appView.appInfo()).isMissingOrHasMissingSuperType((DexType)type));
    }

    @Override
    public boolean isClassType() {
        return true;
    }

    @Override
    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nullability);
        builder.append(" ");
        builder.append(this.type);
        builder.append(" {");
        Set<DexType> interfaces = this.getInterfaces();
        if (interfaces != null) {
            builder.append(interfaces.stream().map(DexType::toString).collect(Collectors.joining(", ")));
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nullability, this.type);
    }

    ClassTypeLatticeElement join(ClassTypeLatticeElement other, AppView<?> appView) {
        Nullability nullability = this.nullability().join(other.nullability());
        if (!((AppInfo)appView.appInfo()).hasSubtyping()) {
            assert (this.lazyInterfaces != null && this.lazyInterfaces.isEmpty());
            assert (other.lazyInterfaces != null && other.lazyInterfaces.isEmpty());
            return ClassTypeLatticeElement.create(this.getClassType() == other.getClassType() ? this.getClassType() : appView.dexItemFactory().objectType, nullability, Collections.emptySet());
        }
        DexType lubType = ((AppInfo)appView.appInfo()).withSubtyping().computeLeastUpperBoundOfClasses(this.getClassType(), other.getClassType());
        Set<DexType> c1lubItfs = this.getInterfaces();
        Set<DexType> c2lubItfs = other.getInterfaces();
        Set<DexType> lubItfs = null;
        if (c1lubItfs.size() == c2lubItfs.size() && c1lubItfs.containsAll(c2lubItfs)) {
            lubItfs = c1lubItfs;
        }
        if (lubItfs == null) {
            lubItfs = ClassTypeLatticeElement.computeLeastUpperBoundOfInterfaces(appView.withSubtyping(), c1lubItfs, c2lubItfs);
        }
        return ClassTypeLatticeElement.create(lubType, nullability, lubItfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DexType> computeLeastUpperBoundOfInterfaces(AppView<? extends AppInfoWithSubtyping> appView, Set<DexType> s1, Set<DexType> s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return Collections.emptySet();
        }
        Set<DexType> cached = appView.dexItemFactory().leastUpperBoundOfInterfacesTable.get(s1, s2);
        if (cached != null) {
            return cached;
        }
        cached = appView.dexItemFactory().leastUpperBoundOfInterfacesTable.get(s2, s1);
        if (cached != null) {
            return cached;
        }
        IdentityHashMap<DexType, Set> seen = new IdentityHashMap<DexType, Set>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        for (DexType itf1 : s1) {
            worklist.add(new InterfaceWithMarker(itf1, InterfaceMarker.LEFT));
        }
        for (DexType itf2 : s2) {
            worklist.add(new InterfaceWithMarker(itf2, InterfaceMarker.RIGHT));
        }
        while (!worklist.isEmpty()) {
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf = item.itf;
            InterfaceMarker interfaceMarker = item.marker;
            Object markers = seen.computeIfAbsent(itf, k -> new HashSet());
            if (markers.contains((Object)interfaceMarker)) continue;
            if (markers.size() == 1) {
                markers.add(interfaceMarker);
                continue;
            }
            markers.add(interfaceMarker);
            DexClass itfClass = appView.definitionFor(itf);
            if (itfClass == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                markers = seen.computeIfAbsent(superItf, k -> new HashSet());
                if (markers.contains((Object)interfaceMarker)) continue;
                worklist.add(new InterfaceWithMarker(superItf, interfaceMarker));
            }
        }
        ImmutableSet.Builder commonBuilder = ImmutableSet.builder();
        for (Map.Entry entry : seen.entrySet()) {
            if (((Set)entry.getValue()).size() < 2) continue;
            commonBuilder.add((DexType)entry.getKey());
        }
        ImmutableCollection commonlyVisited = commonBuilder.build();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType itf : commonlyVisited) {
            boolean notTheLeast = false;
            for (DexType other : commonlyVisited) {
                if (!appView.appInfo().isStrictSubtypeOf(other, itf)) continue;
                notTheLeast = true;
                break;
            }
            if (notTheLeast) continue;
            builder.add(itf);
        }
        ImmutableCollection lub = builder.build();
        if (s1.size() != s2.size() || !s1.containsAll(s2)) {
            LRUCacheTable<Set<DexType>, Set<DexType>, Set<DexType>> lRUCacheTable = appView.dexItemFactory().leastUpperBoundOfInterfacesTable;
            synchronized (lRUCacheTable) {
                appView.dexItemFactory().leastUpperBoundOfInterfacesTable.put(s1, s2, (Set<DexType>)((Object)lub));
            }
        }
        return lub;
    }

    @Override
    public boolean equals(Object o) {
        Set<DexType> otherInterfaces;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassTypeLatticeElement)) {
            return false;
        }
        ClassTypeLatticeElement other = (ClassTypeLatticeElement)o;
        if (this.nullability() != other.nullability()) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        Set<DexType> thisInterfaces = this.getInterfaces();
        if (thisInterfaces == (otherInterfaces = other.getInterfaces())) {
            return true;
        }
        if (thisInterfaces.size() != otherInterfaces.size()) {
            return false;
        }
        return thisInterfaces.containsAll(otherInterfaces);
    }

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static enum InterfaceMarker {
        LEFT,
        RIGHT;

    }
}

