/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;

public class Nullability {
    private static final Nullability DEFINITELY_NULL = new Nullability();
    private static final Nullability DEFINITELY_NOT_NULL = new Nullability();
    private static final Nullability MAYBE_NULL = new Nullability();
    private static final Nullability BOTTOM = new Nullability();

    private Nullability() {
    }

    public boolean isDefinitelyNull() {
        return this == DEFINITELY_NULL;
    }

    public boolean isDefinitelyNotNull() {
        return this == DEFINITELY_NOT_NULL;
    }

    public boolean isMaybeNull() {
        return this == MAYBE_NULL;
    }

    public boolean isNullable() {
        return this.isMaybeNull() || this.isDefinitelyNull();
    }

    public Nullability join(Nullability other) {
        if (this == BOTTOM) {
            return other;
        }
        if (other == BOTTOM) {
            return this;
        }
        if (this == other) {
            return this;
        }
        return MAYBE_NULL;
    }

    public boolean lessThanOrEqual(Nullability other) {
        return this.join(other) == other;
    }

    public static Nullability definitelyNull() {
        return DEFINITELY_NULL;
    }

    public static Nullability definitelyNotNull() {
        return DEFINITELY_NOT_NULL;
    }

    public static Nullability maybeNull() {
        return MAYBE_NULL;
    }

    public static Nullability bottom() {
        return BOTTOM;
    }

    public String toString() {
        if (this == MAYBE_NULL) {
            return "@Nullable";
        }
        if (this == DEFINITELY_NULL) {
            return "@Null";
        }
        if (this == DEFINITELY_NOT_NULL) {
            return "@NotNull";
        }
        if (this == BOTTOM) {
            return "@Bottom";
        }
        throw new Unreachable("Unknown Nullability.");
    }
}

