/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import java.util.function.BiFunction;
import java.util.function.Function;

public class NullabilityVariants<T extends ReferenceTypeLatticeElement> {
    private T maybeNullVariant;
    private T definitelyNullVariant;
    private T definitelyNotNullVariant;

    public static <T extends ReferenceTypeLatticeElement> T create(Nullability nullability, Function<NullabilityVariants<T>, T> callback) {
        NullabilityVariants<T> variants = new NullabilityVariants<T>();
        ReferenceTypeLatticeElement newElement = (ReferenceTypeLatticeElement)callback.apply(variants);
        super.set(nullability, newElement);
        return (T)newElement;
    }

    private void set(Nullability nullability, T element) {
        if (nullability == Nullability.maybeNull()) {
            this.maybeNullVariant = element;
        } else if (nullability == Nullability.definitelyNull()) {
            this.definitelyNullVariant = element;
        } else {
            assert (nullability == Nullability.definitelyNotNull());
            this.definitelyNotNullVariant = element;
        }
    }

    T get(Nullability nullability) {
        if (nullability == Nullability.maybeNull()) {
            return this.maybeNullVariant;
        }
        if (nullability == Nullability.definitelyNull()) {
            return this.definitelyNullVariant;
        }
        assert (nullability == Nullability.definitelyNotNull());
        return this.definitelyNotNullVariant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getOrCreateElement(Nullability nullability, BiFunction<Nullability, NullabilityVariants<T>, T> creator) {
        Object element = this.get(nullability);
        if (element != null) {
            return element;
        }
        NullabilityVariants nullabilityVariants = this;
        synchronized (nullabilityVariants) {
            element = this.get(nullability);
            if (element != null) {
                return element;
            }
            element = (ReferenceTypeLatticeElement)creator.apply(nullability, this);
            assert (element != null);
            this.set(nullability, element);
            return element;
        }
    }
}

