/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;

public class TypeAnalysis {
    private final boolean mayHaveImpreciseTypes;
    private Mode mode = Mode.UNSET;
    private final AppView<?> appView;
    private final DexEncodedMethod context;
    private final Deque<Value> worklist = new ArrayDeque<Value>();

    public TypeAnalysis(AppView<?> appView, DexEncodedMethod encodedMethod) {
        this(appView, encodedMethod, false);
    }

    public TypeAnalysis(AppView<?> appView, DexEncodedMethod encodedMethod, boolean mayHaveImpreciseTypes) {
        this.appView = appView;
        this.context = encodedMethod;
        this.mayHaveImpreciseTypes = mayHaveImpreciseTypes;
    }

    private void analyze() {
        while (!this.worklist.isEmpty()) {
            this.analyzeValue(this.worklist.poll());
        }
    }

    public void widening(DexEncodedMethod encodedMethod, IRCode code) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        code.topologicallySortedBlocks().forEach(b -> this.analyzeBasicBlock(encodedMethod, (BasicBlock)b));
        this.analyze();
    }

    public void widening(Iterable<Value> values2) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        values2.forEach(this::enqueue);
        this.analyze();
    }

    public void narrowing(Iterable<Value> values2) {
        ArrayList<Value> sortedValues = Lists.newArrayList(values2);
        sortedValues.sort(Comparator.comparingInt(Value::getNumber));
        this.mode = Mode.NARROWING;
        assert (this.worklist.isEmpty());
        sortedValues.forEach(this::enqueue);
        this.analyze();
    }

    private void enqueue(Value v) {
        assert (v != null);
        if (!this.worklist.contains(v)) {
            this.worklist.add(v);
        }
    }

    public void analyzeBasicBlock(DexEncodedMethod encodedMethod, BasicBlock block) {
        int argumentsSeen = encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            TypeLatticeElement derived;
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            if (instruction.isArgument()) {
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(encodedMethod.method.holder, encodedMethod == this.context ? Nullability.definitelyNotNull() : Nullability.maybeNull(), this.appView);
                } else {
                    DexType argType = encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(argType, Nullability.maybeNull(), this.appView);
                }
                ++argumentsSeen;
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            if (instruction.hasInvariantOutType()) {
                derived = instruction.evaluate(this.appView);
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            this.enqueue(outValue);
        }
        for (Phi phi : block.getPhis()) {
            this.enqueue(phi);
        }
    }

    private void analyzeValue(Value value) {
        TypeLatticeElement derived;
        TypeLatticeElement previous = value.getTypeLattice();
        TypeLatticeElement typeLatticeElement = derived = value.isPhi() ? value.asPhi().computePhiType(this.appView) : value.definition.evaluate(this.appView);
        assert (this.mayHaveImpreciseTypes || derived.isPreciseType());
        assert (!previous.isPreciseType() || derived.isPreciseType());
        this.updateTypeOfValue(value, derived);
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        assert (this.mode != Mode.UNSET);
        TypeLatticeElement current = value.getTypeLattice();
        if (current.equals(type)) {
            return;
        }
        if (type.isBottom()) {
            return;
        }
        if (this.mode == Mode.WIDENING) {
            value.widening(this.appView, type);
        } else {
            assert (this.mode == Mode.NARROWING);
            value.narrowing(this.appView, type);
        }
        for (Instruction instruction : value.uniqueUsers()) {
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            this.enqueue(outValue);
        }
        for (Phi phi : value.uniquePhiUsers()) {
            this.enqueue(phi);
        }
    }

    public static DexType getRefinedReceiverType(AppView<? extends AppInfoWithSubtyping> appView, InvokeMethodWithReceiver invoke) {
        TypeLatticeElement lattice;
        Value receiver = invoke.getReceiver();
        Value aliasedValue = receiver.getSpecificAliasedValue(value -> !value.isPhi() && value.definition.isAssumeDynamicType());
        if (aliasedValue != null) {
            lattice = aliasedValue.definition.asAssumeDynamicType().getAssumption().getType();
            assert (lattice.lessThanOrEqualUpToNullability(receiver.getTypeLattice(), appView));
        } else {
            lattice = receiver.getTypeLattice();
        }
        DexType staticReceiverType = invoke.getInvokedMethod().holder;
        if (lattice.isClassType()) {
            DexType refinedType = lattice.asClassTypeLatticeElement().getClassType();
            if (appView.appInfo().isSubtype(refinedType, staticReceiverType)) {
                return refinedType;
            }
        }
        return staticReceiverType;
    }

    private static enum Mode {
        UNSET,
        WIDENING,
        NARROWING;

    }
}

