/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BooleanTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ByteTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.CharTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ShortTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.SingleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.WideTypeLatticeElement;

public abstract class TypeLatticeElement {
    public static final BottomTypeLatticeElement BOTTOM = BottomTypeLatticeElement.getInstance();
    public static final TopTypeLatticeElement TOP = TopTypeLatticeElement.getInstance();
    static final BooleanTypeLatticeElement BOOLEAN = BooleanTypeLatticeElement.getInstance();
    static final ByteTypeLatticeElement BYTE = ByteTypeLatticeElement.getInstance();
    static final ShortTypeLatticeElement SHORT = ShortTypeLatticeElement.getInstance();
    static final CharTypeLatticeElement CHAR = CharTypeLatticeElement.getInstance();
    public static final IntTypeLatticeElement INT = IntTypeLatticeElement.getInstance();
    public static final FloatTypeLatticeElement FLOAT = FloatTypeLatticeElement.getInstance();
    public static final SingleTypeLatticeElement SINGLE = SingleTypeLatticeElement.getInstance();
    public static final LongTypeLatticeElement LONG = LongTypeLatticeElement.getInstance();
    public static final DoubleTypeLatticeElement DOUBLE = DoubleTypeLatticeElement.getInstance();
    public static final WideTypeLatticeElement WIDE = WideTypeLatticeElement.getInstance();
    public static final ReferenceTypeLatticeElement NULL = ReferenceTypeLatticeElement.getNullTypeLatticeElement();

    public boolean isNullable() {
        return this.nullability().isNullable();
    }

    public abstract Nullability nullability();

    public TypeLatticeElement join(TypeLatticeElement other, AppView<?> appView) {
        if (this == other) {
            return this;
        }
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isPrimitive()) {
            return other.isPrimitive() ? this.asPrimitiveTypeLatticeElement().join(other.asPrimitiveTypeLatticeElement()) : TOP;
        }
        if (other.isPrimitive()) {
            return TOP;
        }
        assert (this.isReference() && other.isReference());
        assert (this.isPreciseType() && other.isPreciseType());
        Nullability nullabilityJoin = this.nullability().join(other.nullability());
        if (this.isNullType()) {
            return other.asReferenceTypeLatticeElement().getOrCreateVariant(nullabilityJoin);
        }
        if (other.isNullType()) {
            return this.asReferenceTypeLatticeElement().getOrCreateVariant(nullabilityJoin);
        }
        if (this.getClass() != other.getClass()) {
            return TypeLatticeElement.objectClassType(appView, nullabilityJoin);
        }
        if (this.isArrayType()) {
            assert (other.isArrayType());
            return this.asArrayTypeLatticeElement().join(other.asArrayTypeLatticeElement(), appView);
        }
        if (this.isClassType()) {
            assert (other.isClassType());
            return this.asClassTypeLatticeElement().join(other.asClassTypeLatticeElement(), appView);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    public static TypeLatticeElement join(Iterable<TypeLatticeElement> typeLattices, AppView<?> appView) {
        TypeLatticeElement result = BOTTOM;
        for (TypeLatticeElement other : typeLattices) {
            result = result.join(other, appView);
        }
        return result;
    }

    public boolean strictlyLessThan(TypeLatticeElement other, AppView<?> appView) {
        if (this.equals(other)) {
            return false;
        }
        TypeLatticeElement lub = this.join(other, appView);
        return !this.equals(lub) && other.equals(lub);
    }

    public boolean lessThanOrEqual(TypeLatticeElement other, AppView<?> appView) {
        return this.equals(other) || this.strictlyLessThan(other, appView);
    }

    public boolean lessThanOrEqualUpToNullability(TypeLatticeElement other, AppView<?> appView) {
        if (this == other) {
            return true;
        }
        if (this.isPrimitive()) {
            return this.lessThanOrEqual(other, appView);
        }
        assert (this.isReference() && other.isReference());
        ReferenceTypeLatticeElement otherAsNullable = other.isNullable() ? other.asReferenceTypeLatticeElement() : other.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        return this.lessThanOrEqual(otherAsNullable, appView);
    }

    public boolean equalUpToNullability(TypeLatticeElement other) {
        if (this == other) {
            return true;
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            return false;
        }
        assert (this.isReference() && other.isReference());
        ReferenceTypeLatticeElement thisAsMaybeNull = this.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        ReferenceTypeLatticeElement otherAsMaybeNull = other.asReferenceTypeLatticeElement().getOrCreateVariant(Nullability.maybeNull());
        return thisAsMaybeNull.equals(otherAsMaybeNull);
    }

    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithSubtyping> appView) {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public ReferenceTypeLatticeElement asReferenceTypeLatticeElement() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    boolean isBoolean() {
        return false;
    }

    boolean isByte() {
        return false;
    }

    boolean isShort() {
        return false;
    }

    boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isNullType() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble() || this.isBottom();
    }

    public boolean isFineGrainedType() {
        return this.isBoolean() || this.isByte() || this.isShort() || this.isChar();
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isDefinitelyNull() {
        return this.nullability().isDefinitelyNull();
    }

    public boolean isDefinitelyNotNull() {
        return this.nullability().isDefinitelyNotNull();
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return this.isWide() ? 2 : 1;
    }

    public static ClassTypeLatticeElement objectClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().objectType, nullability, appView).asClassTypeLatticeElement();
    }

    static ArrayTypeLatticeElement objectArrayType(AppView<?> appView, Nullability nullability) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return TypeLatticeElement.fromDexType(dexItemFactory.createArrayType(1, dexItemFactory.objectType), nullability, appView).asArrayTypeLatticeElement();
    }

    public static ClassTypeLatticeElement classClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().classType, nullability, appView).asClassTypeLatticeElement();
    }

    public static ClassTypeLatticeElement stringClassType(AppView<?> appView, Nullability nullability) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().stringType, nullability, appView).asClassTypeLatticeElement();
    }

    public static TypeLatticeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView) {
        return TypeLatticeElement.fromDexType(type, nullability, appView, false);
    }

    public static TypeLatticeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView, boolean asArrayElementType) {
        if (type == DexItemFactory.nullValueType) {
            assert (!nullability.isDefinitelyNotNull());
            return NULL;
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type, asArrayElementType);
        }
        return appView.dexItemFactory().createReferenceTypeLatticeElement(type, nullability, appView);
    }

    public boolean isValueTypeCompatible(TypeLatticeElement other) {
        return this.isReference() && other.isReference() || this.isSingle() && other.isSingle() || this.isWide() && other.isWide();
    }

    public TypeLatticeElement checkCast(AppView<?> appView, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, this.nullability(), appView);
        if (this.lessThanOrEqual(castTypeLattice, appView)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

