/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class Assume<An extends Assumption>
extends Instruction {
    private static final String ERROR_MESSAGE = "Expected Assume instructions to be removed after IR processing.";
    private final An assumption;
    private final Instruction origin;

    private Assume(An assumption, Value dest, Value src, Instruction origin, AppView<?> appView) {
        super(dest, src);
        assert (assumption != null);
        assert (((Assumption)assumption).verifyCorrectnessOfValues(dest, src, appView));
        this.assumption = assumption;
        this.origin = origin;
    }

    public static Assume<NonNullAssumption> createAssumeNonNullInstruction(Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume<NonNullAssumption>(NonNullAssumption.get(), dest, src, origin, appView);
    }

    public static Assume<DynamicTypeAssumption> createAssumeDynamicTypeInstruction(TypeLatticeElement type, Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume<DynamicTypeAssumption>(new DynamicTypeAssumption(type), dest, src, origin, appView);
    }

    public boolean verifyInstructionIsNeeded(AppView<?> appView) {
        if (this.isAssumeDynamicType()) assert (((Assumption)this.assumption).verifyCorrectnessOfValues(this.outValue(), this.src(), appView));
        return true;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public An getAssumption() {
        return this.assumption;
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public Instruction origin() {
        return this.origin;
    }

    @Override
    public String getInstructionName() {
        if (this.isAssumeDynamicType()) {
            return "AssumeDynamicType";
        }
        if (this.isAssumeNonNull()) {
            return "AssumeNonNull";
        }
        throw new Unimplemented();
    }

    @Override
    public boolean isAssume() {
        return true;
    }

    public Assume<An> asAssume() {
        return this;
    }

    @Override
    public boolean isAssumeDynamicType() {
        return ((Assumption)this.assumption).isAssumeDynamicType();
    }

    @Override
    public Assume<DynamicTypeAssumption> asAssumeDynamicType() {
        assert (this.isAssumeDynamicType());
        Assume self = this;
        return self;
    }

    @Override
    public boolean isAssumeNonNull() {
        return ((Assumption)this.assumption).isAssumeNonNull();
    }

    @Override
    public Assume<NonNullAssumption> asAssumeNonNull() {
        assert (this.isAssumeNonNull());
        Assume self = this;
        return self;
    }

    @Override
    public boolean isIntroducingAnAlias() {
        return true;
    }

    @Override
    public boolean couldIntroduceAnAlias() {
        return true;
    }

    @Override
    public Value getAliasForOutValue() {
        return this.src();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean isOutConstant() {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isAssume()) {
            return false;
        }
        Assume<?> assumeInstruction = other.asAssume();
        return this.assumption.equals(assumeInstruction.assumption);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forAssume();
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        if (((Assumption)this.assumption).isAssumeDynamicType()) {
            return this.src().getTypeLattice();
        }
        if (((Assumption)this.assumption).isAssumeNonNull()) {
            assert (this.src().getTypeLattice().isReference());
            return this.src().getTypeLattice().asReferenceTypeLatticeElement().asNotNull();
        }
        throw new Unimplemented();
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return helper.getDexType(this.src());
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public String toString() {
        if (this.isAssumeDynamicType()) {
            return super.toString() + "; type: " + this.asAssumeDynamicType().getAssumption().type;
        }
        if (this.isAssumeNonNull()) {
            return super.toString() + "; not null";
        }
        return super.toString();
    }

    public static class NonNullAssumption
    extends Assumption {
        private static final NonNullAssumption instance = new NonNullAssumption();

        private NonNullAssumption() {
        }

        public static NonNullAssumption get() {
            return instance;
        }

        @Override
        public boolean isAssumeNonNull() {
            return true;
        }

        @Override
        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (!src.isNeverNull());
            return true;
        }
    }

    public static class DynamicTypeAssumption
    extends Assumption {
        private final TypeLatticeElement type;

        private DynamicTypeAssumption(TypeLatticeElement type) {
            this.type = type;
        }

        public TypeLatticeElement getType() {
            return this.type;
        }

        @Override
        public boolean isAssumeDynamicType() {
            return true;
        }

        @Override
        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (this.type.lessThanOrEqualUpToNullability(src.getTypeLattice(), appView));
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            DynamicTypeAssumption assumption = (DynamicTypeAssumption)other;
            return this.type == assumption.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    static abstract class Assumption {
        Assumption() {
        }

        public boolean isAssumeDynamicType() {
            return false;
        }

        public boolean isAssumeNonNull() {
            return false;
        }

        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            return true;
        }
    }
}

