/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstMethodHandle;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class ConstMethodHandle
extends ConstInstruction {
    private final DexMethodHandle methodHandle;

    public ConstMethodHandle(Value dest, DexMethodHandle methodHandle) {
        super(dest);
        this.methodHandle = methodHandle;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static ConstMethodHandle copyOf(IRCode code, ConstMethodHandle original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstMethodHandle.copyOf(newValue, original);
    }

    public static ConstMethodHandle copyOf(Value newValue, ConstMethodHandle original) {
        return new ConstMethodHandle(newValue, original.getValue());
    }

    public Value dest() {
        return this.outValue;
    }

    public DexMethodHandle getValue() {
        return this.methodHandle;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstMethodHandle(dest, this.methodHandle));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstMethodHandle(this.methodHandle));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstMethodHandle() && other.asConstMethodHandle().methodHandle == this.methodHandle;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstMethodHandle has no register arguments.";
        return 0;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forConstMethodHandle();
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.methodHandle + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstMethodHandle() {
        return true;
    }

    @Override
    public ConstMethodHandle asConstMethodHandle() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().methodHandleType, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().methodHandleType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }
}

