/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;

public class DexItemBasedConstString
extends ConstInstruction {
    private final DexReference item;
    private final ReflectionOptimizer.ClassNameComputationInfo classNameComputationInfo;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public DexItemBasedConstString(Value dest, DexReference item, BasicBlock.ThrowingInfo throwingInfo) {
        this(dest, item, throwingInfo, ReflectionOptimizer.ClassNameComputationInfo.none());
    }

    public DexItemBasedConstString(Value dest, DexReference item, BasicBlock.ThrowingInfo throwingInfo, ReflectionOptimizer.ClassNameComputationInfo classNameComputationInfo) {
        super(dest);
        this.item = item;
        this.classNameComputationInfo = classNameComputationInfo;
        this.throwingInfo = throwingInfo;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static DexItemBasedConstString copyOf(Value newValue, DexItemBasedConstString original) {
        return new DexItemBasedConstString(newValue, original.getItem(), original.throwingInfo, original.classNameComputationInfo);
    }

    public DexReference getItem() {
        return this.item;
    }

    public ReflectionOptimizer.ClassNameComputationInfo getClassNameComputationInfo() {
        return this.classNameComputationInfo;
    }

    @Override
    public boolean isDexItemBasedConstString() {
        return true;
    }

    @Override
    public DexItemBasedConstString asDexItemBasedConstString() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.DexItemBasedConstString(dest, this.item, this.classNameComputationInfo));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isDexItemBasedConstString() && other.asDexItemBasedConstString().item == this.item;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "DexItemBasedConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.item.toSourceString() + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return this.throwingInfo == BasicBlock.ThrowingInfo.CAN_THROW;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return false;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfDexItemBasedConstString(this.item, this.classNameComputationInfo));
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().stringType;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }
}

