/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.AbstractError;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import java.util.Collections;
import java.util.List;

public abstract class FieldInstruction
extends Instruction {
    private MemberType type;
    private final DexField field;

    protected FieldInstruction(DexField field, Value dest, Value value) {
        this(field, dest, Collections.singletonList(value));
    }

    protected FieldInstruction(DexField field, Value dest, List<Value> inValues) {
        super(dest, inValues);
        assert (field != null);
        this.field = field;
        this.type = MemberType.fromDexType(field.type);
    }

    public MemberType getType() {
        return this.type;
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public FieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public AbstractError instructionInstanceCanThrow(AppView<?> appView, DexType context) {
        Value receiver;
        if (!appView.enableWholeProgramOptimizations()) {
            return AbstractError.top();
        }
        DexEncodedField resolvedField = ((AppInfo)appView.appInfo()).resolveField(this.getField());
        if (resolvedField == null) {
            return AbstractError.specific(appView.dexItemFactory().noSuchFieldErrorType);
        }
        if (resolvedField.isStaticMember() ? this.isInstanceGet() || this.isInstancePut() : this.isStaticGet() || this.isStaticPut()) {
            return AbstractError.specific(appView.dexItemFactory().icceType);
        }
        if (!MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appView, context, resolvedField.field.holder, resolvedField.accessFlags)) {
            return AbstractError.specific(appView.dexItemFactory().illegalAccessErrorType);
        }
        if ((this.isInstanceGet() || this.isInstancePut()) && ((receiver = (Value)this.inValues.get(0)).isAlwaysNull(appView) || receiver.typeLattice.isNullable())) {
            return AbstractError.specific(appView.dexItemFactory().npeType);
        }
        if (this.field.holder.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue())) {
            return AbstractError.top();
        }
        return AbstractError.bottom();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }
}

