/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IRCodeInstructionsIterator
implements InstructionIterator {
    private final ListIterator<BasicBlock> blockIterator;
    private InstructionListIterator instructionIterator;

    public IRCodeInstructionsIterator(IRCode code) {
        this.blockIterator = code.listIterator();
        this.instructionIterator = this.blockIterator.next().listIterator();
    }

    @Override
    public boolean hasNext() {
        return this.instructionIterator.hasNext() || this.blockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        if (this.instructionIterator.hasNext()) {
            return (Instruction)this.instructionIterator.next();
        }
        if (!this.blockIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.instructionIterator = this.blockIterator.next().listIterator();
        assert (this.instructionIterator.hasNext());
        return (Instruction)this.instructionIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.instructionIterator.hasPrevious() || this.blockIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        if (this.instructionIterator.hasPrevious()) {
            return (Instruction)this.instructionIterator.previous();
        }
        if (!this.blockIterator.hasPrevious()) {
            throw new NoSuchElementException();
        }
        BasicBlock block = this.blockIterator.previous();
        this.instructionIterator = block.listIterator(block.getInstructions().size());
        assert (this.instructionIterator.hasPrevious());
        return (Instruction)this.instructionIterator.previous();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Instruction instruction) {
        this.instructionIterator.add(instruction);
    }

    @Override
    public void remove() {
        this.instructionIterator.remove();
    }

    @Override
    public void set(Instruction instruction) {
        this.instructionIterator.set(instruction);
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        this.instructionIterator.replaceCurrentInstruction(newInstruction);
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        this.instructionIterator.removeOrReplaceByDebugLocalRead();
    }
}

