/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeInterfaceRange;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collection;
import java.util.List;

public class InvokeInterface
extends InvokeMethodWithReceiver {
    public InvokeInterface(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.INTERFACE;
    }

    @Override
    protected String getTypeString() {
        return "Interface";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeInterfaceRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeInterface(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeInterface() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeInterface() {
        return true;
    }

    @Override
    public InvokeInterface asInvokeInterface() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(AppView<AppInfoWithLiveness> appView, DexType invocationContext) {
        DexType refinedReceiverType = TypeAnalysis.getRefinedReceiverType(appView, this);
        DexMethod method = this.getInvokedMethod();
        return appView.appInfo().lookupSingleInterfaceTarget(method, refinedReceiverType);
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppView<? extends AppInfoWithSubtyping> appView, DexType invocationContext) {
        return appView.appInfo().lookupInterfaceTargets(this.getInvokedMethod());
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeInterface(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(185, this.getInvokedMethod(), true));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeInterface(this, clazz, context, appView, mode, assumption);
    }
}

