/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfMultiANewArray;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.List;

public class InvokeMultiNewArray
extends Invoke {
    private final DexType type;

    public InvokeMultiNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isInvokeMultiNewArray() {
        return true;
    }

    @Override
    public InvokeMultiNewArray asInvokeMultiNewArray() {
        return this;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.MULTI_NEW_ARRAY;
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    @Override
    protected String getTypeString() {
        return "MultiNewArray";
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMultiNewArray() && this.type == other.asInvokeMultiNewArray().type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeMultiNewArray(this.type, invocationContext);
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMultiANewArray(this.type, this.arguments().size()));
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to dex files.");
    }
}

