/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Arrays;

public class NewArrayFilledData
extends Instruction {
    private static final String ERROR_MESSAGE = "Conversion from DEX to classfile not supported for NewArrayFilledData";
    public final int element_width;
    public final long size;
    public final short[] data;

    public NewArrayFilledData(Value src, int element_width, long size, short[] data) {
        super(null, src);
        this.element_width = element_width;
        this.size = size;
        this.data = data;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public FillArrayDataPayload createPayload() {
        return new FillArrayDataPayload(this.element_width, this.size, this.data);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int src = builder.allocatedRegister(this.src(), this.getNumber());
        builder.addFillArrayData(this, new FillArrayData(src));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isNewArrayFilledData()) {
            return false;
        }
        NewArrayFilledData o = other.asNewArrayFilledData();
        return o.element_width == this.element_width && o.size == this.size && Arrays.equals(o.data, this.data);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "NewArrayFilledData defines no values.";
        return 0;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        if (!this.src().getTypeLattice().isNullable() && this.src().numberOfAllUsers() == 1) {
            assert (this.src().uniqueUsers().iterator().next() == this);
            assert (this.src().definition != null);
            assert (this.src().definition.isNewArrayEmpty());
            return true;
        }
        return false;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isNewArrayFilledData() {
        return true;
    }

    @Override
    public NewArrayFilledData asNewArrayFilledData() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forNewArrayFilledData();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }
}

