/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;

public class NewInstance
extends Instruction {
    public final DexType clazz;
    private boolean allowSpilling = true;

    public NewInstance(DexType clazz, Value dest) {
        super(dest);
        assert (clazz != null);
        this.clazz = clazz;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.NewInstance(dest, this.clazz));
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.clazz;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isNewInstance() && other.asNewInstance().clazz == this.clazz;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "NewInstance has no register arguments";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isNewInstance() {
        return true;
    }

    @Override
    public NewInstance asNewInstance() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forNewInstance(this.clazz, invocationContext);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfNew(this.clazz));
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.clazz;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.clazz, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forNewInstance(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (this.clazz.isPrimitiveType() || this.clazz.isArrayType()) {
            assert (false) : "Unexpected new-instance instruction with primitive or array type";
            return true;
        }
        DexClass definition = appView.definitionFor(this.clazz);
        if (definition == null || definition.accessFlags.isAbstract()) {
            return true;
        }
        if (definition.isLibraryClass() && !appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(this.clazz)) {
            return true;
        }
        if (((AppInfo)appView.appInfo()).hasSubtyping() && !MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appView, context, definition.type, definition.accessFlags)) {
            return true;
        }
        return definition.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue());
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    public void markNoSpilling() {
        this.allowSpilling = false;
    }

    public boolean isSpillingAllowed() {
        return this.allowSpilling;
    }
}

